/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.mozilla.universalchardet.UniversalDetector;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.ByteBuffer;
import workbench.util.EncodingUtil;
import workbench.util.FileVersioner;
import workbench.util.StringUtil;
import workbench.util.UnicodeReader;
import workbench.util.WbFile;

public class FileUtil {
    private static final int BUFF_SIZE = 0x200000;

    public static void closeStreams(Collection<Closeable> collection) {
        if (collection == null) {
            return;
        }
        for (Closeable closeable : collection) {
            try {
                FileUtil.closeQuietely(closeable);
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Error when closing stream", exception);
            }
        }
    }

    public static List<String> getLines(BufferedReader bufferedReader) {
        return FileUtil.getLines(bufferedReader, false);
    }

    public static List<String> getLines(BufferedReader bufferedReader, boolean bl) {
        return FileUtil.getLines(bufferedReader, bl, false);
    }

    public static List<String> getLines(BufferedReader bufferedReader, boolean bl, boolean bl2) {
        return FileUtil.getLines(bufferedReader, bl, bl2, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLines(BufferedReader bufferedReader, boolean bl, boolean bl2, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (StringUtil.isNonEmpty(string)) {
                    if (bl2 && string.trim().startsWith("#")) continue;
                    arrayList.add(bl ? string.trim() : string);
                }
                if (arrayList.size() <= n) continue;
                break;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error reading lines", exception);
        }
        finally {
            FileUtil.closeQuietely(bufferedReader);
        }
        return arrayList;
    }

    public static int readLines(BufferedReader bufferedReader, StringBuilder stringBuilder, int n, String string) throws IOException {
        int n2 = 0;
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append(string);
            if (++n2 >= n) break;
            string2 = bufferedReader.readLine();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLineEnding(File file, String string) {
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = EncodingUtil.createBufferedReader(file, string);
            string2 = FileUtil.getLineEnding(bufferedReader);
            if (string2 == null) {
                string2 = StringUtil.LINE_TERMINATOR;
            }
        }
        catch (IOException iOException) {
            string2 = StringUtil.LINE_TERMINATOR;
        }
        finally {
            FileUtil.closeQuietely(bufferedReader);
        }
        return string2;
    }

    public static String getLineEnding(Reader reader) throws IOException {
        String string = null;
        int n = reader.read();
        while (n != -1) {
            if (n == 13) {
                char c = (char)reader.read();
                if (c == '\n') {
                    string = "\r\n";
                    break;
                }
            } else if (n == 10) {
                string = "\n";
                break;
            }
            n = reader.read();
        }
        return string;
    }

    public static long estimateRecords(File file) throws IOException {
        return FileUtil.estimateRecords(file, 5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long estimateRecords(File file, long l) throws IOException {
        long l2;
        String string;
        int n;
        int n2;
        if (l <= 0L) {
            throw new IllegalArgumentException("Sample size must be greater then zero");
        }
        if (!file.exists()) {
            return -1L;
        }
        if (!file.isFile()) {
            return -1L;
        }
        long l3 = file.length();
        if (l3 == 0L) {
            return 0L;
        }
        long l4 = 0L;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file), 262144);
            bufferedReader.readLine();
            n2 = StringUtil.LINE_TERMINATOR.length();
            n = 0;
            while ((long)n < l) {
                string = bufferedReader.readLine();
                if (string != null) break block8;
                l2 = n + 1;
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietely(bufferedReader);
            throw throwable;
        }
        {
            block8: {
                FileUtil.closeQuietely(bufferedReader);
                return l2;
            }
            l4 += (long)(string.length() + n2);
            ++n;
            continue;
        }
        FileUtil.closeQuietely(bufferedReader);
        return l3 / (l4 / l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAtStart(File file, String string, String string2) throws IOException {
        File file2 = File.createTempFile("wb$", ".wbtemp", file.getParentFile());
        file2.delete();
        boolean bl = file.renameTo(file2);
        try {
            if (!bl) {
                String string3 = string + FileUtil.readFile(file, string2);
                FileUtil.writeString(file, string3, string2, false);
            } else {
                FileUtil.writeString(file, string, string2, false);
                FileUtil.append(file, file2);
            }
        }
        finally {
            file2.delete();
        }
    }

    public static void append(File file, File file2) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, true);
             FileInputStream fileInputStream = new FileInputStream(file2);){
            FileUtil.copy(fileInputStream, fileOutputStream);
        }
    }

    public static void copy(File file, File file2) throws IOException {
        if (file == null || file2 == null) {
            return;
        }
        Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copySilently(File file, File file2) {
        if (file == null || file2 == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        try {
            FileUtil.copy(file, file2);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when copying file: " + file + " to " + file2, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = 0L;
        try {
            byte[] byArray = new byte[0x200000];
            int n = inputStream.read(byArray);
            while (n != -1) {
                l += (long)n;
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        finally {
            FileUtil.closeQuietely(outputStream);
            FileUtil.closeQuietely(inputStream);
        }
        return l;
    }

    public static String readFile(File file, String string) throws IOException {
        Reader reader = EncodingUtil.createReader(file, string);
        return FileUtil.readCharacters(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readCharacters(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(1024);
        char[] cArray = new char[0x200000];
        int n = reader.read(cArray);
        try {
            while (n > -1) {
                stringBuilder.append(cArray, 0, n);
                n = reader.read(cArray);
            }
        }
        finally {
            FileUtil.closeQuietely(reader);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        ByteBuffer byteBuffer = new ByteBuffer();
        byte[] byArray = new byte[0x200000];
        try {
            int n = inputStream.read(byArray);
            while (n > -1) {
                byteBuffer.append(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        finally {
            FileUtil.closeQuietely(inputStream);
        }
        return byteBuffer.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCharacterLength(File file, String string) throws IOException {
        long l;
        block3: {
            block2: {
                l = 0L;
                if (!EncodingUtil.isMultibyte(string)) break block2;
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = EncodingUtil.createBufferedReader(file, string, 524288);
                    l = bufferedReader.skip(Long.MAX_VALUE);
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietely(bufferedReader);
                    throw throwable;
                }
                FileUtil.closeQuietely(bufferedReader);
                break block3;
            }
            l = file.length();
        }
        return l;
    }

    public static void closeQuietely(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean hasWildcard(String string) {
        return string != null && (string.indexOf(63) > -1 || string.indexOf(42) > -1);
    }

    public static List<WbFile> listFiles(String string, String string2) {
        Object object;
        if (StringUtil.isEmptyString(string)) {
            return Collections.emptyList();
        }
        File file3 = new File(string);
        File file4 = file3.getParentFile();
        if (file4 == null || !file3.isAbsolute()) {
            file4 = string2 == null ? file3.getAbsoluteFile().getParentFile() : (file3.getParent() != null ? new File(string2, file3.getParent()) : new File(string2));
        }
        ArrayList<WbFile> arrayList = new ArrayList<WbFile>();
        try {
            LogMgr.logDebug(new CallerInfo(){}, "Looking for files matching " + file3.getName() + " in " + file4.toPath());
            object = Files.newDirectoryStream(file4.toPath(), file3.getName());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                arrayList.add(new WbFile(path.toFile()));
            }
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not get file list", exception);
        }
        object = (file, file2) -> file.getName().compareToIgnoreCase(file2.getName());
        arrayList.sort((Comparator<WbFile>)object);
        return arrayList;
    }

    public static void writeString(File file, String string) throws IOException {
        FileUtil.writeString(file, string, EncodingUtil.getDefaultEncoding(), false);
    }

    public static void writeString(File file, String string, boolean bl) throws IOException {
        FileUtil.writeString(file, string, EncodingUtil.getDefaultEncoding(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String string, String string2, boolean bl) throws IOException {
        Writer writer = null;
        try {
            writer = EncodingUtil.createWriter(file, string2, bl);
            writer.write(string);
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietely(writer);
            throw throwable;
        }
        FileUtil.closeQuietely(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectFileEncoding(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        byte[] byArray = new byte[4096];
        UniversalDetector universalDetector = new UniversalDetector(null);
        String string = null;
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            while ((n = fileInputStream.read(byArray)) > 0 && !universalDetector.isDone()) {
                universalDetector.handleData(byArray, 0, n);
            }
            universalDetector.dataEnd();
            string = universalDetector.getDetectedCharset();
            if (string != null && string.toUpperCase().startsWith("UTF")) {
                Reader reader = null;
                try {
                    UnicodeReader unicodeReader;
                    reader = EncodingUtil.createReader(file, string);
                    if (reader instanceof UnicodeReader && (unicodeReader = (UnicodeReader)reader).hasBOM()) {
                        string = unicodeReader.getEncoding();
                    }
                }
                finally {
                    FileUtil.closeQuietely(reader);
                }
            }
            LogMgr.logInfo(new CallerInfo(){}, "Detected encoding: " + string + " for file " + file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not detect file encoding", throwable);
            }
            catch (Throwable throwable2) {
                FileUtil.closeQuietely(fileInputStream);
                universalDetector.reset();
                throw throwable2;
            }
            FileUtil.closeQuietely(fileInputStream);
            universalDetector.reset();
        }
        FileUtil.closeQuietely(fileInputStream);
        universalDetector.reset();
        return string;
    }

    public static void sortFiles(List<? extends File> list) {
        Comparator comparator = (file, file2) -> {
            if (Objects.equals(file, file2)) {
                return 0;
            }
            if (file == null && file2 != null) {
                return -1;
            }
            if (file != null && file2 == null) {
                return 1;
            }
            if (file.isDirectory() && file2.isFile()) {
                return -1;
            }
            if (file.isFile() && file2.isDirectory()) {
                return 1;
            }
            return file.compareTo((File)file2);
        };
        Collections.sort(list, comparator);
    }

    public static boolean deleteSilently(File file) {
        if (file == null) {
            return false;
        }
        try {
            return file.delete();
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not delete file: " + file);
            return false;
        }
    }

    public static String getSystemIn() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50);
            if (System.in.available() != 0) {
                int n = System.in.read();
                while (n > -1) {
                    byteArrayOutputStream.write(n);
                    n = System.in.read();
                }
                String string = byteArrayOutputStream.toString();
                return string;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean isDirectoryOnLibraryPath(File file) {
        String[] stringArray;
        if (file == null) {
            return false;
        }
        String string = System.getProperty("java.library.path");
        String string2 = StringUtil.quoteRegexMeta(File.pathSeparator);
        for (String string3 : stringArray = string.split(string2)) {
            File file2 = new File(string3);
            if (!file2.equals(file)) continue;
            return true;
        }
        return false;
    }

    public static WbFile searchFile(String string, File ... fileArray) {
        if (string == null) {
            return null;
        }
        if (fileArray == null || fileArray.length == 0) {
            WbFile wbFile = new WbFile(string);
            if (wbFile.exists()) {
                return wbFile;
            }
            return null;
        }
        LogMgr.logDebug(new CallerInfo(){}, "Searching file: " + string + " in: " + Arrays.toString(fileArray));
        for (File file : fileArray) {
            WbFile wbFile = new WbFile(file, string);
            if (!wbFile.exists()) continue;
            return wbFile;
        }
        return null;
    }

    public static void createBackup(WbFile wbFile) {
        if (wbFile == null) {
            return;
        }
        if (!wbFile.exists()) {
            return;
        }
        int n = Settings.getInstance().getMaxBackupFiles();
        String string = Settings.getInstance().getBackupDir();
        char c = Settings.getInstance().getFileVersionDelimiter();
        FileVersioner fileVersioner = new FileVersioner(n, string, c);
        try {
            fileVersioner.createBackup(wbFile);
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when creating backup for: " + wbFile.getAbsolutePath(), exception);
        }
    }
}

