/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.List;
import workbench.util.LineParser;

public class FixedLengthLineParser
implements LineParser {
    private int currentColIndex;
    private int[] widths;
    private String line;
    private int currentLineIndex;
    private boolean trimValues = false;

    public FixedLengthLineParser(List<Integer> list) {
        if (list == null) {
            throw new IllegalArgumentException("Column widths may not be null");
        }
        this.widths = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.widths[i] = list.get(i);
        }
    }

    @Override
    public void setTrimValues(boolean bl) {
        this.trimValues = bl;
    }

    @Override
    public void setLine(String string) {
        this.line = string;
        this.currentColIndex = 0;
        this.currentLineIndex = 0;
    }

    @Override
    public boolean hasNext() {
        return this.currentColIndex < this.widths.length;
    }

    @Override
    public String getNext() {
        if (!this.hasNext()) {
            return null;
        }
        int n = this.currentLineIndex + this.widths[this.currentColIndex];
        if (n > this.line.length()) {
            n = this.line.length();
        }
        String string = this.line.substring(this.currentLineIndex, n);
        this.currentLineIndex += this.widths[this.currentColIndex];
        ++this.currentColIndex;
        if (this.trimValues) {
            return string.trim();
        }
        return string;
    }
}

