/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class FixedSizeList<T>
implements List<T> {
    protected final LinkedList<T> entries = new LinkedList();
    private int maxSize;
    private boolean appendEntries;
    private boolean allowDuplicates = false;

    public FixedSizeList() {
        this(25);
    }

    public FixedSizeList(int n) {
        this.maxSize = n;
    }

    public void doAppend(boolean bl) {
        this.appendEntries = bl;
    }

    public void setAllowDuplicates(boolean bl) {
        this.allowDuplicates = bl;
    }

    public synchronized void append(T t) {
        if (t == null) {
            return;
        }
        this.entries.add(t);
    }

    public synchronized int addEntry(T t) {
        if (t == null) {
            return -1;
        }
        if (!this.allowDuplicates && this.entries.contains(t)) {
            this.entries.remove(t);
        }
        if (this.appendEntries) {
            this.entries.addLast(t);
        } else {
            this.entries.addFirst(t);
        }
        while (this.entries.size() > this.maxSize) {
            if (this.appendEntries) {
                this.entries.removeFirst();
                continue;
            }
            this.entries.removeLast();
        }
        return this.entries.size();
    }

    @Override
    public T removeFirst() {
        return this.entries.removeFirst();
    }

    @Override
    public synchronized int size() {
        return this.entries.size();
    }

    @Override
    public synchronized T getFirst() {
        return this.entries.getFirst();
    }

    @Override
    public Iterator<T> iterator() {
        return this.entries.iterator();
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.entries.size() * 80);
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    public synchronized List<T> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object object) {
        return this.entries.contains(object);
    }

    @Override
    public synchronized Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] TArray) {
        return this.entries.toArray(TArray);
    }

    @Override
    public synchronized boolean add(T t) {
        this.addEntry(t);
        return true;
    }

    @Override
    public synchronized boolean remove(Object object) {
        return this.entries.remove(object);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        return this.entries.containsAll(collection);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> collection) {
        for (T t : collection) {
            this.entries.add(t);
        }
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        return this.addAll(collection);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        return this.entries.removeAll(collection);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        return this.entries.retainAll(collection);
    }

    @Override
    public synchronized void clear() {
        this.entries.clear();
    }

    @Override
    public synchronized T get(int n) {
        return this.entries.get(n);
    }

    @Override
    public synchronized T set(int n, T t) {
        throw new UnsupportedOperationException("Set by index not allowed!");
    }

    @Override
    public synchronized void add(int n, T t) {
        this.addEntry(t);
    }

    @Override
    public synchronized T remove(int n) {
        return this.entries.remove(n);
    }

    @Override
    public synchronized int indexOf(Object object) {
        return this.entries.indexOf(object);
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return this.entries.lastIndexOf(object);
    }

    @Override
    public synchronized ListIterator<T> listIterator() {
        return this.entries.listIterator();
    }

    @Override
    public synchronized ListIterator<T> listIterator(int n) {
        return this.entries.listIterator(n);
    }

    @Override
    public synchronized List<T> subList(int n, int n2) {
        return this.entries.subList(n, n2);
    }
}

