/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.LobFileParameter;
import workbench.util.LobFileParameterParser;
import workbench.util.SqlUtil;

public class LobFileStatement {
    private final String MARKER = "\\{\\$[cb]lobfile=[^\\}]*\\}";
    private String sqlToUse;
    private LobFileParameter[] parameters;
    private int parameterCount = 0;

    public LobFileStatement(String string) throws FileNotFoundException {
        this(string, null);
    }

    public LobFileStatement(String string, String string2) throws FileNotFoundException {
        LobFileParameterParser lobFileParameterParser = new LobFileParameterParser(string);
        this.parameters = lobFileParameterParser.getParameters();
        if (this.parameters == null) {
            return;
        }
        this.parameterCount = this.parameters.length;
        for (int i = 0; i < this.parameterCount; ++i) {
            Object object;
            if (this.parameters[i] == null) {
                object = ResourceMgr.getString("ErrUpdateBlobSyntax");
                throw new IllegalArgumentException((String)object);
            }
            if (this.parameters[i].getFilename() == null) {
                object = ResourceMgr.getString("ErrUpdateBlobNoFileParameter");
                throw new FileNotFoundException((String)object);
            }
            object = new File(this.parameters[i].getFilename());
            if (!((File)object).isAbsolute() && string2 != null) {
                object = new File(string2, this.parameters[i].getFilename());
                this.parameters[i].setFilename(((File)object).getAbsolutePath());
            }
            if (!((File)object).isDirectory() && ((File)object).exists()) continue;
            String string3 = ResourceMgr.getFormattedString("ErrFileNotFound", this.parameters[i].getFilename());
            throw new FileNotFoundException(string3);
        }
        this.sqlToUse = string.replaceAll("\\{\\$[cb]lobfile=[^\\}]*\\}", " ? ");
    }

    public String getPreparedSql() {
        return this.sqlToUse;
    }

    public LobFileParameter[] getParameters() {
        return this.parameters;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public boolean containsParameter() {
        return this.parameterCount > 0;
    }

    public PreparedStatement prepareStatement(WbConnection wbConnection) throws SQLException, IOException {
        if (this.parameters == null) {
            return null;
        }
        if (this.parameters.length == 0) {
            return null;
        }
        boolean bl = wbConnection.getDbSettings().supportsParameterMetaData();
        PreparedStatement preparedStatement = wbConnection.getSqlConnection().prepareStatement(this.sqlToUse);
        ParameterMetaData parameterMetaData = null;
        try {
            if (bl) {
                parameterMetaData = preparedStatement.getParameterMetaData();
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logWarning(new CallerInfo(){}, "Cannot obtain parameter meta data", sQLException);
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            Object object;
            Closeable closeable;
            File file = new File(this.parameters[i].getFilename());
            int n = (int)file.length();
            if (this.parameters[i].isBinary()) {
                closeable = new BufferedInputStream(new FileInputStream(file), 65536);
                object = wbConnection.getDbSettings().getBlobReadMethod();
                switch (object) {
                    case byteArray: {
                        byte[] byArray = FileUtil.readBytes((InputStream)closeable);
                        preparedStatement.setBytes(i + 1, byArray);
                        break;
                    }
                    case jdbcBlob: {
                        Blob blob = wbConnection.getSqlConnection().createBlob();
                        byte[] byArray = FileUtil.readBytes((InputStream)closeable);
                        blob.setBytes(1L, byArray);
                        preparedStatement.setBlob(i + 1, blob);
                        break;
                    }
                    default: {
                        this.parameters[i].setDataStream(closeable);
                        preparedStatement.setBinaryStream(i + 1, (InputStream)closeable, n);
                        break;
                    }
                }
                continue;
            }
            closeable = EncodingUtil.createBufferedReader(file, this.parameters[i].getEncoding());
            if (wbConnection.getDbSettings().needsExactClobLength()) {
                n = (int)FileUtil.getCharacterLength(file, this.parameters[i].getEncoding());
            }
            if (parameterMetaData != null && SqlUtil.isXMLType(parameterMetaData.getParameterType(i + 1))) {
                object = JdbcUtils.createXML(closeable, wbConnection);
                preparedStatement.setSQLXML(i + 1, (SQLXML)object);
                continue;
            }
            this.parameters[i].setDataStream(closeable);
            preparedStatement.setCharacterStream(i + 1, (Reader)closeable, n);
        }
        return preparedStatement;
    }

    public void done() {
        if (this.parameters == null) {
            return;
        }
        for (LobFileParameter lobFileParameter : this.parameters) {
            if (lobFileParameter == null) continue;
            lobFileParameter.close();
        }
    }
}

