/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.ArrayDeque;
import java.util.Deque;
import workbench.interfaces.ResultLogger;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class MessageBuffer {
    private Deque<CharSequence> messages = new ArrayDeque<CharSequence>();
    private int length = 0;
    private final String newLine = "\n";
    private final int maxSize;
    private boolean trimmed = false;

    public MessageBuffer() {
        this(Settings.getInstance().getIntProperty("workbench.messagebuffer.maxentries", 2500));
    }

    public MessageBuffer(int n) {
        this.maxSize = n;
    }

    public synchronized void clear() {
        this.messages.clear();
        this.length = 0;
    }

    public synchronized int appendTo(ResultLogger resultLogger) {
        int n = 0;
        while (this.messages.size() > 0) {
            CharSequence charSequence = this.messages.removeFirst();
            n += charSequence.length();
            resultLogger.appendToLog(charSequence.toString());
        }
        this.length = 0;
        return n;
    }

    public synchronized CharSequence getBuffer() {
        StringBuilder stringBuilder = new StringBuilder(this.length + 50);
        if (this.trimmed) {
            stringBuilder.append("(...)\n");
        }
        while (this.messages.size() > 0) {
            CharSequence charSequence = this.messages.removeFirst();
            stringBuilder.append(charSequence);
        }
        this.length = 0;
        return stringBuilder;
    }

    private synchronized void trimSize() {
        if (this.maxSize > 0 && this.messages.size() >= this.maxSize) {
            this.trimmed = true;
            while (this.messages.size() >= this.maxSize) {
                CharSequence charSequence = this.messages.removeFirst();
                if (charSequence == null) continue;
                this.length -= charSequence.length();
            }
        }
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void append(MessageBuffer messageBuffer) {
        if (messageBuffer == null) {
            return;
        }
        int n = messageBuffer.messages.size();
        if (n == 0) {
            return;
        }
        this.length += messageBuffer.length;
        while (this.messages.size() + n > this.maxSize) {
            CharSequence charSequence = this.messages.removeFirst();
            if (charSequence == null) continue;
            this.length -= charSequence.length();
        }
        for (CharSequence charSequence : messageBuffer.messages) {
            this.messages.add(charSequence);
        }
    }

    public synchronized void append(CharSequence charSequence) {
        if (StringUtil.isEmptyString(charSequence)) {
            return;
        }
        this.trimSize();
        this.messages.add(charSequence);
        this.length += charSequence.length();
    }

    public synchronized void appendMessageKey(String string) {
        this.append(ResourceMgr.getString(string));
    }

    public synchronized void appendNewLine() {
        this.append("\n");
    }

    public String toString() {
        return "[" + this.getLength() + " messages]";
    }
}

