/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.DropType;
import workbench.db.JdbcUtils;
import workbench.db.QuoteHandler;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.interfaces.TextContainer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.sql.ErrorDescriptor;
import workbench.sql.formatter.WbSqlFormatter;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.sql.syntax.SqlKeywordHelper;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.util.Alias;
import workbench.util.CollectionUtil;
import workbench.util.DdlObjectInfo;
import workbench.util.ElementInfo;
import workbench.util.SqlParsingUtil;
import workbench.util.StringUtil;
import workbench.util.TableListParser;

public class SqlUtil {
    public static final Pattern SQL_IDENTIFIER = Pattern.compile("[a-zA-Z][\\w\\$]*");
    private static final Set<String> CHAR_TYPES_WITHOUT_LENGTH = CollectionUtil.caseInsensitiveSet("text", "tinytext", "mediumtext", "longtext");

    public static Set<String> getJoinKeyWords() {
        return JoinKeywordsHolder.JOIN_KEYWORDS;
    }

    public static Set<String> getDMLVerbs() {
        return ModifyingVerbsHolder.DML_VERB;
    }

    public static Set<String> getTypesWithoutNames() {
        return TypesWithoutNamesHolder.TYPES;
    }

    public static Set<String> getKnownTypes() {
        return KnownTypesHolder.KNOWN_TYPES;
    }

    public static Field[] getSqlTypeFields() {
        return SqlTypeFieldsHolder.SQL_TYPES;
    }

    public static String escapeQuotes(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("'", "''");
    }

    public static String getPlainTypeName(String string) {
        int n = string.indexOf(40);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String stripVerb(String string) {
        SqlParsingUtil sqlParsingUtil = SqlParsingUtil.getInstance(null);
        return sqlParsingUtil.stripVerb(string);
    }

    public static String quoteObjectname(String string) {
        return SqlUtil.quoteObjectname(string, false);
    }

    public static String quoteObjectname(String string, boolean bl) {
        return SqlUtil.quoteObjectname(string, bl, false, '\"');
    }

    public static String quoteObjectname(String string, boolean bl, boolean bl2, char c) {
        Object object;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        if (string.charAt(0) == c) {
            return string;
        }
        if ((string = string.trim()).charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            return string;
        }
        boolean bl3 = bl;
        if (!bl) {
            object = SQL_IDENTIFIER.matcher(string);
            boolean bl4 = bl3 = !((Matcher)object).matches();
        }
        if (!bl3 && bl2) {
            bl3 = SqlKeywordHelper.getDefaultReservedWords().contains(string);
        }
        if (!bl3) {
            return string;
        }
        object = new StringBuilder(string.length() + 2);
        ((StringBuilder)object).append(c);
        ((StringBuilder)object).append(string);
        ((StringBuilder)object).append(c);
        return ((StringBuilder)object).toString();
    }

    public static char getCatalogSeparator(WbConnection wbConnection) {
        if (wbConnection == null) {
            return '.';
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata == null) {
            return '.';
        }
        return dbMetadata.getCatalogSeparator();
    }

    public static char getSchemaSeparator(WbConnection wbConnection) {
        if (wbConnection == null) {
            return '.';
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata == null) {
            return '.';
        }
        return dbMetadata.getSchemaSeparator();
    }

    public static String removeObjectQuotes(String string) {
        if (string == null) {
            return string;
        }
        int n = (string = string.trim()).length();
        if (n < 2) {
            return string;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(n - 1);
        if (c == '\"' && c2 == '\"' || c == '`' && c2 == '`' || c == '[' && c2 == ']') {
            return string.substring(1, n - 1);
        }
        return string;
    }

    public static boolean isQuotedIdentifier(String string) {
        if (string == null) {
            return false;
        }
        int n = (string = string.trim()).length();
        if (n < 2) {
            return false;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(n - 1);
        return c == '\"' && c2 == '\"' || c == '`' && c2 == '`' || c == '[' && c2 == ']';
    }

    public static DdlObjectInfo getDDLObjectInfo(CharSequence charSequence) {
        return SqlUtil.getDDLObjectInfo(charSequence, null);
    }

    public static DdlObjectInfo getDDLObjectInfo(CharSequence charSequence, WbConnection wbConnection) {
        if (StringUtil.isEmptyString(charSequence)) {
            return null;
        }
        DdlObjectInfo ddlObjectInfo = new DdlObjectInfo(charSequence, wbConnection);
        if (ddlObjectInfo.isValid()) {
            return ddlObjectInfo;
        }
        return null;
    }

    public static boolean objectNamesAreEqual(DbObject dbObject, DbObject dbObject2) {
        return SqlUtil.objectNamesAreEqual(dbObject, dbObject2, true);
    }

    public static boolean objectNamesAreEqual(DbObject dbObject, DbObject dbObject2, boolean bl) {
        String string;
        String string2;
        if (dbObject == null || dbObject2 == null) {
            return false;
        }
        if (bl) {
            string2 = dbObject.getObjectType();
            string = dbObject2.getObjectType();
            if (string2 == null || string == null) {
                return false;
            }
            if (StringUtil.compareStrings(string2, string, true) != 0) {
                return false;
            }
        }
        string2 = SqlUtil.removeObjectQuotes(dbObject.getCatalog());
        string = SqlUtil.removeObjectQuotes(dbObject2.getCatalog());
        if (StringUtil.isNonEmpty(string2) && StringUtil.isNonEmpty(string) && !string2.equalsIgnoreCase(string)) {
            return false;
        }
        String string3 = SqlUtil.removeObjectQuotes(dbObject.getSchema());
        String string4 = SqlUtil.removeObjectQuotes(dbObject2.getSchema());
        if (StringUtil.isNonEmpty(string3) && StringUtil.isNonEmpty(string4) && !string3.equalsIgnoreCase(string4)) {
            return false;
        }
        String string5 = SqlUtil.removeObjectQuotes(dbObject.getObjectName());
        String string6 = SqlUtil.removeObjectQuotes(dbObject2.getObjectName());
        return StringUtil.equalStringIgnoreCase(string5, string6);
    }

    public static boolean objectNamesAreEqual(String string, String string2) {
        boolean bl = StringUtil.isEmptyString(string);
        boolean bl2 = StringUtil.isEmptyString(string2);
        if (bl && bl2) {
            return true;
        }
        if (bl || bl2) {
            return false;
        }
        boolean bl3 = SqlUtil.isQuotedIdentifier(string);
        boolean bl4 = SqlUtil.isQuotedIdentifier(string2);
        if (bl3 || bl4) {
            return SqlUtil.removeObjectQuotes(string).equals(SqlUtil.removeObjectQuotes(string2));
        }
        return SqlUtil.removeObjectQuotes(string).equalsIgnoreCase(SqlUtil.removeObjectQuotes(string2));
    }

    public static String escapeUnderscore(String string, WbConnection wbConnection) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(95) == -1) {
            return string;
        }
        if (wbConnection == null) {
            return string;
        }
        if (!wbConnection.getDbSettings().doEscapeSearchString()) {
            return string;
        }
        String string2 = wbConnection.getSearchStringEscape();
        return SqlUtil.escapeUnderscore(string, string2);
    }

    public static String escapeUnderscore(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (StringUtil.isEmptyString(string2)) {
            return string;
        }
        if (string.indexOf(95) == -1) {
            return string;
        }
        String string3 = string2 + "_";
        if (string.contains(string3)) {
            return string;
        }
        return StringUtil.replace(string, "_", string3);
    }

    public static void appendEscapeClause(StringBuilder stringBuilder, WbConnection wbConnection, String string) {
        String string2 = SqlUtil.getEscapeClause(wbConnection, string);
        if (string2.length() > 0) {
            stringBuilder.append(string2);
        }
    }

    public static String getEscapeClause(WbConnection wbConnection, String string) {
        if (string == null || wbConnection == null) {
            return "";
        }
        if (string.indexOf(95) < 0) {
            return "";
        }
        if (string.indexOf(37) < 0) {
            return "";
        }
        if (!wbConnection.getDbSettings().doEscapeSearchString()) {
            return "";
        }
        String string2 = wbConnection.getSearchStringEscape();
        if (StringUtil.isEmptyString(string2)) {
            return "";
        }
        return " ESCAPE '" + string2 + "'";
    }

    public static String getCreateType(CharSequence charSequence) {
        DdlObjectInfo ddlObjectInfo = SqlUtil.getDDLObjectInfo(charSequence);
        if (ddlObjectInfo == null) {
            return null;
        }
        return ddlObjectInfo.getObjectType();
    }

    public static String getDeleteTable(CharSequence charSequence) {
        return SqlUtil.getDeleteTable(charSequence, '.', null);
    }

    public static String getDeleteTable(CharSequence charSequence, char c, WbConnection wbConnection) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(wbConnection, charSequence);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            if (!sQLToken.getContents().equals("DELETE")) {
                return null;
            }
            sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken == null) {
                return null;
            }
            if (!sQLToken.getContents().equals("FROM")) {
                stringBuilder.append(sQLToken.getContents());
                SqlUtil.appendCurrentTablename(sQLLexer, stringBuilder, c);
                return stringBuilder.toString();
            }
            sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken == null) {
                return null;
            }
            stringBuilder.append(sQLToken.getContents());
            SqlUtil.appendCurrentTablename(sQLLexer, stringBuilder, c);
            sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken != null && sQLToken.getContents().charAt(0) == c) {
                stringBuilder.append(sQLToken.getContents());
                sQLToken = sQLLexer.getNextToken(false, false);
                if (sQLToken != null && sQLToken.isIdentifier()) {
                    stringBuilder.append(sQLToken.getContents());
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static SQLToken appendCurrentTablename(SQLLexer sQLLexer, StringBuilder stringBuilder, char c) {
        try {
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken != null && sQLToken.getContents().charAt(0) == c) {
                stringBuilder.append(sQLToken.getContents());
                sQLToken = sQLLexer.getNextToken(false, false);
                if (sQLToken != null && sQLToken.isIdentifier()) {
                    stringBuilder.append(sQLToken.getContents());
                }
            }
            return sQLToken;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getMergeTable(CharSequence charSequence, WbConnection wbConnection) {
        return SqlUtil.getDmlTable(charSequence, SqlUtil.getCatalogSeparator(wbConnection), "MERGE", "INTO", wbConnection);
    }

    public static String getTruncateTable(CharSequence charSequence, WbConnection wbConnection) {
        return SqlUtil.getTruncateTable(charSequence, SqlUtil.getCatalogSeparator(wbConnection), wbConnection);
    }

    public static String getTruncateTable(CharSequence charSequence, char c, WbConnection wbConnection) {
        return SqlUtil.getDmlTable(charSequence, c, "TRUNCATE", "TABLE", wbConnection);
    }

    public static String getUpdateTable(CharSequence charSequence, WbConnection wbConnection) {
        return SqlUtil.getUpdateTable(charSequence, '.', null);
    }

    public static String getUpdateTable(CharSequence charSequence, char c, WbConnection wbConnection) {
        return SqlUtil.getDmlTable(charSequence, c, "UPDATE", null, wbConnection);
    }

    public static String getInsertTable(CharSequence charSequence, WbConnection wbConnection) {
        return SqlUtil.getInsertTable(charSequence, '.', wbConnection);
    }

    public static String getInsertTable(CharSequence charSequence, char c, WbConnection wbConnection) {
        return SqlUtil.getDmlTable(charSequence, c, "INSERT", "INTO", wbConnection);
    }

    private static String getDmlTable(CharSequence charSequence, char c, String string, String string2, WbConnection wbConnection) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(wbConnection, charSequence);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken == null || !sQLToken.getContents().equals(string)) {
                return null;
            }
            sQLToken = sQLLexer.getNextToken(false, false);
            if (string2 != null) {
                if (sQLToken == null || !sQLToken.getContents().equals(string2)) {
                    return null;
                }
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            if (sQLToken == null) {
                return null;
            }
            stringBuilder.append(sQLToken.getContents());
            SqlUtil.appendCurrentTablename(sQLLexer, stringBuilder, c);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String addSemicolon(String string) {
        int n = SqlUtil.findSemicolonFromEnd(string);
        if (n > -1) {
            return string;
        }
        return string + ";";
    }

    public static String trimSemicolon(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        int n = SqlUtil.findSemicolonFromEnd(string);
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static int findSemicolonFromEnd(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.length();
        if (n == 0) {
            return -1;
        }
        int n2 = -1;
        for (int i = n - 1; i > 0; --i) {
            char c = string.charAt(i);
            if (c == ';') {
                n2 = i;
                break;
            }
            if (!Character.isWhitespace(c)) break;
        }
        return n2;
    }

    public static String getSqlVerb(String string) {
        return SqlParsingUtil.getInstance(null).getSqlVerb(string);
    }

    public static List<ColumnIdentifier> getResultSetColumns(String string, WbConnection wbConnection) throws SQLException {
        if (wbConnection == null) {
            return null;
        }
        ResultInfo resultInfo = SqlUtil.getResultInfoFromQuery(string, wbConnection);
        if (resultInfo == null) {
            return null;
        }
        int n = resultInfo.getColumnCount();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(resultInfo.getColumn(i));
        }
        return arrayList;
    }

    public static ResultInfo getResultInfoFromQuery(String string, WbConnection wbConnection) throws SQLException {
        ResultInfo resultInfo;
        if (wbConnection == null) {
            return null;
        }
        ResultSet resultSet = null;
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        Savepoint savepoint = null;
        try {
            if (wbConnection.getDbSettings().useSavePointForDML()) {
                savepoint = wbConnection.setSavepoint();
            }
            ResultSetMetaData resultSetMetaData = null;
            if (wbConnection.getDbSettings().usePreparedStatementForQueryInfo()) {
                try {
                    preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
                    resultSetMetaData = preparedStatement.getMetaData();
                    if (resultSetMetaData == null) {
                        LogMgr.logDebug(new CallerInfo(){}, "No ResultSetMetaData returned from the PreparedStatement");
                    }
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Could not obtain result info from prepared statement for:\n" + string, exception);
                    JdbcUtils.closeStatement(preparedStatement);
                    preparedStatement = null;
                    resultSetMetaData = null;
                }
            }
            if (resultSetMetaData == null) {
                statement = wbConnection.createStatementForQuery();
                statement.setMaxRows(1);
                resultSet = statement.executeQuery(SqlUtil.trimSemicolon(string));
                resultSetMetaData = resultSet.getMetaData();
            }
            resultInfo = new ResultInfo(resultSetMetaData, wbConnection);
            List<Alias> list = SqlUtil.getTables(string, false, wbConnection);
            if (list.size() == 1) {
                Alias alias = list.get(0);
                TableIdentifier tableIdentifier = new TableIdentifier(alias.getObjectName(), wbConnection);
                resultInfo.setUpdateTable(tableIdentifier);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(preparedStatement);
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(preparedStatement);
        JdbcUtils.closeAll(resultSet, statement);
        return resultInfo;
    }

    public static List<String> getSelectColumns(String string, boolean bl, WbConnection wbConnection) {
        List<ElementInfo> list = SqlUtil.getColumnEntries(string, bl, wbConnection);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (ElementInfo elementInfo : list) {
            arrayList.add(elementInfo.getElementValue());
        }
        return arrayList;
    }

    public static List<ElementInfo> getColumnEntries(String string, boolean bl, WbConnection wbConnection) {
        ArrayList<ElementInfo> arrayList = new ArrayList<ElementInfo>();
        try {
            String string2;
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(wbConnection, string);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken == null) {
                return Collections.emptyList();
            }
            String string3 = sQLToken.getContents();
            if (!"SELECT".equalsIgnoreCase(string3) && !"WITH".equalsIgnoreCase(string3)) {
                return Collections.emptyList();
            }
            if ("WITH".equals(string3)) {
                sQLToken = SqlUtil.skipCTE(sQLLexer);
                sQLToken = sQLLexer.getNextToken(false, false);
            } else {
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            if (sQLToken == null) {
                return Collections.emptyList();
            }
            boolean bl2 = false;
            if (sQLToken.getContents().equals("DISTINCT") || sQLToken.getContents().equals("DISTINCT ON")) {
                if (sQLToken.getContents().equals("DISTINCT ON")) {
                    sQLToken = sQLLexer.getNextToken(false, false);
                    while (sQLToken != null && !sQLToken.getContents().equals(")")) {
                        sQLToken = sQLLexer.getNextToken(false, false);
                    }
                }
                if ((sQLToken = sQLLexer.getNextToken(false, false)) == null) {
                    return Collections.emptyList();
                }
            }
            int n = sQLToken.getCharBegin();
            int n2 = 0;
            boolean bl3 = true;
            while (sQLToken != null) {
                string2 = sQLToken.getContents();
                if ("(".equals(string2)) {
                    ++n2;
                } else if (")".equals(string2)) {
                    --n2;
                } else if (n2 == 0 && (",".equals(string2) || WbSqlFormatter.SELECT_TERMINAL.contains(string2))) {
                    String string4 = string.substring(n, sQLToken.getCharBegin());
                    if (bl2 && n2 == 0 && string4.trim().endsWith(")")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    string4 = bl ? string4.trim() : SqlUtil.stripColumnAlias(string4);
                    arrayList.add(new ElementInfo(string4, n, sQLToken.getCharBegin()));
                    if (WbSqlFormatter.SELECT_TERMINAL.contains(string2)) {
                        bl3 = false;
                        n = -1;
                        break;
                    }
                    bl3 = true;
                } else if (bl3) {
                    n = sQLToken.getCharBegin();
                    bl3 = false;
                }
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            if (n > -1) {
                string2 = string.substring(n);
                if (bl) {
                    arrayList.add(new ElementInfo(string2.trim(), n, string.length()));
                } else {
                    arrayList.add(new ElementInfo(SqlUtil.stripColumnAlias(string2), n, string.length()));
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error parsing SELECT statement", exception);
            return Collections.emptyList();
        }
        return arrayList;
    }

    public static SQLToken skipCTE(SQLLexer sQLLexer) {
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        int n = 0;
        while (sQLToken != null) {
            String string = sQLToken.getContents();
            if ("(".equals(string)) {
                ++n;
            } else if (")".equals(string)) {
                --n;
            }
            if ("SELECT".equals(string) && n == 0) {
                return sQLToken;
            }
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        return sQLToken;
    }

    public static List<String> getFunctionParameters(String string) {
        if (StringUtil.isBlank(string)) {
            return Collections.emptyList();
        }
        List<String> list = CollectionUtil.arrayList();
        try {
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(string);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            while (sQLToken != null && !sQLToken.getContents().equals("(")) {
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            if (sQLToken == null) {
                return Collections.emptyList();
            }
            int n = 0;
            int n2 = sQLToken.getCharEnd();
            while (sQLToken != null) {
                String string2;
                int n3;
                String string3 = sQLToken.getContents();
                if (string3.equals("(")) {
                    ++n;
                } else if (string3.equals(")")) {
                    if (n == 1) {
                        n3 = sQLToken.getCharBegin();
                        if (n3 > n2) {
                            string2 = string.substring(n2, n3);
                            list.add(string2.trim());
                        }
                        break;
                    }
                    --n;
                } else if (n == 1 && string3.equals(",")) {
                    n3 = sQLToken.getCharBegin();
                    if (n3 > n2) {
                        string2 = string.substring(n2, n3);
                        list.add(string2.trim());
                    }
                    n2 = sQLToken.getCharEnd();
                }
                sQLToken = sQLLexer.getNextToken(true, false);
            }
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
        return list;
    }

    public static String stripColumnAlias(String string) {
        char c;
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        char c2 = '\u0000';
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < n && (!Character.isWhitespace(c = string.charAt(i)) || bl || n2 != 0); ++i) {
            if (bl) {
                if (c == c2 || c2 == '[' && c == ']') {
                    bl = false;
                }
            } else if (c == '\"' || c == '`' || c == '[') {
                c2 = c;
                bl = true;
            }
            if (!bl) {
                if (c == '(') {
                    ++n2;
                }
                if (c == ')') {
                    --n2;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static List<Alias> getTables(String string, boolean bl, WbConnection wbConnection) {
        return SqlUtil.getTables(string, bl, SqlUtil.getCatalogSeparator(wbConnection), SqlUtil.getSchemaSeparator(wbConnection), wbConnection);
    }

    public static List<Alias> getTables(String string, boolean bl, char c, char c2, WbConnection wbConnection) {
        ParserType parserType = ParserType.getTypeFromConnection(wbConnection);
        return SqlUtil.getTables(string, bl, c, c2, parserType);
    }

    public static List<Alias> getTables(String string, boolean bl, char c, char c2, ParserType parserType) {
        TableListParser tableListParser = new TableListParser(c, c2, parserType);
        return tableListParser.getTables(string, bl);
    }

    public static boolean isUnRestrictedDML(String string, WbConnection wbConnection) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        SqlParsingUtil sqlParsingUtil = SqlParsingUtil.getInstance(wbConnection);
        String string2 = sqlParsingUtil.getSqlVerb(string);
        if (SqlUtil.getDMLVerbs().contains(string2)) {
            return sqlParsingUtil.getWherePosition(string) < 0;
        }
        return false;
    }

    public static String makeCleanSql(String string, boolean bl) {
        return SqlUtil.makeCleanSql(string, bl, false, false, true, '\"');
    }

    public static String makeCleanSql(String string, boolean bl, boolean bl2) {
        return SqlUtil.makeCleanSql(string, bl, bl2, false, true, '\"');
    }

    public static String makeCleanSql(String string, boolean bl, boolean bl2, boolean bl3, WbConnection wbConnection) {
        boolean bl4 = wbConnection != null ? wbConnection.getMetadata().isMySql() : false;
        char c = wbConnection != null ? (char)wbConnection.getMetadata().getIdentifierQuoteChar() : (char)'\"';
        return SqlUtil.makeCleanSql(string, bl, bl2, bl4, bl3, c);
    }

    public static String makeCleanSql(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, char c) {
        int n;
        if (string == null) {
            return null;
        }
        if (bl && bl2 && !bl4) {
            return string;
        }
        int n2 = (string = string.trim()).length();
        if (n2 == 0) {
            return string;
        }
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        char c2 = '\u0000';
        StringBuilder stringBuilder = new StringBuilder((int)((double)n2 * 0.8));
        int n3 = 32;
        for (int i = n = StringUtil.findFirstNonWhitespace(string); i < n2; ++i) {
            char c3 = string.charAt(i);
            if (c3 == '\'' || c3 == '\"' || c3 == c) {
                if (!bl6) {
                    c2 = c3;
                    bl6 = true;
                } else if (c3 == c2) {
                    bl6 = false;
                    c2 = '\u0000';
                }
            }
            if (bl6 && !bl5 && !bl2) {
                stringBuilder.append(c3);
                n3 = c3;
                continue;
            }
            if (bl3 && (n3 == 10 || n3 == 13 || i == 0) && c3 == '#') {
                bl7 = true;
            }
            if (!bl5 && !bl7 || bl2) {
                if (!bl2 && c3 == '/' && i < n2 - 1 && string.charAt(i + 1) == '*') {
                    bl5 = true;
                    ++i;
                } else if (!bl2 && c3 == '-' && i < n2 - 1 && string.charAt(i + 1) == '-') {
                    while (c3 != '\n' && i < n2 - 1) {
                        c3 = string.charAt(++i);
                    }
                } else if (!(c3 != '\n' && c3 != '\r' || bl)) {
                    if (c3 == '\n' && stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                } else if (c3 != '\n' && (c3 < ' ' || c3 > '~' && c3 < '\u0091' || c3 == '\u00ff')) {
                    stringBuilder.append(' ');
                } else {
                    SqlUtil.appendNoLeadingWhitespace(stringBuilder, c3);
                }
            } else if (c3 == '*' && i < n2 - 1 && string.charAt(i + 1) == '/') {
                bl5 = false;
                ++i;
            } else if (c3 == '\n' || c3 == '\r' && bl7) {
                bl7 = false;
            }
            n3 = c3;
        }
        StringUtil.trimTrailingWhitespace(stringBuilder);
        if (bl4 && StringUtil.endsWith((CharSequence)stringBuilder, ';')) {
            StringUtil.removeFromEnd(stringBuilder, 1);
            StringUtil.trimTrailingWhitespace(stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static void appendNoLeadingWhitespace(StringBuilder stringBuilder, char c) {
        if (c <= ' ' && stringBuilder.length() == 0) {
            return;
        }
        stringBuilder.append(c);
    }

    public static boolean isDecimalType(int n, int n2, int n3) {
        if (n == 3 || n == 8 || n == 6 || n == 2 || n == 7) {
            return n2 > 0;
        }
        return false;
    }

    public static boolean isIntegerType(int n) {
        return n == -5 || n == 4 || n == 5 || n == -6;
    }

    public static boolean isCharacterType(int n) {
        return n == 12 || n == 1 || n == 2005 || n == -1 || n == -9 || n == -15 || n == -16 || n == 2011;
    }

    public static boolean isCharacterTypeWithLength(int n) {
        return n == 12 || n == 1 || n == -9 || n == -15;
    }

    public static boolean isNumberType(int n) {
        return n == -5 || n == 4 || n == 3 || n == 8 || n == 6 || n == 2 || n == 7 || n == 5 || n == -6;
    }

    public static boolean isDateType(int n) {
        return n == 91 || n == 93 || n == 2014;
    }

    public static boolean isClobType(ColumnIdentifier columnIdentifier) {
        if (columnIdentifier == null) {
            return false;
        }
        int n = columnIdentifier.getDataType();
        if (SqlUtil.isClobType(n)) {
            return true;
        }
        if (n == 12 || n == -9) {
            return columnIdentifier.getColumnSize() == Integer.MAX_VALUE;
        }
        return false;
    }

    public static boolean isClobType(int n) {
        return n == 2005 || n == 2011;
    }

    public static boolean isClobType(int n, String string, DbSettings dbSettings) {
        boolean bl;
        if (SqlUtil.isClobType(n)) {
            return true;
        }
        boolean bl2 = bl = dbSettings == null ? false : dbSettings.longVarcharIsClob();
        if (SqlUtil.isClobType(n, bl)) {
            return true;
        }
        if (dbSettings != null) {
            return dbSettings.isClobType(string);
        }
        return false;
    }

    public static boolean isXMLType(int n) {
        return n == 2009;
    }

    public static boolean isXMLType(int n, String string) {
        if (n == 2009) {
            return true;
        }
        return "XMLTYPE".equals(string);
    }

    public static boolean isClobType(int n, boolean bl) {
        if (bl) {
            return n == 2005 || n == 2011 || n == -1 || n == -16;
        }
        return SqlUtil.isClobType(n);
    }

    public static boolean isBlobType(int n) {
        return n == 2004 || n == -2 || n == -4 || n == -3;
    }

    public static String getTypeName(int n) {
        try {
            for (Field field : SqlUtil.getSqlTypeFields()) {
                int n2 = field.getInt(null);
                if (n2 != n) continue;
                return field.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "OTHER";
    }

    public static String getSqlTypeDisplay(String string, int n, int n2, int n3) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        switch (n) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (CHAR_TYPES_WITHOUT_LENGTH.contains(string)) {
                    return string;
                }
                if (n2 <= 0 || string.indexOf(40) != -1) break;
                string2 = string + "(" + n2 + ")";
                break;
            }
            case 7: 
            case 8: {
                string2 = string;
                break;
            }
            case 6: {
                if (n2 <= 0) break;
                string2 = string + "(" + n2 + ")";
                break;
            }
            case 2: 
            case 3: {
                if ("money".equalsIgnoreCase(string)) {
                    return string;
                }
                if (string.indexOf(40) != -1) break;
                if (n3 > 0 && n2 > 0) {
                    string2 = string + "(" + n2 + "," + n3 + ")";
                    break;
                }
                if (n2 <= 0 && n3 > 0) {
                    string2 = string + "(" + n3 + ")";
                    break;
                }
                if (n2 <= 0 || n3 > 0) break;
                string2 = string + "(" + n2 + ")";
                break;
            }
            case 1111: {
                if (string.toUpperCase().startsWith("NVARCHAR")) {
                    string2 = string + "(" + n2 + ")";
                    break;
                }
                if ("NCHAR".equalsIgnoreCase(string)) {
                    string2 = string + "(" + n2 + ")";
                    break;
                }
                if ("UROWID".equalsIgnoreCase(string)) {
                    string2 = string + "(" + n2 + ")";
                    break;
                }
                if (!"RAW".equalsIgnoreCase(string)) break;
                string2 = string + "(" + n2 + ")";
                break;
            }
            default: {
                string2 = string;
            }
        }
        return string2;
    }

    public static boolean ignoreWarning(WbConnection wbConnection, SQLWarning sQLWarning) {
        if (sQLWarning == null || wbConnection == null) {
            return true;
        }
        DbSettings dbSettings = wbConnection.getDbSettings();
        if (dbSettings == null) {
            return false;
        }
        Set<Integer> set = dbSettings.getInformationalWarningCodes();
        if (set.contains(sQLWarning.getErrorCode())) {
            return true;
        }
        Set<String> set2 = dbSettings.getInformationalWarningStates();
        return set2.contains(sQLWarning.getSQLState());
    }

    public static CharSequence getWarnings(WbConnection wbConnection, Statement statement) {
        if (wbConnection == null) {
            return null;
        }
        try {
            SQLWarning sQLWarning;
            HashSet<String> hashSet = new HashSet<String>();
            StringBuilder stringBuilder = null;
            String string = null;
            int n = 0;
            int n2 = wbConnection.getDbSettings().getMaxWarnings();
            SQLWarning sQLWarning2 = sQLWarning = statement == null ? null : statement.getWarnings();
            while (sQLWarning != null) {
                if (!SqlUtil.ignoreWarning(wbConnection, sQLWarning)) {
                    ++n;
                    string = sQLWarning.getMessage();
                    if (string != null && string.length() > 0) {
                        stringBuilder = SqlUtil.append(stringBuilder, string);
                        if (!StringUtil.endsWith((CharSequence)string, '\n')) {
                            stringBuilder.append('\n');
                        }
                        hashSet.add(string);
                    }
                }
                if (n > n2) {
                    LogMgr.logWarning(new CallerInfo(){}, "Breaking out of loop because" + n2 + " iterations reached!");
                    break;
                }
                if (sQLWarning == sQLWarning.getNextWarning()) break;
                sQLWarning = sQLWarning.getNextWarning();
            }
            n = 0;
            for (sQLWarning = wbConnection.getSqlConnection().getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                if (!SqlUtil.ignoreWarning(wbConnection, sQLWarning) && !hashSet.contains(string = sQLWarning.getMessage())) {
                    stringBuilder = SqlUtil.append(stringBuilder, string);
                    if (!StringUtil.endsWith((CharSequence)string, '\n')) {
                        stringBuilder.append('\n');
                    }
                }
                if (n > n2) {
                    LogMgr.logWarning(new CallerInfo(){}, "Breaking out of loop because" + n2 + " iterations reached!");
                    break;
                }
                if (sQLWarning == sQLWarning.getNextWarning()) break;
            }
            JdbcUtils.clearWarnings(wbConnection, statement);
            StringUtil.trimTrailingWhitespace(stringBuilder);
            return stringBuilder;
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error retrieving warnings", throwable);
            return null;
        }
    }

    private static StringBuilder append(StringBuilder stringBuilder, CharSequence charSequence) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(100);
        }
        stringBuilder.append(charSequence);
        return stringBuilder;
    }

    public static String buildExpression(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        return SqlUtil.buildExpression(wbConnection, dbObject.getCatalog(), dbObject.getSchema(), dbObject.getObjectName());
    }

    public static String fullyQualifiedName(WbConnection wbConnection, DbObject dbObject) {
        QuoteHandler quoteHandler = wbConnection != null ? wbConnection.getMetadata() : QuoteHandler.STANDARD_HANDLER;
        return SqlUtil.fullyQualifiedName(quoteHandler, wbConnection, dbObject);
    }

    public static String fullyQualifiedName(QuoteHandler quoteHandler, WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(30);
        boolean bl = wbConnection != null ? wbConnection.getDbSettings().supportsCatalogs() : true;
        boolean bl2 = wbConnection != null ? wbConnection.getDbSettings().supportsSchemas() : true;
        char c = SqlUtil.getCatalogSeparator(wbConnection);
        char c2 = SqlUtil.getSchemaSeparator(wbConnection);
        if (bl && StringUtil.isNonEmpty(dbObject.getCatalog())) {
            stringBuilder.append(quoteHandler.quoteObjectname(dbObject.getCatalog()));
            stringBuilder.append(c);
        }
        if (bl2 && StringUtil.isNonEmpty(dbObject.getSchema())) {
            stringBuilder.append(quoteHandler.quoteObjectname(dbObject.getSchema()));
            stringBuilder.append(c2);
        }
        stringBuilder.append(quoteHandler.quoteObjectname(dbObject.getObjectName()));
        return stringBuilder.toString();
    }

    public static String buildExpression(WbConnection wbConnection, String string, String string2, String string3) {
        DbMetadata dbMetadata;
        if (StringUtil.isEmptyString(string3)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(30);
        DbMetadata dbMetadata2 = dbMetadata = wbConnection != null ? wbConnection.getMetadata() : null;
        if (dbMetadata == null) {
            if (StringUtil.isNonEmpty(string)) {
                stringBuilder.append(SqlUtil.quoteObjectname(string, false));
                stringBuilder.append('.');
            }
            if (StringUtil.isNonEmpty(string2)) {
                stringBuilder.append(SqlUtil.quoteObjectname(string2, false));
                stringBuilder.append('.');
            }
            stringBuilder.append(SqlUtil.quoteObjectname(string3, false));
        } else {
            char c = dbMetadata.getCatalogSeparator();
            char c2 = dbMetadata.getSchemaSeparator();
            if (StringUtil.isNonEmpty(string) && !dbMetadata.ignoreCatalog(string)) {
                stringBuilder.append(dbMetadata.quoteObjectname(string));
                stringBuilder.append(c);
            }
            if (StringUtil.isNonEmpty(string2) && !dbMetadata.ignoreSchema(string2)) {
                stringBuilder.append(dbMetadata.quoteObjectname(string2));
                stringBuilder.append(c2);
            }
            stringBuilder.append(dbMetadata.quoteObjectname(string3));
        }
        return stringBuilder.toString();
    }

    public static boolean isMultiLineColumn(ColumnIdentifier columnIdentifier) {
        if (columnIdentifier == null) {
            return false;
        }
        int n = 0;
        int n2 = columnIdentifier.getDataType();
        String string = columnIdentifier.getDbmsType();
        if (SqlUtil.isClobType(n2) || SqlUtil.isXMLType(n2)) {
            n = Integer.MAX_VALUE;
        } else if (SqlUtil.isCharacterType(n2)) {
            n = columnIdentifier.getColumnSize();
        } else {
            return string != null && string.toLowerCase().startsWith("json");
        }
        int n3 = GuiSettings.getMultiLineThreshold();
        return n >= n3;
    }

    public static boolean appendAndCondition(StringBuilder stringBuilder, String string, String string2, WbConnection wbConnection) {
        if (StringUtil.isNonEmpty(string2) && StringUtil.isNonEmpty(string)) {
            stringBuilder.append(" AND ");
            return SqlUtil.appendExpression(stringBuilder, string, string2, wbConnection);
        }
        return false;
    }

    public static boolean appendExpression(StringBuilder stringBuilder, String string, String string2, WbConnection wbConnection) {
        if (StringUtil.isEmptyString(string2)) {
            return false;
        }
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        stringBuilder.append(string);
        boolean bl = false;
        if (string2.indexOf(37) > -1) {
            stringBuilder.append(" LIKE '");
            stringBuilder.append(SqlUtil.escapeUnderscore(string2, wbConnection));
            bl = true;
        } else {
            stringBuilder.append(" = '");
            stringBuilder.append(string2);
        }
        stringBuilder.append("'");
        if (bl) {
            SqlUtil.appendEscapeClause(stringBuilder, wbConnection, string2);
        }
        return true;
    }

    public static String cleanupIdentifier(String string) {
        if (string == null) {
            return "";
        }
        return string.replaceAll("[^A-Za-z0-9_]+", "");
    }

    public static String getIsolationLevelName(int n) {
        switch (n) {
            case 2: {
                return "READ COMMITTED";
            }
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
            case 0: {
                return "NONE";
            }
        }
        return "unknown";
    }

    public static String quoteLiteral(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        if (string.startsWith("'") && string.endsWith("'")) {
            return string;
        }
        return "'" + SqlUtil.escapeQuotes(string) + "'";
    }

    public static String replaceParameters(CharSequence charSequence, Object ... objectArray) {
        if (charSequence == null) {
            return "";
        }
        if (CollectionUtil.isEmpty(objectArray)) {
            return charSequence.toString();
        }
        int n = 0;
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(charSequence);
        SQLToken sQLToken = sQLLexer.getNextToken(true, true);
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + objectArray.length * 5);
        while (sQLToken != null) {
            if (sQLToken.getText().equals("?") && n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof String) {
                    stringBuilder.append(SqlUtil.quoteLiteral((String)object));
                } else if (object != null) {
                    stringBuilder.append(object.toString());
                } else {
                    stringBuilder.append("NULL");
                }
                ++n;
            } else {
                stringBuilder.append(sQLToken.getText());
            }
            sQLToken = sQLLexer.getNextToken(true, true);
        }
        return stringBuilder.toString();
    }

    public static void dumpResultSetInfo(String string, ResultSetMetaData resultSetMetaData) {
        if (!LogMgr.isDebugEnabled()) {
            return;
        }
        if (resultSetMetaData == null) {
            return;
        }
        try {
            int n = resultSetMetaData.getColumnCount();
            StringBuilder stringBuilder = new StringBuilder(n * 20);
            stringBuilder.append(string);
            stringBuilder.append(" returned: ");
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(Integer.toString(i));
                stringBuilder.append(": [");
                stringBuilder.append(resultSetMetaData.getColumnName(i));
                stringBuilder.append(']');
            }
            LogMgr.logDebug(new CallerInfo(){}, stringBuilder.toString());
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not access ResultSetMetaData", exception);
        }
    }

    public static SQLToken getOperatorBeforeCursor(String string, int n) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(string);
        ArrayList<SQLToken> arrayList = new ArrayList<SQLToken>();
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        while (sQLToken != null) {
            arrayList.add(sQLToken);
            sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken == null || sQLToken.getCharEnd() <= n) continue;
        }
        Set<String> set = CollectionUtil.caseInsensitiveSet("IN", "ANY", "ALL");
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SQLToken sQLToken2 = (SQLToken)arrayList.get(i);
            if (sQLToken2.getCharEnd() > n || !sQLToken2.isOperator() && !set.contains(sQLToken2.getContents())) continue;
            return (SQLToken)arrayList.get(i);
        }
        return null;
    }

    public static String getBaseTypeName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(40);
        if (n == -1) {
            n = string.indexOf(91);
        }
        if (n == -1) {
            n = string.indexOf(32);
        }
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getErrorIndicator(String string, ErrorDescriptor errorDescriptor) {
        if (errorDescriptor == null) {
            return null;
        }
        int n = errorDescriptor.getErrorPosition();
        if (n < 0) {
            return null;
        }
        int n2 = StringUtil.getLineStart(string, n);
        int n3 = StringUtil.getLineEnd(string, n);
        String string2 = null;
        if (n2 > -1 && n3 > n2) {
            String string3 = string.substring(n2, n3);
            String string4 = StringUtil.padRight("", n - n2) + "^";
            string2 = string3 + "\n" + string4;
        }
        return string2;
    }

    public static int getRealStart(String string) {
        if (StringUtil.isEmptyString(string)) {
            return 0;
        }
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(string);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken == null) {
            return 0;
        }
        return sQLToken.getCharBegin();
    }

    public static void calculateErrorLine(String string, ErrorDescriptor errorDescriptor) {
        if (errorDescriptor == null) {
            return;
        }
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        if (errorDescriptor.getErrorLine() > -1 && errorDescriptor.getErrorColumn() > -1) {
            return;
        }
        int n = errorDescriptor.getErrorPosition();
        if (n == -1) {
            return;
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n2) {
            if (n3 == n) {
                errorDescriptor.setErrorPosition(n4, n5);
                return;
            }
            char c = string.charAt(n3);
            if (c == '\r' || c == '\n') {
                if (c == '\r' && ++n3 < n2 && string.charAt(n3) == '\n') {
                    ++n3;
                }
                ++n4;
                n5 = 0;
                continue;
            }
            ++n5;
            ++n3;
        }
    }

    public static int getErrorOffset(String string, ErrorDescriptor errorDescriptor) {
        if (errorDescriptor == null) {
            return -1;
        }
        if (errorDescriptor.getErrorPosition() > -1) {
            return errorDescriptor.getErrorPosition();
        }
        if (StringUtil.isEmptyString(string)) {
            return -1;
        }
        int n = string.length();
        int n2 = errorDescriptor.getErrorLine();
        int n3 = errorDescriptor.getErrorColumn();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            if (n4 == n2 && n5 == n3) {
                return n6;
            }
            char c = string.charAt(n6);
            if (c == '\r' || c == '\n') {
                if (c == '\r' && ++n6 < n && string.charAt(n6) == '\n') {
                    ++n6;
                }
                ++n4;
                n5 = 0;
                continue;
            }
            ++n5;
            ++n6;
        }
        return -1;
    }

    public static DataStore getResult(WbConnection wbConnection, String string) {
        return SqlUtil.getResult(wbConnection, string, wbConnection.getDbSettings().useSavePointForDML());
    }

    public static DataStore getResult(WbConnection wbConnection, String string, boolean bl) {
        try {
            return SqlUtil.getResultData(wbConnection, string, bl);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve results", sQLException);
            return new DataStore(new String[0], new int[0]);
        }
    }

    public static DataStore getResultData(WbConnection wbConnection, String string, boolean bl) throws SQLException {
        ResultSet resultSet = null;
        Statement statement = null;
        Savepoint savepoint = null;
        DataStore dataStore = null;
        try {
            savepoint = bl && !wbConnection.getAutoCommit() ? wbConnection.setSavepoint() : null;
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            dataStore = new DataStore(resultSet, true);
            dataStore.setGeneratingSql(string);
            dataStore.resetStatus();
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    public static String getIdentifierAtCursor(TextContainer textContainer, WbConnection wbConnection) {
        String string = textContainer.getSelectedText();
        if (StringUtil.isEmptyString(string)) {
            String string2 = "_$";
            char c = SqlUtil.getSchemaSeparator(wbConnection);
            string2 = string2 + c;
            char c2 = SqlUtil.getCatalogSeparator(wbConnection);
            if (c2 != c) {
                string2 = string2 + c2;
            }
            string2 = string2 + wbConnection.getMetadata().getIdentifierQuoteCharacter();
            if (wbConnection.getMetadata().isSqlServer()) {
                string2 = string2 + "[]";
            }
            string = textContainer.getWordAtCursor(string2);
        }
        return SqlUtil.trimSemicolon(StringUtil.trimToNull(string));
    }

    public static boolean isReplaceDDL(String string, WbConnection wbConnection, DropType dropType) {
        if (string == null) {
            return false;
        }
        if (wbConnection == null) {
            return false;
        }
        String string2 = SqlParsingUtil.getInstance(wbConnection).getSqlVerb(string);
        return SqlUtil.isReplaceDDL(string2, dropType);
    }

    public static boolean isReplaceDDL(String string, DropType dropType) {
        if (dropType == DropType.none) {
            return false;
        }
        if (string == null) {
            return false;
        }
        return string.equals("CREATE OR REPLACE") || string.equalsIgnoreCase("REPLACE");
    }

    public static void cancelStatement(CallerInfo callerInfo, Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            LogMgr.logTrace(callerInfo, "Cancelling statement execution (" + StringUtil.getMaxSubstring(statement.toString(), 80) + ")");
            statement.cancel();
            LogMgr.logTrace(callerInfo, "Cancelled.");
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Error when cancelling statement", throwable);
        }
    }

    private static final class SqlTypeFieldsHolder {
        private static final Field[] SQL_TYPES = Types.class.getDeclaredFields();

        private SqlTypeFieldsHolder() {
        }
    }

    private static class TypesWithoutNamesHolder {
        private static final Set<String> TYPES = Collections.unmodifiableSet(CollectionUtil.treeSet("MATERIALIZED VIEW LOG", "SNAPSHOT LOG", "PFILE", "SPFILE", "SYSTEM", "DEFAULT PRIVILEGES"));

        private TypesWithoutNamesHolder() {
        }
    }

    private static class ModifyingVerbsHolder {
        private static final Set<String> DML_VERB = Collections.unmodifiableSet(CollectionUtil.caseInsensitiveSet("update", "delete"));

        private ModifyingVerbsHolder() {
        }
    }

    private static class KnownTypesHolder {
        protected static final Set<String> KNOWN_TYPES = Collections.unmodifiableSet(CollectionUtil.caseInsensitiveSet("INDEX", "TABLE", "PROCEDURE", "FUNCTION", "VIEW", "PACKAGE", "PACKAGE BODY", "SYNONYM", "SEQUENCE", "ALIAS", "TRIGGER", "DOMAIN", "ROLE", "CAST", "AGGREGATE", "TABLESPACE", "TYPE", "USER", "USER MAPPING", "MATERIALIZED VIEW LOG", "MATERIALIZED VIEW", "SNAPSHOT", "FLASHBACK ARCHIVE", "TYPE BODY", "CAST", "FOREIGN DATA WRAPPER", "OPERATOR", "SCHEMA", "EXTENSION", "DATABASE", "DATABASE LINK", "PFILE", "SPFILE", "SYSTEM", "RULE", "POLICY", "SERVER", "EVENT TRIGGER", "STATISTICS", "PUBLICATION", "SUBSCRIPTION", "TABLESPACE", "FOREIGN TABLE", "COLLATION", "FOREIGN DATA WRAPPER", "PARTITION FUNCTION", "PARTITION SCHEME", "DEFAULT PRIVILEGES"));

        private KnownTypesHolder() {
        }
    }

    private static class JoinKeywordsHolder {
        private static final Set<String> JOIN_KEYWORDS = Collections.unmodifiableSet(CollectionUtil.caseInsensitiveSet("JOIN", "INNER JOIN", "NATURAL JOIN", "LEFT JOIN", "LEFT OUTER JOIN", "RIGHT JOIN", "RIGHT OUTER JOIN", "CROSS JOIN", "FULL JOIN", "FULL OUTER JOIN", "OUTER APPLY", "CROSS APPLY", "JOIN LATERAL", "CROSS JOIN LATERAL", "LEFT JOIN LATERAL", "LEFT OUTER JOIN LATERAL", "RIGHT JOIN LATERAL", "RIGHT OUTER JOIN LATERAL", "FULL JOIN LATERAL", "FULL OUTER JOIN LATERAL"));

        private JoinKeywordsHolder() {
        }
    }
}

