/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;

public class ThreadDumper {
    private ThreadMXBean tmbean = ManagementFactory.getThreadMXBean();
    private static String INDENT = "    ";

    public String getThreadDump() {
        String string = null;
        try {
            string = this.dumpThreadInfo();
        }
        catch (Throwable throwable) {
            string = this.getStandardDump();
        }
        return string;
    }

    private String getStandardDump() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        StringBuilder stringBuilder = new StringBuilder(map.size() * 100);
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            Thread thread = entry.getKey();
            stringBuilder.append("Thread: \"" + thread.getName() + "\", id=" + thread.getId() + ", prio=" + thread.getPriority() + "\n");
            stringBuilder.append("  State: " + thread.getState().toString() + "\n");
            for (StackTraceElement stackTraceElement : entry.getValue()) {
                stringBuilder.append("      ");
                stringBuilder.append(stackTraceElement.toString() + "\n");
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private String dumpThreadInfo() {
        ThreadInfo[] threadInfoArray;
        StringWriter stringWriter = new StringWriter(2000);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Full Java thread dump");
        long[] lArray = this.tmbean.getAllThreadIds();
        for (ThreadInfo threadInfo : threadInfoArray = this.tmbean.getThreadInfo(lArray, Integer.MAX_VALUE)) {
            this.printThreadInfo(printWriter, threadInfo);
        }
        return stringWriter.toString();
    }

    private String dumpThreadInfoWithLocks() {
        ThreadInfo[] threadInfoArray;
        StringWriter stringWriter = new StringWriter(2000);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Full Java thread dump with locks info");
        for (ThreadInfo threadInfo : threadInfoArray = this.tmbean.dumpAllThreads(true, true)) {
            this.printThreadInfo(printWriter, threadInfo);
            LockInfo[] lockInfoArray = threadInfo.getLockedSynchronizers();
            this.printLockInfo(printWriter, lockInfoArray);
        }
        return stringWriter.toString();
    }

    private void printThreadInfo(PrintWriter printWriter, ThreadInfo threadInfo) {
        this.printThread(printWriter, threadInfo);
        StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
        MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            printWriter.println(INDENT + "at " + stackTraceElement.toString());
            for (MonitorInfo monitorInfo : monitorInfoArray) {
                if (monitorInfo.getLockedStackDepth() != i) continue;
                printWriter.println(INDENT + "  - locked " + monitorInfo);
            }
        }
        printWriter.println();
    }

    private void printThread(PrintWriter printWriter, ThreadInfo threadInfo) {
        StringBuilder stringBuilder = new StringBuilder("\"" + threadInfo.getThreadName() + "\" Id=" + threadInfo.getThreadId() + " in " + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            stringBuilder.append(" on lock=" + threadInfo.getLockName());
        }
        if (threadInfo.isSuspended()) {
            stringBuilder.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            stringBuilder.append(" (running in native)");
        }
        printWriter.println(stringBuilder.toString());
        if (threadInfo.getLockOwnerName() != null) {
            printWriter.println(INDENT + " owned by " + threadInfo.getLockOwnerName() + " Id=" + threadInfo.getLockOwnerId());
        }
    }

    private void printMonitorInfo(PrintWriter printWriter, ThreadInfo threadInfo, MonitorInfo[] monitorInfoArray) {
        printWriter.println(INDENT + "Locked monitors: count = " + monitorInfoArray.length);
        for (MonitorInfo monitorInfo : monitorInfoArray) {
            printWriter.println(INDENT + "  - " + monitorInfo + " locked at ");
            printWriter.println(INDENT + "      " + monitorInfo.getLockedStackDepth() + " " + monitorInfo.getLockedStackFrame());
        }
    }

    private void printLockInfo(PrintWriter printWriter, LockInfo[] lockInfoArray) {
        printWriter.println(INDENT + "Locked synchronizers: count = " + lockInfoArray.length);
        for (LockInfo lockInfo : lockInfoArray) {
            printWriter.println(INDENT + "  - " + lockInfo);
        }
        printWriter.println();
    }

    public String getDeadlockDump() {
        StringWriter stringWriter = new StringWriter(2000);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (this.tmbean.isSynchronizerUsageSupported()) {
            ThreadInfo[] threadInfoArray;
            long[] lArray = this.tmbean.findDeadlockedThreads();
            if (lArray == null) {
                return null;
            }
            printWriter.println("Deadlock found :-");
            for (ThreadInfo threadInfo : threadInfoArray = this.tmbean.getThreadInfo(lArray, true, true)) {
                this.printThreadInfo(printWriter, threadInfo);
                this.printLockInfo(printWriter, threadInfo.getLockedSynchronizers());
                printWriter.println();
            }
        } else {
            ThreadInfo[] threadInfoArray;
            long[] lArray = this.tmbean.findMonitorDeadlockedThreads();
            if (lArray == null) {
                return null;
            }
            for (ThreadInfo threadInfo : threadInfoArray = this.tmbean.getThreadInfo(lArray, Integer.MAX_VALUE)) {
                this.printThreadInfo(printWriter, threadInfo);
            }
        }
        return stringWriter.toString();
    }
}

