/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import workbench.util.StringUtil;

public class WbNumberFormatter {
    private final DecimalFormat formatter;
    private final char decimalSymbol;
    private final int maxDigits;
    private final boolean fixedDigits;
    private final boolean alwaysUseFormatter;

    public WbNumberFormatter(char c) {
        this(0, c);
    }

    public WbNumberFormatter(int n, char c) {
        this(n, c, false);
    }

    public WbNumberFormatter(int n, char c, boolean bl) {
        char c2 = bl ? (char)'0' : '#';
        this.decimalSymbol = c;
        String string = StringUtil.padRight("0.", n > 0 ? n + 2 : 22, c2);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator(c);
        this.formatter = new DecimalFormat(string, decimalFormatSymbols);
        this.maxDigits = n;
        this.fixedDigits = bl;
        this.alwaysUseFormatter = false;
    }

    public WbNumberFormatter(String string, char c, char c2) {
        this.decimalSymbol = c;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator(this.decimalSymbol);
        decimalFormatSymbols.setGroupingSeparator(c2);
        this.formatter = new DecimalFormat(string, decimalFormatSymbols);
        this.maxDigits = 0;
        this.fixedDigits = false;
        this.alwaysUseFormatter = true;
    }

    public char getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public String toFormatterPattern() {
        return this.formatter.toPattern();
    }

    private boolean isInteger(Number number) {
        return number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof BigInteger || number instanceof AtomicInteger || number instanceof AtomicLong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Number number) {
        if (number == null) {
            return "";
        }
        String string = null;
        if (this.alwaysUseFormatter) {
            DecimalFormat decimalFormat = this.formatter;
            synchronized (decimalFormat) {
                string = this.formatter.format(number);
            }
        }
        if (number instanceof BigDecimal) {
            string = this.format((BigDecimal)number);
        } else if (this.isInteger(number)) {
            string = number.toString();
        } else {
            DecimalFormat decimalFormat = this.formatter;
            synchronized (decimalFormat) {
                string = this.formatter.format(number);
            }
        }
        return string;
    }

    private String format(BigDecimal bigDecimal) {
        int n;
        int n2;
        String string = bigDecimal.toPlainString();
        if (this.maxDigits <= 0 && this.decimalSymbol == '.') {
            return string;
        }
        int n3 = bigDecimal.scale();
        if (n3 <= 0 && !this.fixedDigits) {
            return string;
        }
        if (n3 > this.maxDigits && this.maxDigits > 0) {
            BigDecimal bigDecimal2 = bigDecimal.setScale(this.maxDigits, RoundingMode.HALF_UP);
            string = bigDecimal2.toPlainString();
        }
        if (this.fixedDigits && this.maxDigits > 0 && (n2 = (n = string.lastIndexOf(46)) == -1 ? 0 : string.length() - n - 1) < this.maxDigits) {
            int n4 = this.maxDigits - n2;
            StringBuilder stringBuilder = new StringBuilder(string.length() + n4);
            stringBuilder.append(string);
            if (n2 == 0) {
                stringBuilder.append(this.decimalSymbol);
            }
            for (int i = 0; i < n4; ++i) {
                stringBuilder.append('0');
            }
            if (this.decimalSymbol != '.' && n2 > 0) {
                stringBuilder.setCharAt(n, this.decimalSymbol);
            }
            return stringBuilder.toString();
        }
        if (this.decimalSymbol != '.') {
            int n5 = string.lastIndexOf(46);
            char[] cArray = string.toCharArray();
            cArray[n5] = this.decimalSymbol;
            string = new String(cArray);
        }
        return string;
    }
}

