/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.osm.cachestruct;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.TileCacheLocator;
import org.gvsig.raster.cache.tile.exception.TileBuildException;
import org.gvsig.raster.cache.tile.provider.CacheStruct;
import org.gvsig.raster.osm.cachestruct.TileMatrix;
import org.gvsig.raster.osm.cachestruct.TileMatrixLimits;
import org.gvsig.raster.osm.cachestruct.TileMatrixSet;

public class OSMCacheStruct
implements CacheStruct {
    private TileMatrixSet tileMatrixSet = null;
    private ArrayList<TileMatrixLimits> limits = null;
    private String layerName = null;
    private Rectangle2D worldExtent = null;
    private String fileSuffix = null;
    private String epsg = null;
    private long fileSize = 0L;
    private double realPixelSize = 0.0;

    public OSMCacheStruct(int levels, int tilePxWidth, int tilePxHeight, String layerName, String baseDir, String fileSuffix, long size) {
        this.layerName = layerName;
        this.fileSuffix = fileSuffix;
        this.fileSize = size;
        this.epsg = "EPSG:3857";
        this.worldExtent = new Rectangle2D.Double(-2.0037508E7, -2.0037508E7, 4.0075016E7, 4.0075016E7);
        double[][] pixelSizeList = this.buildWorldMatrix(levels, tilePxWidth, tilePxHeight, this.worldExtent);
        this.buildLayerMatrix(levels, tilePxWidth, tilePxHeight, this.worldExtent, pixelSizeList);
    }

    private void buildLayerMatrix(int levels, int tilePxWidth, int tilePxHeight, Rectangle2D worldExtent, double[][] pixelSizeList) {
        this.limits = new ArrayList();
        for (int i = 0; i < levels; ++i) {
            int minTileCol = 0;
            int minTileRow = 0;
            int maxTileCol = i == 0 ? 0 : (int)Math.pow(2.0, i) - 1;
            int maxTileRow = i == 0 ? 0 : (int)Math.pow(2.0, i) - 1;
            TileMatrixLimits limit = new TileMatrixLimits();
            limit.setMinTileRow(minTileRow);
            limit.setMinTileCol(minTileCol);
            limit.setMaxTileRow(maxTileRow);
            limit.setMaxTileCol(maxTileCol);
            double ulx = worldExtent.getMinX() + (double)(minTileCol * tilePxWidth) * pixelSizeList[0][i];
            double uly = worldExtent.getMaxY() - (double)(minTileRow * tilePxHeight) * pixelSizeList[1][i];
            limit.getTileMatrix().setTopLeftCorner(new double[]{ulx, uly});
            limit.getTileMatrix().setScaleXDenominator(pixelSizeList[0][i]);
            limit.getTileMatrix().setScaleYDenominator(pixelSizeList[1][i]);
            limit.getTileMatrix().setTileWidth(tilePxWidth);
            limit.getTileMatrix().setTileHeight(tilePxHeight);
            this.limits.add(limit);
        }
    }

    private double[][] buildWorldMatrix(int levels, int tilePxWidth, int tilePxHeight, Rectangle2D worldExtent) {
        double[] pixelSizeXList = new double[levels];
        double[] pixelSizeYList = new double[levels];
        this.limits = new ArrayList();
        this.tileMatrixSet = new TileMatrixSet();
        this.tileMatrixSet.setBbox(worldExtent);
        int nTilesWidth = 0;
        int nTilesHeight = 0;
        for (int i = 0; i < levels; ++i) {
            TileMatrix tm = new TileMatrix();
            tm.setTileWidth(tilePxWidth);
            tm.setTileHeight(tilePxHeight);
            nTilesWidth = i == 0 ? 1 : nTilesWidth * 2;
            nTilesHeight = i == 0 ? 1 : nTilesHeight * 2;
            tm.setMatrixWidth(nTilesWidth);
            tm.setMatrixHeight(nTilesHeight);
            pixelSizeXList[i] = tilePxWidth * nTilesWidth != 0 ? worldExtent.getWidth() / (double)((long)tilePxWidth * (long)nTilesWidth) : 0.0;
            pixelSizeYList[i] = tilePxHeight * nTilesHeight != 0 ? worldExtent.getHeight() / (double)((long)tilePxHeight * (long)nTilesHeight) : 0.0;
            tm.setScaleXDenominator(pixelSizeXList[i]);
            tm.setScaleYDenominator(pixelSizeYList[i]);
            this.tileMatrixSet.getTileMatrix().add(tm);
        }
        double[][] r = new double[][]{pixelSizeXList, pixelSizeYList};
        return r;
    }

    public Extent getWorldExtent() {
        return RasterLocator.getManager().getDataStructFactory().createExtent(this.worldExtent);
    }

    public int getNumberOfLevels() {
        return this.tileMatrixSet.getTileMatrix().size();
    }

    public String getLayerName() {
        return this.layerName;
    }

    public String getServerURL() {
        return this.layerName;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public int[] getTileSizeByLevel(int level) {
        return new int[]{this.tileMatrixSet.getTileMatrix().get(level).getTileWidth(), this.tileMatrixSet.getTileMatrix().get(level).getTileHeight()};
    }

    public double[] getTileSizeInRealCoordsByLevel(int level) {
        return new double[]{this.tileMatrixSet.getTileMatrix().get(level).getScaleXDenominator() * (double)this.tileMatrixSet.getTileMatrix().get(level).getTileWidth(), this.tileMatrixSet.getTileMatrix().get(level).getScaleYDenominator() * (double)this.tileMatrixSet.getTileMatrix().get(level).getTileHeight()};
    }

    public int getLayerWidthOfTileMatrixByLevel(int level) {
        TileMatrixLimits l = this.limits.get(level);
        return l.getMaxTileRow() - l.getMinTileRow();
    }

    public int getLayerHeightOfTileMatrixByLevel(int level) {
        TileMatrixLimits l = this.limits.get(level);
        return l.getMaxTileCol() - l.getMinTileCol();
    }

    public int getLayerInitXTilePositionByLevel(int level) {
        TileMatrixLimits l = this.limits.get(level);
        return l.getMinTileCol();
    }

    public int getLayerInitYTilePositionByLevel(int level) {
        TileMatrixLimits l = this.limits.get(level);
        return l.getMinTileRow();
    }

    public long getWorldHeightOfTileMatrixByLevel(int level) {
        return this.tileMatrixSet.getTileMatrix().get(level).getMatrixWidth();
    }

    public long getWorldWidthOfTileMatrixByLevel(int level) {
        return this.tileMatrixSet.getTileMatrix().get(level).getMatrixHeight();
    }

    public double getPixelSizeByLevel(int level) {
        if (level < 0) {
            return this.realPixelSize;
        }
        return this.tileMatrixSet.getTileMatrix().get(level).getScaleXDenominator();
    }

    public Point2D[] getTileExtent(Tile tile) {
        return this.limits.get(tile.getLevel()).getTileExtent(tile.getRow(), tile.getCol());
    }

    public Point2D[] getTileExtent(int level, int col, int row) {
        return this.limits.get(level).getTileExtent(row, col);
    }

    public List<Tile> getTileList(Rectangle2D r) {
        return null;
    }

    public List<Tile> getTileList(Point2D ul, Point2D lr, double mtsPixelXRequest) {
        int tilePxWidth = 0;
        int tilePxHeight = 0;
        double tileWCWidth = 0.0;
        double tileWCHeight = 0.0;
        int level = 0;
        double mtsPixelXLevel = 0.0;
        double mtsPixelYLevel = 0.0;
        for (int i = 0; i < this.tileMatrixSet.getTileMatrix().size(); ++i) {
            mtsPixelXLevel = this.tileMatrixSet.getTileMatrix().get(i).getScaleXDenominator();
            mtsPixelYLevel = this.tileMatrixSet.getTileMatrix().get(i).getScaleYDenominator();
            if (!(this.clipDecimals(mtsPixelXRequest, 6) >= this.clipDecimals(mtsPixelXLevel, 6)) && i != this.tileMatrixSet.getTileMatrix().size() - 1) continue;
            level = Math.max(i, 0);
            if (level > this.limits.size() - 1) {
                level = this.limits.size() - 1;
                mtsPixelXLevel = this.tileMatrixSet.getTileMatrix().get(level).getScaleXDenominator();
                mtsPixelYLevel = this.tileMatrixSet.getTileMatrix().get(level).getScaleYDenominator();
            }
            tilePxWidth = this.tileMatrixSet.getTileMatrix().get(level).getTileWidth();
            tilePxHeight = this.tileMatrixSet.getTileMatrix().get(level).getTileHeight();
            tileWCWidth = (double)tilePxWidth * mtsPixelXLevel;
            tileWCHeight = (double)tilePxHeight * mtsPixelYLevel;
            break;
        }
        int minTileCol = (int)(Math.abs(ul.getX() - this.worldExtent.getMinX()) / mtsPixelXLevel / (double)tilePxWidth);
        int minTileRow = (int)(Math.abs(ul.getY() - this.worldExtent.getMaxY()) / mtsPixelYLevel / (double)tilePxHeight);
        double maxTC = Math.abs(lr.getX() - this.worldExtent.getMinX()) / mtsPixelXLevel / (double)tilePxWidth;
        double maxTR = Math.abs(lr.getY() - this.worldExtent.getMaxY()) / mtsPixelYLevel / (double)tilePxHeight;
        int maxTileCol = maxTC - (double)((int)maxTC) == 0.0 ? (int)(maxTC - 1.0) : (int)maxTC;
        int maxTileRow = maxTR - (double)((int)maxTR) == 0.0 ? (int)(maxTR - 1.0) : (int)maxTR;
        ArrayList<Tile> tileList = new ArrayList<Tile>();
        for (int i = minTileRow; i <= maxTileRow; ++i) {
            for (int j = minTileCol; j <= maxTileCol; ++j) {
                Point2D.Double ulTile = new Point2D.Double(this.worldExtent.getMinX() + tileWCWidth * (double)j, this.worldExtent.getMaxY() - tileWCHeight * (double)i);
                Point2D.Double lrTile = new Point2D.Double(((Point2D)ulTile).getX() + tileWCWidth, ((Point2D)ulTile).getY() - tileWCHeight);
                Tile t = TileCacheLocator.getManager().createTile(tilePxWidth, tilePxHeight, i, j, (Point2D)ulTile, (Point2D)lrTile);
                t.setLevel(level);
                tileList.add(t);
            }
        }
        return tileList;
    }

    public boolean compare(CacheStruct struct) {
        if (struct.getNumberOfLevels() == this.getNumberOfLevels()) {
            for (int i = 0; i < this.getNumberOfLevels(); ++i) {
                if (struct.getTileSizeByLevel(i)[0] != this.getTileSizeByLevel(i)[0] || struct.getTileSizeByLevel(i)[1] != this.getTileSizeByLevel(i)[1] || struct.getWorldHeightOfTileMatrixByLevel(i) != this.getWorldHeightOfTileMatrixByLevel(i) || struct.getWorldWidthOfTileMatrixByLevel(i) != this.getWorldWidthOfTileMatrixByLevel(i) || this.clipDecimals(struct.getPixelSizeByLevel(i), 2) != this.clipDecimals(this.getPixelSizeByLevel(i), 2) || !this.compareExtents(struct.getTileExtent(i, 0, 0), this.getTileExtent(i, 0, 0))) continue;
                return true;
            }
        }
        return false;
    }

    public String getEPSG() {
        return this.epsg;
    }

    public String getFileSize() {
        return this.fileSize + "";
    }

    private boolean compareExtents(Point2D[] p, Point2D[] p1) {
        return p[0].getX() == p1[0].getX() && p[0].getY() == p1[0].getY() && p[1].getX() == p1[1].getX() && p[1].getY() == p1[1].getY();
    }

    public double clipDecimals(double num, int n) {
        long m = (long)Math.pow(10.0, n);
        long aux = Math.round(num * (double)m);
        return (double)aux / (double)m;
    }

    public Tile getTileStructure(int level, int tileCol, int tileRow, Point2D ul, Point2D lr) throws TileBuildException {
        int[] size = this.getTileSizeByLevel(level);
        Tile tile = TileCacheLocator.getManager().createTile(level, tileRow, tileCol);
        tile.setUl(ul);
        tile.setLr(lr);
        tile.setWidthPx(size[0]);
        tile.setHeightPx(size[1]);
        return tile;
    }
}

