/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.cts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.cresques.cts.ICRSFactory;
import org.cresques.cts.IProjection;
import org.cresques.impl.cts.gt2.CSDatum;
import org.cresques.impl.cts.gt2.CSGaussPt;
import org.cresques.impl.cts.gt2.CSLambertCC;
import org.cresques.impl.cts.gt2.CSMercator;
import org.cresques.impl.cts.gt2.CSUTM;
import org.cresques.impl.cts.gt2.CoordSys;

public class ProjectionPool
implements ICRSFactory {
    static TreeMap data;

    public static void add(String name, IProjection proj) {
        data.put(name, proj);
    }

    public IProjection get(String name) {
        IProjection proj = null;
        if (data.containsKey(name)) {
            proj = (IProjection)data.get(name);
        } else {
            System.err.println("ProjectionPool: Key '" + name + "' not set.");
        }
        return proj;
    }

    public static Iterator iterator() {
        ArrayList projs = new ArrayList();
        Iterator iter = data.entrySet().iterator();
        while (iter.hasNext()) {
            projs.add(iter.next().getValue());
        }
        return projs.iterator();
    }

    public boolean doesRigurousTransformations() {
        return false;
    }

    public IProjection get(String format, String value) {
        return null;
    }

    static {
        String huso;
        int i;
        data = null;
        CoordSys cs = null;
        data = new TreeMap();
        cs = new CSUTM(CSDatum.wgs84, 30).toGeo();
        cs.setAbrev("EPSG:4326");
        data.put(cs.getAbrev(), cs);
        data.put("CRS:84", cs);
        cs = new CSUTM(CSDatum.ed50, 30).toGeo();
        cs.setAbrev("EPSG:4230");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.d73, 30).toGeo();
        cs.setAbrev("EPSG:4274");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.nad27, 30).toGeo();
        cs.setAbrev("EPSG:4267");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.nad83, 30).toGeo();
        cs.setAbrev("EPSG:4269");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.lomaQuintana, 30).toGeo();
        cs.setAbrev("EPSG:4288");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.laCanoa, 30).toGeo();
        cs.setAbrev("EPSG:4247");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.ntfParis, 30).toGeo();
        cs.setAbrev("EPSG:4807");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.etrs89, 30).toGeo();
        cs.setAbrev("EPSG:4258");
        data.put(cs.getAbrev(), cs);
        for (i = 1; i <= 60; ++i) {
            huso = Integer.toString(i);
            if (i < 10) {
                huso = "0" + huso;
            }
            cs = new CSUTM(CSDatum.wgs84, i);
            cs.setAbrev("EPSG:326" + huso);
            data.put(cs.getAbrev(), cs);
            cs = new CSUTM(CSDatum.ed50, i);
            cs.setAbrev("EPSG:230" + huso);
            data.put(cs.getAbrev(), cs);
            if (i > 2 && i <= 23) {
                cs = new CSUTM(CSDatum.nad27, i);
                cs.setAbrev("EPSG:267" + huso);
                data.put(cs.getAbrev(), cs);
                cs = new CSUTM(CSDatum.nad83, i);
                cs.setAbrev("EPSG:269" + huso);
                data.put(cs.getAbrev(), cs);
            }
            if (i <= 27 || i >= 39) continue;
            cs = new CSUTM(CSDatum.etrs89, i);
            cs.setAbrev("EPSG:258" + huso);
            data.put(cs.getAbrev(), cs);
        }
        cs = CSGaussPt.hgd73;
        cs.setAbrev("EPSG:27492");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.d73, 29);
        cs.setAbrev("EPSG:27429");
        data.put(cs.getAbrev(), cs);
        for (i = 18; i <= 21; ++i) {
            huso = Integer.toString(i);
            if (i < 10) {
                huso = "0" + huso;
            }
            cs = new CSUTM(CSDatum.laCanoa, i);
            cs.setAbrev("EPSG:247" + huso);
            data.put(cs.getAbrev(), cs);
        }
        for (i = 16; i <= 22; ++i) {
            huso = Integer.toString(i);
            cs = new CSUTM(CSDatum.lomaQuintana, i);
            cs.setAbrev("EPSG:288" + huso);
            data.put(cs.getAbrev(), cs);
            cs = new CSUTM(CSDatum.lomaQuintana, i, "S");
            cs.setAbrev("EPSG:288" + (i + 60));
            data.put(cs.getAbrev(), cs);
        }
        cs = new CSLambertCC(CSDatum.wgs84, -95.0, 0.0, 49.0, 77.0, 0.0, -8000000.0);
        cs.setAbrev("EPSG:42101");
        data.put(cs.getAbrev(), cs);
        cs = new CSLambertCC(CSDatum.nad83, -95.0, 49.0, 49.0, 77.0, 0.0, 0.0);
        cs.setAbrev("EPSG:42304");
        data.put(cs.getAbrev(), cs);
        cs = new CSLambertCC(CSDatum.ntfParis, 0.0, 46.79999999999995, 0.99987742, 600000.0, 2200000.0);
        cs.setAbrev("EPSG:27572");
        data.put(cs.getAbrev(), cs);
        cs = new CSLambertCC(CSDatum.ntfParis, 0.0, 52.0, 0.99987742, 600000.0, 2200000.0);
        cs.setAbrev("EPSG:27582");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.rgf93, 30).toGeo();
        cs.setAbrev("EPSG:4171");
        data.put(cs.getAbrev(), cs);
        cs = new CSLambertCC(CSDatum.rgf93, 3.0, 46.5, 49.0, 44.0, 700000.0, 6600000.0);
        cs.setAbrev("EPSG:2154");
        data.put(cs.getAbrev(), cs);
        cs = new CSMercator(CSDatum.wgs84);
        cs.setAbrev("EPSG:54004");
        data.put(cs.getAbrev(), cs);
        cs.setAbrev("EPSG:9804");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.moon, 30).toGeo();
        cs.setAbrev("IAU2000:30100");
        data.put(cs.getAbrev(), cs);
        cs = new CSUTM(CSDatum.mars, 30).toGeo();
        cs.setAbrev("IAU2000:49900");
        data.put(cs.getAbrev(), cs);
        cs = new CoordSys(CSDatum.posgar);
        cs.setAbrev("EPSG:4172");
        data.put(cs.getAbrev(), cs);
        cs = new CoordSys("GEOGCS[\"GCS_Campo_Inchauspe\",DATUM[\"D_Campo_Inchauspe\",SPHEROID[\"International_1924\",6378388,297],TOWGS84[0,0,0,0,0,0,0]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.017453292519943295]]");
        cs.setAbrev("EPSG:4221");
        data.put(cs.getAbrev(), cs);
        for (i = 1; i <= 7; ++i) {
            cs = new CoordSys("PROJCS[\"Argentina_Zone_" + i + "\"," + "GEOGCS[\"GCS_Campo_Inchauspe\"," + "DATUM[\"D_Campo_Inchauspe\"," + "SPHEROID[\"International_1924\",6378388,297]," + "TOWGS84[0,0,0,0,0,0,0]]," + "PRIMEM[\"Greenwich\",0]," + "UNIT[\"Degree\",0.017453292519943295]]," + "PROJECTION[\"Transverse_Mercator\"]," + "PARAMETER[\"False_Easting\",1500000]," + "PARAMETER[\"False_Northing\",0]," + "PARAMETER[\"Central_Meridian\"," + (-75 + 3 * i) + "]," + "PARAMETER[\"Scale_Factor\",1]," + "PARAMETER[\"Latitude_Of_Origin\",-90]," + "UNIT[\"Meter\",1]]");
            cs.setAbrev("EPSG:2219" + i);
            data.put(cs.getAbrev(), cs);
        }
    }
}

