/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.cts.gt2;

import javax.media.jai.ParameterList;
import org.cresques.cts.UTM;
import org.cresques.impl.cts.gt2.CSDatum;
import org.cresques.impl.cts.gt2.CoordSys;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.Projection;
import org.geotools.units.Unit;
import org.gvsig.fmap.crs.CRSFactory;
import org.opengis.referencing.FactoryException;

public class CSUTM
extends CoordSys
implements UTM {
    public CSUTM(CSDatum datum, int zone) {
        super(datum);
        this.init(datum, zone, "N");
    }

    public CSUTM(CSDatum datum, int zone, String ns) {
        super(datum);
        this.init(datum, zone, ns);
    }

    public void init(CSDatum datum, int zone, String ns) {
        Unit linearUnit = Unit.METRE;
        ParameterList params = this.csFactory.createProjectionParameterList("Transverse_Mercator");
        params.setParameter("semi_major", datum.getDatum().getEllipsoid().getSemiMajorAxis());
        params.setParameter("semi_minor", datum.getDatum().getEllipsoid().getSemiMinorAxis());
        params.setParameter("central_meridian", (double)(zone * 6 - 183));
        params.setParameter("latitude_of_origin", 0.0);
        params.setParameter("scale_factor", 0.9996);
        params.setParameter("false_easting", 500000.0);
        if (ns.toUpperCase().compareTo("S") == 0) {
            params.setParameter("false_northing", 1.0E7);
        } else {
            params.setParameter("false_northing", 0.0);
        }
        try {
            Projection projection = this.csFactory.createProjection((CharSequence)("UTM" + zone), "Transverse_Mercator", params);
            this.projCS = this.csFactory.createProjectedCoordinateSystem((CharSequence)projection.getName().toString(), this.geogCS, projection, linearUnit, AxisInfo.X, AxisInfo.Y);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    @Override
    public double getScale(double minX, double maxX, double w, double dpi) {
        double scale = super.getScale(minX, maxX, w, dpi);
        if (this.projCS != null) {
            scale = (maxX - minX) * (dpi / 2.54 * 100.0) / w;
        }
        return scale;
    }

    @Override
    public String toString() {
        return this.projCS.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return CRSFactory.getCRS((String)this.getFullCode());
    }
}

