/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.cts.wkt;

import java.util.ArrayList;

public abstract class WKT {
    public abstract String toWKT();

    static class ProjCS
    extends Parameter {
        GeogCS geogcs;
        Projection proj;
        ArrayList params = new ArrayList();
        Unit unit;
        TwinAxes axes = null;

        public ProjCS(String n, GeogCS cs, Projection prj, Unit u) {
            super(n);
            Parameter[] p = new Parameter[]{};
            this.init(n, cs, prj, p, u, null);
        }

        public ProjCS(String n, GeogCS cs, Projection prj, Parameter[] p, Unit u) {
            super(n);
            this.init(n, cs, prj, p, u, null);
        }

        public ProjCS(String n, GeogCS cs, Projection prj, Unit u, TwinAxes t, Authority a) {
            super(n, a);
            Parameter[] p = new Parameter[]{};
            this.init(n, cs, prj, p, u, t);
        }

        public ProjCS(String n, GeogCS cs, Projection prj, Parameter[] p, Unit u, TwinAxes t, Authority a) {
            super(n, a);
            this.init(n, cs, prj, p, u, t);
        }

        private void init(String n, GeogCS cs, Projection prj, Parameter[] p, Unit u, TwinAxes t) {
            this.geogcs = cs;
            this.proj = prj;
            for (int i = 0; i < p.length; ++i) {
                this.params.add(p[i]);
            }
            this.unit = u;
            this.axes = t;
        }

        public void add(Parameter p) {
            this.params.add(p);
        }

        @Override
        public String toWKT() {
            String txt = "PROJCS[\"" + this.name + "\"," + this.geogcs.toWKT() + "," + this.proj.toWKT();
            for (int i = 0; i < this.params.size(); ++i) {
                txt = txt + "," + ((Parameter)this.params.get(i)).toWKT();
            }
            txt = txt + "," + this.unit.toWKT();
            if (this.axes != null) {
                txt = txt + "," + this.axes.toWKT();
            }
            if (this.authority != null) {
                txt = txt + "," + this.authority.toWKT();
            }
            return txt + "]";
        }
    }

    static class Projection
    extends Parameter {
        public Projection(String n) {
            super(n);
        }

        public Projection(String n, Authority a) {
            super(n, a);
        }

        @Override
        public String toWKT() {
            String txt = "PROJECTION[\"" + this.name + "\"";
            if (this.authority != null) {
                txt = txt + "," + this.authority.toWKT();
            }
            return txt + "]";
        }
    }

    static class GeogCS
    extends WKT {
        String name;
        Datum datum;
        PrimeM primeMeridian;
        Unit unit;
        TwinAxes axes = null;
        Authority authority = null;

        public GeogCS(String n, Datum d, PrimeM p, Unit u) {
            this.init(n, d, p, u, null, null);
        }

        public GeogCS(String n, Datum d, PrimeM p, Unit u, Authority a) {
            this.init(n, d, p, u, null, a);
        }

        public GeogCS(String n, Datum d, PrimeM p, Unit u, TwinAxes t) {
            this.init(n, d, p, u, t, null);
        }

        public GeogCS(String n, Datum d, PrimeM p, Unit u, TwinAxes t, Authority a) {
            this.init(n, d, p, u, t, a);
        }

        private void init(String n, Datum d, PrimeM p, Unit u, TwinAxes t, Authority a) {
            this.name = n;
            this.datum = d;
            this.primeMeridian = p;
            this.unit = u;
            this.axes = t;
            this.authority = a;
        }

        @Override
        public String toWKT() {
            String txt = "GEOGCS[\"" + this.name + "\"," + this.datum.toWKT() + "," + this.primeMeridian.toWKT() + "," + this.unit.toWKT();
            if (this.axes != null) {
                txt = txt + "," + this.axes.toWKT();
            }
            if (this.authority != null) {
                txt = txt + "," + this.authority.toWKT();
            }
            return txt + "]";
        }
    }

    static class TwinAxes {
        Axis axe1;
        Axis axe2;

        public TwinAxes(Axis a1, Axis a2) {
            this.axe1 = a1;
            this.axe2 = a2;
        }

        public String toWKT() {
            return this.axe1.toWKT() + "," + this.axe2.toWKT();
        }
    }

    static class Axis
    extends Orientation {
        String name;

        public Axis(String name, int to) {
            super(to);
            this.name = name;
        }

        public String toWKT() {
            return "AXIS[\"" + this.name + "\"," + this.txt[this.to] + "]";
        }
    }

    static class Orientation {
        public static final int NORTH = 0;
        public static final int SOUTH = 1;
        public static final int EAST = 2;
        public static final int WEST = 3;
        public static final int UP = 4;
        public static final int DOWN = 5;
        public static final int OTHER = 6;
        protected final String[] txt = new String[]{"NORTH", "SOUTH", "EAST", "WEST", "UP", "DOWN", "OTHER"};
        protected int to = -1;

        public Orientation(int to) {
            this.to = to;
        }
    }

    static class Unit {
        String name;
        double conversionFactor;
        Authority authority;

        public Unit(String n, double l) {
            this.name = n;
            this.conversionFactor = l;
        }

        public Unit(String n, double l, Authority a) {
            this.name = n;
            this.conversionFactor = l;
            this.authority = a;
        }

        public String toWKT() {
            String txt = "UNIT[\"" + this.name + "\"," + this.conversionFactor;
            if (this.authority != null) {
                txt = txt + "," + this.authority.toWKT();
            }
            return txt + "]";
        }
    }

    static class PrimeM {
        String name;
        double longitude;
        Authority authority = null;

        public PrimeM(String n, double l) {
            this.name = n;
            this.longitude = l;
        }

        public PrimeM(String n, double l, Authority a) {
            this.name = n;
            this.longitude = l;
            this.authority = a;
        }

        public String toWKT() {
            String txt = "PRIMEM[\"" + this.name + "\"," + this.longitude;
            if (this.authority != null) {
                txt = txt + "," + this.authority.toWKT();
            }
            return txt + "]";
        }
    }

    static class Datum {
        String name;
        Spheroid spheroid;
        ToWGS84 towgs84 = new ToWGS84();
        Authority authority;

        public Datum(String n, Spheroid s) {
            this.init(n, s, new ToWGS84(), null);
        }

        public Datum(String n, Spheroid s, ToWGS84 t) {
            this.init(n, s, t, null);
        }

        public Datum(String n, Spheroid s, Authority a) {
            this.init(n, s, new ToWGS84(), a);
        }

        public Datum(String n, Spheroid s, ToWGS84 t, Authority a) {
            this.init(n, s, t, a);
        }

        private void init(String n, Spheroid s, ToWGS84 t, Authority a) {
            this.name = n;
            this.spheroid = s;
            this.towgs84 = t;
            this.authority = a;
        }

        public String toWKT() {
            String txt = "DATUM[\"" + this.name + "\"," + this.spheroid.toWKT();
            if (this.towgs84 != null) {
                txt = txt + "," + this.towgs84.toWKT();
            }
            if (this.authority != null) {
                txt = txt + "," + this.authority.toWKT();
            }
            return txt + "]";
        }
    }

    static class ToWGS84 {
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        double ex = 0.0;
        double ey = 0.0;
        double ez = 0.0;
        double ppm = 0.0;

        public ToWGS84() {
        }

        public ToWGS84(double dx, double dy, double dz, double ex, double ey, double ez, double ppm) {
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.ex = ex;
            this.ey = ey;
            this.ez = ez;
            this.ppm = ppm;
        }

        public String toWKT() {
            return "TOWGS84[" + this.dx + "," + this.dy + "," + this.dz + "," + this.ex + "," + this.ey + "," + this.ez + "," + this.ppm + "]";
        }
    }

    static class Spheroid {
        String name;
        double semiMajor;
        double inverseFlattening;
        Authority authority = null;

        public Spheroid(String n, double s, double f) {
            this.name = n;
            this.semiMajor = s;
            this.inverseFlattening = f;
        }

        public Spheroid(String n, double s, double f, Authority a) {
            this.name = n;
            this.semiMajor = s;
            this.inverseFlattening = f;
            this.authority = a;
        }

        public String toWKT() {
            String txt = "SPHEROID[\"" + this.name + "\"," + this.semiMajor + "," + this.inverseFlattening;
            if (this.authority != null) {
                txt = txt + "," + this.authority.toWKT();
            }
            return txt + "]";
        }
    }

    static class Parameter {
        protected String name;
        private String value;
        protected Authority authority;

        public Parameter(String n) {
            this.name = n;
        }

        public Parameter(String n, String v) {
            this.name = n;
            this.value = v;
        }

        public Parameter(String n, Authority a) {
            this.name = n;
            this.authority = a;
        }

        public String toWKT() {
            String txt = "PARAMETER[\"" + this.name + "\"," + this.value;
            if (this.authority != null) {
                txt = txt + "," + this.authority.toWKT();
            }
            return txt + "]";
        }
    }

    static class Authority {
        String name;
        String code;

        public Authority(String n, String c) {
            this.name = n;
            this.code = c;
        }

        public String toWKT() {
            return "AUTHORITY[\"" + this.name + "\",\"" + this.code + "\"]";
        }
    }
}

