/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.extension;

import es.unex.sextante.core.IInputFactory;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.gui.additionalResults.AdditionalResults;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.IGUIFactory;
import es.unex.sextante.gui.core.IPostProcessTaskFactory;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.history.History;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.lib.sextante.SextanteGeoProcessManager;
import org.gvsig.geoprocess.lib.sextante.core.DefaultInputFactory;
import org.gvsig.geoprocess.lib.sextante.core.DefaultOutputFactory;
import org.gvsig.geoprocess.lib.sextante.core.DefaultPostProcessTaskFactory;
import org.gvsig.geoprocess.sextante.gui.core.GUIFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoprocessExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(GeoprocessExtension.class);
    private static final String GEOPROCESS_SELECTOR = "GEOPROCESS_SELECTOR";
    private static final String GEOPROCESS_MODELER = "GEOPROCESS_MODELER";
    private static final String GEOPROCESS_HISTORY = "GEOPROCESS_HISTORY";
    private static final String GEOPROCESS_COMMAND_LINE = "GEOPROCESS_COMMAND_LINE";
    private static final String GEOPROCESS_RESULTS = "GEOPROCESS_RESULTS";
    private static final String GEOPROCESS_DATAEXPLORER = "GEOPROCESS_DATAEXPLORER";
    private static final String GEOPROCESS_HELP = "GEOPROCESS_HELP";

    public void initialize() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin((Object)this);
        SextanteGUI.setSextanteInstallPath((String)plugin.getPluginDirectory().getAbsolutePath());
        SextanteGUI.setSextanteHomePath((String)plugin.getPluginHomeFolder().getAbsolutePath());
    }

    public void execute(String actionCommand) {
        IGUIFactory guiFactory = SextanteGUI.getGUIFactory();
        if (GEOPROCESS_SELECTOR.equals(actionCommand)) {
            guiFactory.showToolBoxDialog();
            return;
        }
        if (GEOPROCESS_MODELER.equals(actionCommand)) {
            guiFactory.showModelerDialog();
            return;
        }
        if (GEOPROCESS_HISTORY.equals(actionCommand)) {
            guiFactory.showHistoryDialog();
            return;
        }
        if (GEOPROCESS_COMMAND_LINE.equals(actionCommand)) {
            guiFactory.showCommandLineDialog();
            return;
        }
        if (GEOPROCESS_RESULTS.equals(actionCommand)) {
            guiFactory.showAdditionalResultsDialog(AdditionalResults.getComponents());
            return;
        }
        if (GEOPROCESS_DATAEXPLORER.equals(actionCommand)) {
            guiFactory.showDataExplorer();
            return;
        }
        if (GEOPROCESS_HELP.equals(actionCommand)) {
            guiFactory.showHelpWindow();
            return;
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        IWindow w = PluginServices.getMDIManager().getActiveWindow();
        return w instanceof AbstractViewPanel;
    }

    public void postInitialize() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        this.installHomeFolder("models");
        this.installHomeFolder("scripts");
        pluginsManager.addStartupTask("InitializeSextanteGUI", (Runnable)new InitializeSextanteGUI(), true, 400);
        SextanteGUI.addAlgorithmProvider((IAlgorithmProvider)((SextanteGeoProcessManager)GeoProcessLocator.getGeoProcessManager()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isFirstTimeUsingSextante", Boolean.FALSE.toString());
        SextanteGUI.setCustomDefaultSettings(map);
    }

    private void installHomeFolder(String string) {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin((Object)this);
        plugin.getPluginDirectory();
        File srcDir = new File(plugin.getPluginDirectory(), string);
        File destDir = new File(plugin.getPluginHomeFolder(), string);
        if (destDir.exists()) {
            return;
        }
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            logger.warn("Can't install folder '" + srcDir.getAbsolutePath() + "' in '" + destDir.getAbsolutePath() + "'", (Throwable)e);
        }
    }

    class InitializeSextanteGUI
    implements Runnable {
        InitializeSextanteGUI() {
        }

        @Override
        public void run() {
            SextanteGUI.initialize();
            SextanteGUI.setMainFrame((Frame)((Frame)PluginServices.getMainFrame()));
            SextanteGUI.setOutputFactory((OutputFactory)new DefaultOutputFactory());
            SextanteGUI.setInputFactory((IInputFactory)new DefaultInputFactory());
            SextanteGUI.setPostProcessTaskFactory((IPostProcessTaskFactory)new DefaultPostProcessTaskFactory());
            SextanteGUI.setGUIFactory((IGUIFactory)new GUIFactory());
            History.startSession();
        }
    }
}

