/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi;

import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.SupportTransactions;
import org.gvsig.fmap.dal.exception.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTransaction {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LocalTransaction.class);
    boolean local;
    DataTransaction trans;
    DataManager dataManager;

    public LocalTransaction(DataManager dataManager, DataTransaction ... transaction) {
        this.dataManager = dataManager;
        if (this.dataManager == null) {
            this.dataManager = DALLocator.getDataManager();
        }
        if (transaction == null) {
            this.trans = null;
        } else if (ArrayUtils.isEmpty((Object[])transaction)) {
            this.trans = null;
        } else {
            DataTransaction t = null;
            for (DataTransaction current : transaction) {
                if (current == null) continue;
                if (t == null) {
                    t = current;
                    continue;
                }
                if (current == t) continue;
                throw new IllegalArgumentException("Transactions conflict.");
            }
            this.trans = t;
        }
        this.local = false;
    }

    public void add(DataStore store) throws DataException {
        if (this.trans == null) {
            this.trans = this.dataManager.createTransaction();
            this.local = true;
        }
        this.trans.add(store, false);
    }

    public void add(DataServerExplorer explorer) throws DataException {
        if (this.trans == null) {
            this.trans = this.dataManager.createTransaction();
            this.local = true;
        }
        this.trans.add(explorer, false);
    }

    public void add(Object obj) throws DataException {
        if (obj == null) {
            return;
        }
        if (obj instanceof DataStore) {
            this.add((DataStore)obj);
            return;
        }
        if (obj instanceof DataServerExplorer) {
            this.add((DataServerExplorer)obj);
            return;
        }
        if (obj instanceof SupportTransactions) {
            this.add((SupportTransactions)obj);
            return;
        }
        throw new IllegalArgumentException("Can't add " + obj.getClass().getName());
    }

    private void add(SupportTransactions obj) throws DataException {
        if (this.trans == null) {
            this.trans = this.dataManager.createTransaction();
            this.local = true;
        }
        this.trans.add(obj, false);
    }

    public void begin() throws DataException {
        if (this.trans == null) {
            this.trans = this.dataManager.createTransaction();
            this.local = true;
        }
        if (!this.trans.isInProgress()) {
            this.trans.begin();
        }
    }

    public void commit() throws DataException {
        if (this.local) {
            this.trans.commit();
        }
    }

    public void close() throws Exception {
        if (this.local) {
            this.trans.close();
        }
    }

    public void closeQuietly() {
        if (this.local) {
            try {
                this.trans.close();
            }
            catch (Exception ex) {
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    public void abortQuietly() {
        if (this.local) {
            try {
                this.trans.rollback();
                this.trans.close();
            }
            catch (Exception ex) {
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setKeepEditingMode(DataStore store, boolean keep) {
        this.trans.setKeepEditingMode(store, keep);
    }
}

