/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.raster.spi;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.raster.BandAttributeDescriptor;
import org.gvsig.fmap.dal.raster.BandDescriptor;
import org.gvsig.fmap.dal.raster.BandQuery;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.spi.BandDescriptorServices;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProvider;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProviderServices;
import org.gvsig.fmap.dal.resource.spi.ResourceManagerProviderServices;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.AbstractDataStoreProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.TileStruct;
import org.gvsig.timesupport.Interval;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObject_v2;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRasterStoreProvider
extends AbstractDataStoreProvider
implements RasterStoreProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractRasterStoreProvider.class);
    private RasterStoreProviderServices store;
    private DelegatedDynObject metadata;
    private DataStoreParameters parameters;
    private ArrayList<BandDescriptor> bandDescriptors;
    protected BufferDimensions dimensions;

    protected AbstractRasterStoreProvider(DataStoreParameters params, DataStoreProviderServices storeServices, DynObject metadata) {
        this.store = (RasterStoreProviderServices)storeServices;
        this.metadata = (DelegatedDynObject)metadata;
        this.parameters = params;
    }

    @Override
    public DataStoreParameters getParameters() {
        return this.parameters;
    }

    protected ResourceProvider createResource(String type, Object[] params) throws InitializeException {
        ResourceManagerProviderServices manager = (ResourceManagerProviderServices)DALLocator.getResourceManager();
        ResourceProvider resource = manager.createAddResource(type, params);
        return resource;
    }

    public Iterator<?> getChilds() {
        return null;
    }

    public RasterStoreProviderServices getStoreServices() {
        return this.store;
    }

    @Override
    public void close() throws CloseException {
    }

    @Override
    public void refresh() throws OpenException {
    }

    @Override
    public Interval getInterval() {
        return null;
    }

    @Override
    public Collection<?> getTimes() {
        return null;
    }

    @Override
    public Collection<?> getTimes(Interval interval) {
        return null;
    }

    public void delegate(DynObject dynObject) {
        if (this.metadata == null) {
            return;
        }
        this.metadata.delegate(dynObject);
    }

    public DynClass getDynClass() {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getDynClass();
    }

    public void implement(DynClass dynClass) {
        if (this.metadata == null) {
            return;
        }
        this.metadata.implement(dynClass);
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getDynValue(name);
    }

    public void setDynValue(String name, Object value) throws DynFieldNotFoundException {
        if (this.metadata == null) {
            return;
        }
        this.metadata.setDynValue(name, value);
    }

    public boolean hasDynValue(String name) {
        if (this.metadata == null) {
            return false;
        }
        return this.metadata.hasDynValue(name);
    }

    public Object invokeDynMethod(int code, Object[] args) throws DynMethodException {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.invokeDynMethod((Object)this, code, args);
    }

    public Object invokeDynMethod(String name, Object[] args) throws DynMethodException {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.invokeDynMethod((Object)this, name, args);
    }

    public void clear() {
        if (this.metadata != null) {
            this.metadata.clear();
        }
    }

    protected void doDispose() throws BaseException {
        LOG.debug("Dispose AbstractRasterStoreProvider '" + this.getFullName() + "'");
        this.metadata = null;
        this.parameters = null;
        if (this.bandDescriptors != null) {
            Iterator<BandDescriptor> iterator = this.bandDescriptors.iterator();
            while (iterator.hasNext()) {
                BandDescriptor bandDescriptor = iterator.next();
                DisposeUtils.dispose((Disposable)bandDescriptor);
                iterator.remove();
            }
            this.bandDescriptors = null;
        }
    }

    @Override
    public TileStruct getTileStruct() {
        throw new UnsupportedOperationException();
    }

    protected void autoOpen() {
        try {
            this.open();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Image getImageLegend() {
        return null;
    }

    public List<BandDescriptor> getBandsDescriptor() {
        if (this.bandDescriptors == null) {
            this.bandDescriptors = new ArrayList();
        }
        if (this.bandDescriptors.isEmpty()) {
            for (int i = 0; i < this.getBands(); ++i) {
                this.bandDescriptors.add(this.getStoreServices().createBandDescriptor(i, new ArrayList<BandAttributeDescriptor>()));
            }
        }
        return this.bandDescriptors;
    }

    @Override
    public BandDescriptorServices getBandDescriptor(int band) {
        if (band > this.getBands()) {
            throw new IllegalArgumentException("Invalid band");
        }
        return (BandDescriptorServices)this.getBandsDescriptor().get(band);
    }

    public NoData getNoData(RasterQuery rasterQuery, int band) {
        List bands = rasterQuery.getBands();
        for (BandQuery bandQuery : bands) {
            if (bandQuery.getDescriptor().getBand() != band) continue;
            NoData noData = bandQuery.getDescriptor().getNoData();
            if (noData == null) break;
            return noData;
        }
        return this.getBandDescriptor(band).getNoData();
    }

    public NoData[] getNoDatas() {
        NoData[] noDatas = new NoData[this.getBands()];
        for (int i = 0; i < this.getBands(); ++i) {
            noDatas[i] = this.getBandDescriptor(i).getNoData();
        }
        return noDatas;
    }

    public int[] getDataTypes() {
        int[] dataTypes = new int[this.getBands()];
        for (int i = 0; i < this.getBands(); ++i) {
            dataTypes[i] = this.getBandDescriptor(i).getDataType();
        }
        return dataTypes;
    }

    @Override
    public boolean isTiled() {
        return false;
    }

    public boolean hasDynMethod(String name) {
        if (this.metadata instanceof DynObject_v2) {
            return ((DynObject_v2)this.metadata).hasDynMethod(name);
        }
        return false;
    }
}

