/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.AbstractDataResource;
import org.gvsig.tools.resourcesstorage.AbstractResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipResourcesStorage
extends AbstractResourcesStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipResourcesStorage.class);
    private final File zipFile;
    private final String tableName;

    public ZipResourcesStorage(String pathName, String tableName) {
        this.zipFile = new File(pathName + ".gvres");
        this.tableName = tableName;
    }

    public static boolean existsStorage(String pathName) {
        File theZipFile = new File(pathName + ".gvres");
        return theZipFile.exists();
    }

    public ResourcesStorage.Resource getResource(String resourceName) {
        ZipFileResource res = new ZipFileResource(this.zipFile, this.tableName, resourceName);
        return res;
    }

    public boolean isEmpty() {
        return !this.zipFile.exists();
    }

    public class ZipFileResource
    extends AbstractDataResource
    implements ResourcesStorage.Resource {
        private final File zipFile;
        private final String tableName;
        private final String resourceName;
        private ZipFile zip;
        private InputStream in;
        private ByteArrayOutputStream out;

        public ZipFileResource(File zipFile, String tableName, String resourceName) {
            this.zipFile = zipFile;
            this.tableName = tableName;
            this.resourceName = resourceName;
            this.zip = null;
            this.in = null;
            this.out = null;
            if (StringUtils.isBlank((CharSequence)this.tableName)) {
                LOGGER.warn("The table name is empty (URL=" + this.getURL() + ").");
            }
            if (StringUtils.isBlank((CharSequence)this.resourceName)) {
                LOGGER.warn("The resource name is empty (URL=" + this.getURL() + ").");
            }
        }

        public String getName() {
            return this.resourceName;
        }

        public boolean isReadOnly() {
            return false;
        }

        public final URL getURL() {
            try {
                return new URL("jar:" + this.zipFile.toURI().toString() + "!/" + this.tableName + "." + this.resourceName);
            }
            catch (Exception ex) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean exists() {
            try {
                if (!this.zipFile.exists()) {
                    return false;
                }
                ZipFile z = new ZipFile(this.zipFile);
                try {
                    ZipEntry entry = z.getEntry(this.tableName + "." + this.resourceName);
                    if (entry == null) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)z);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Can't access to the resource (" + Objects.toString(this.getURL()) + ").", (Throwable)ex);
                return false;
            }
        }

        public InputStream asInputStream() throws IOException {
            if (!this.zipFile.exists()) {
                return null;
            }
            if (this.in != null || this.out != null) {
                throw new IllegalStateException("Resource is already open (" + this.zipFile.toString() + "!" + this.tableName + ")");
            }
            try {
                ZipEntry entry;
                if (this.zip == null) {
                    this.zip = new ZipFile(this.zipFile);
                }
                if ((entry = this.zip.getEntry(this.tableName + "." + this.resourceName)) == null) {
                    return null;
                }
                this.in = this.zip.getInputStream(entry);
                return new ResourceInputStream();
            }
            catch (Exception ex) {
                LOGGER.warn("Can't create input stream (" + Objects.toString(this.getURL()) + ").", (Throwable)ex);
                return null;
            }
        }

        public OutputStream asOutputStream() throws IOException {
            if (this.in != null || this.out != null) {
                throw new IllegalStateException("Resource is already open (" + Objects.toString(this.getURL()) + ").");
            }
            this.out = new ByteArrayOutputStream();
            return new ResourceOutputStream();
        }

        public void close() {
            if (this.in != null) {
                IOUtils.closeQuietly((InputStream)this.in);
                this.in = null;
            }
            if (this.out != null) {
                ByteArrayInputStream contents = new ByteArrayInputStream(this.out.toByteArray());
                try {
                    this.updateZipEntry(this.zipFile, this.tableName + "." + this.resourceName, contents);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't write resource (" + Objects.toString(this.getURL()) + ").", (Throwable)ex);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)contents);
                    IOUtils.closeQuietly((OutputStream)this.out);
                    this.out = null;
                }
            }
            if (this.zip != null) {
                IOUtils.closeQuietly((Closeable)this.zip);
                this.zip = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateZipEntry(File zip, String entryName, InputStream entryContents) throws URISyntaxException, IOException {
            FileSystem zipfs = null;
            try {
                URI zipfsuri = new URI("jar:" + zip.toURI().toString());
                zipfs = FileSystems.newFileSystem(zipfsuri, Collections.singletonMap("create", "true"));
                Path entryPath = zipfs.getPath(entryName, new String[0]);
                Files.copy(entryContents, entryPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipfs);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)zipfs);
        }

        private class ResourceOutputStream
        extends OutputStream {
            private ResourceOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                ZipFileResource.this.out.write(b);
            }

            @Override
            public void flush() throws IOException {
                ZipFileResource.this.out.flush();
            }

            @Override
            public void close() throws IOException {
                ZipFileResource.this.close();
            }
        }

        private class ResourceInputStream
        extends InputStream {
            private ResourceInputStream() {
            }

            @Override
            public int read() throws IOException {
                return ZipFileResource.this.in.read();
            }

            @Override
            public void close() throws IOException {
                ZipFileResource.this.close();
            }
        }
    }
}

