/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.selectiontools.app.extension.tools.buffer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.gui.beans.incrementabletask.IIncrementable;
import org.gvsig.gui.beans.incrementabletask.IncrementableListener;
import org.gvsig.gui.beans.incrementabletask.IncrementableTask;
import org.gvsig.gui.beans.progresspanel.ProgressPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.selectiontools.app.extension.tools.buffer.process.BufferSelectionProcess;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.utils.swing.JComboBox;

public class BufferConfigurationPanel
extends JPanel
implements IWindow {
    private WindowInfo viewInfo = null;
    private JTextField distanceText = null;
    private JComboBox distanceUnitsCombo = null;
    private JComboBox polygonSidesCombo = null;
    private JComboBox lineSidesCombo = null;
    private JComboBox pointSidesCombo = null;
    private JComboBox multiPointSidesCombo = null;
    private JLabel distanceUnitsLabel = null;
    private JLabel polygonSideLabel = null;
    private JLabel lineSideLabel = null;
    private JLabel pointSideLabel = null;
    private JLabel multiPointSideLabel = null;
    private JPanel polygonSidePanel = null;
    private JPanel lineSidePanel = null;
    private JPanel pointSidePanel = null;
    private JPanel multiPointSidePanel = null;
    private JLabel widthLabel = null;
    private JPanel widthPanel = null;
    private JPanel sidePanel = null;
    private JPanel optionsPanel = null;
    private AdaptedAcceptCancelPanel acceptCancelPanel = null;
    private List<FLyrVect> layers;
    private MapControl mapControl;
    private IView view;
    private JCheckBox multiLayerSelectionCBox;
    private SideInfo outside;
    private SideInfo inside;
    private SideInfo out_in_side;

    public BufferConfigurationPanel(List<FLyrVect> layers, IView view) {
        this.layers = layers;
        this.view = view;
        this.mapControl = view.getMapControl();
        this.initialize();
    }

    public BufferConfigurationPanel(FLyrVect[] array, IView view) {
        this(Arrays.asList(array), view);
    }

    private void initialize() {
        this.outside = new SideInfo(1, PluginServices.getText(null, (String)"Outside"));
        this.inside = new SideInfo(0, PluginServices.getText(null, (String)"Inside"));
        this.out_in_side = new SideInfo(2, PluginServices.getText(null, (String)"Both"));
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        Dimension dim = ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)18, (int)40, (int)23, (int)60);
        this.setSize(dim);
        GridBagLayout gbl = new GridBagLayout();
        JPanel centerPanel = new JPanel(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        centerPanel.add((Component)this.getWidthPanel(), c);
        c.gridy = 1;
        centerPanel.add((Component)this.getSidePanel(), c);
        c.gridy = 2;
        centerPanel.add((Component)this.getOptionsPanel(), c);
        this.add((Component)centerPanel, "Center");
        this.add((Component)((Object)this.getAdaptedAcceptCancelPanel()), "South");
    }

    private JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel(new GridBagLayout());
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this.optionsPanel, (String)"Options")));
            GridBagConstraints cons = new GridBagConstraints();
            cons.fill = 1;
            cons.insets = new Insets(0, 5, 0, 5);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.weightx = 1.0;
            this.optionsPanel.add((Component)this.getMultiLayerSelectionCBox(), cons);
        }
        return this.optionsPanel;
    }

    private JCheckBox getMultiLayerSelectionCBox() {
        if (this.multiLayerSelectionCBox == null) {
            this.multiLayerSelectionCBox = new JCheckBox();
            this.multiLayerSelectionCBox.setText(PluginServices.getText((Object)this.multiLayerSelectionCBox, (String)"MultiLayer_selection"));
            this.multiLayerSelectionCBox.setSelected(true);
            this.multiLayerSelectionCBox.setToolTipText(PluginServices.getText(null, (String)"multiLayerSelection_checkbox_TOOLTIP_HTML_explanation"));
        }
        return this.multiLayerSelectionCBox;
    }

    private JPanel getWidthPanel() {
        if (this.widthPanel == null) {
            this.widthPanel = new JPanel();
            this.widthPanel.setBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this.widthPanel, (String)"width")));
            this.widthPanel.setLayout(new GridBagLayout());
            GridBagConstraints cons = new GridBagConstraints();
            cons.fill = 1;
            cons.insets = new Insets(0, 5, 0, 5);
            cons.gridx = 0;
            cons.gridy = 0;
            this.widthPanel.add((Component)this.getWidthLabel(), cons);
            cons.gridx = 1;
            cons.gridwidth = 2;
            this.widthPanel.add((Component)this.getWidthText(), cons);
            cons.gridx = 3;
            cons.gridwidth = 1;
            this.widthPanel.add((Component)this.getDistanceUnitsLabel(), cons);
            cons.gridx = 4;
            cons.gridwidth = 2;
            this.widthPanel.add((Component)this.getDistanceUnitsCombo(), cons);
        }
        return this.widthPanel;
    }

    private JLabel getWidthLabel() {
        if (this.widthLabel == null) {
            this.widthLabel = new JLabel();
            this.widthLabel.setText(PluginServices.getText((Object)this.widthLabel, (String)"Width"));
            this.widthLabel.setToolTipText(PluginServices.getText(null, (String)"bufferWidth_TOOLTIP_HTML_explanation"));
        }
        return this.widthLabel;
    }

    private JTextField getWidthText() {
        if (this.distanceText == null) {
            this.distanceText = new JTextField();
            this.distanceText.setPreferredSize(new Dimension(65, 22));
            this.distanceText.setText("100");
        }
        return this.distanceText;
    }

    private JLabel getDistanceUnitsLabel() {
        if (this.distanceUnitsLabel == null) {
            this.distanceUnitsLabel = new JLabel(PluginServices.getText((Object)this.distanceUnitsLabel, (String)"Units").concat(":"));
            this.distanceUnitsLabel.setAlignmentX(1.0f);
            this.distanceUnitsLabel.setToolTipText(PluginServices.getText(null, (String)"distanceUnitsLabel_TOOLTIP_HTML_explanation"));
        }
        return this.distanceUnitsLabel;
    }

    private JComboBox getDistanceUnitsCombo() {
        if (this.distanceUnitsCombo == null) {
            this.distanceUnitsCombo = new JComboBox();
            this.distanceUnitsCombo.setPreferredSize(new Dimension(65, 22));
            this.distanceUnitsCombo.addItem((Object)"km");
            this.distanceUnitsCombo.addItem((Object)"m");
            this.distanceUnitsCombo.addItem((Object)"cm");
            this.distanceUnitsCombo.addItem((Object)"mm");
            this.distanceUnitsCombo.addItem((Object)"mi");
            this.distanceUnitsCombo.addItem((Object)"Ya");
            this.distanceUnitsCombo.addItem((Object)"ft");
            this.distanceUnitsCombo.addItem((Object)"in");
            this.distanceUnitsCombo.setSelectedIndex(1);
            this.distanceUnitsCombo.setToolTipText(PluginServices.getText(null, (String)"distanceUnitsLabel_TOOLTIP_HTML_explanation"));
        }
        return this.distanceUnitsCombo;
    }

    private JPanel getSidePanel() {
        if (this.sidePanel == null) {
            this.sidePanel = new JPanel();
            this.sidePanel.setLayout(new GridBagLayout());
            this.sidePanel.setBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this.sidePanel, (String)"Side")));
            this.sidePanel.setToolTipText(PluginServices.getText(null, (String)"sideLabel_TOOLTIP_HTML_explanation"));
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(0, 2, 0, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            this.sidePanel.add((Component)this.getPolygonSidePanel(), c);
            c.gridy = 1;
            this.sidePanel.add((Component)this.getLineSidePanel(), c);
            c.gridy = 2;
            this.sidePanel.add((Component)this.getPointSidePanel(), c);
            c.gridy = 3;
            this.sidePanel.add((Component)this.getMultiPointSidePanel(), c);
        }
        return this.sidePanel;
    }

    private JPanel getPolygonSidePanel() {
        if (this.polygonSidePanel == null) {
            this.polygonSidePanel = new JPanel(new GridBagLayout());
            GridBagConstraints cons = new GridBagConstraints();
            cons.fill = 1;
            cons.insets = new Insets(5, 5, 5, 5);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.weightx = 0.0;
            this.polygonSidePanel.add((Component)this.getPolygonSideLabel(), cons);
            cons.gridx = 1;
            cons.weightx = 1.0;
            this.polygonSidePanel.add((Component)this.getPolygonSidesCombo(), cons);
        }
        return this.polygonSidePanel;
    }

    private JLabel getPolygonSideLabel() {
        if (this.polygonSideLabel == null) {
            this.polygonSideLabel = new JLabel(PluginServices.getText((Object)this.polygonSideLabel, (String)"Polygon").concat(":"));
            this.polygonSideLabel.setToolTipText(PluginServices.getText(null, (String)"polygonSideLabel_TOOLTIP_HTML_explanation"));
        }
        return this.polygonSideLabel;
    }

    private JComboBox getPolygonSidesCombo() {
        if (this.polygonSidesCombo == null) {
            this.polygonSidesCombo = new JComboBox();
            this.polygonSidesCombo.addItem((Object)this.outside);
            this.polygonSidesCombo.addItem((Object)this.inside);
            this.polygonSidesCombo.setToolTipText(PluginServices.getText(null, (String)"polygonSideLabel_TOOLTIP_HTML_explanation"));
        }
        return this.polygonSidesCombo;
    }

    private JPanel getLineSidePanel() {
        if (this.lineSidePanel == null) {
            this.lineSidePanel = new JPanel(new GridBagLayout());
            GridBagConstraints cons = new GridBagConstraints();
            cons.fill = 1;
            cons.insets = new Insets(5, 5, 5, 5);
            cons.gridx = 0;
            cons.gridy = 1;
            cons.weightx = 0.0;
            this.polygonSidePanel.add((Component)this.getLineSideLabel(), cons);
            cons.gridx = 1;
            cons.weightx = 1.0;
            this.polygonSidePanel.add((Component)this.getLineSidesCombo(), cons);
        }
        return this.lineSidePanel;
    }

    private JLabel getLineSideLabel() {
        if (this.lineSideLabel == null) {
            this.lineSideLabel = new JLabel(PluginServices.getText((Object)this.lineSideLabel, (String)"Line").concat(":"));
            this.lineSideLabel.setToolTipText(PluginServices.getText(null, (String)"lineSideLabel_TOOLTIP_HTML_explanation"));
        }
        return this.lineSideLabel;
    }

    private JComboBox getLineSidesCombo() {
        if (this.lineSidesCombo == null) {
            this.lineSidesCombo = new JComboBox();
            this.lineSidesCombo.addItem((Object)this.outside);
            this.lineSidesCombo.setToolTipText(PluginServices.getText(null, (String)"lineSideLabel_TOOLTIP_HTML_explanation"));
        }
        return this.lineSidesCombo;
    }

    private JPanel getPointSidePanel() {
        if (this.pointSidePanel == null) {
            this.pointSidePanel = new JPanel(new GridBagLayout());
            GridBagConstraints cons = new GridBagConstraints();
            cons.fill = 1;
            cons.insets = new Insets(5, 5, 5, 5);
            cons.gridx = 0;
            cons.gridy = 2;
            cons.weightx = 0.0;
            this.polygonSidePanel.add((Component)this.getPointSideLabel(), cons);
            cons.gridx = 1;
            cons.weightx = 1.0;
            this.polygonSidePanel.add((Component)this.getPointSidesCombo(), cons);
        }
        return this.pointSidePanel;
    }

    private JLabel getPointSideLabel() {
        if (this.pointSideLabel == null) {
            this.pointSideLabel = new JLabel(PluginServices.getText((Object)this.pointSideLabel, (String)"Point").concat(":"));
            this.pointSideLabel.setToolTipText(PluginServices.getText(null, (String)"pointSideLabel_TOOLTIP_HTML_explanation"));
        }
        return this.pointSideLabel;
    }

    private JComboBox getPointSidesCombo() {
        if (this.pointSidesCombo == null) {
            this.pointSidesCombo = new JComboBox();
            this.pointSidesCombo.addItem((Object)this.outside);
            this.pointSidesCombo.setToolTipText(PluginServices.getText(null, (String)"pointSideLabel_TOOLTIP_HTML_explanation"));
        }
        return this.pointSidesCombo;
    }

    private JPanel getMultiPointSidePanel() {
        if (this.multiPointSidePanel == null) {
            this.multiPointSidePanel = new JPanel(new FlowLayout());
            GridBagConstraints cons = new GridBagConstraints();
            cons.fill = 1;
            cons.insets = new Insets(5, 5, 5, 5);
            cons.gridx = 0;
            cons.gridy = 3;
            cons.weightx = 0.0;
            this.polygonSidePanel.add((Component)this.getMultiPointSideLabel(), cons);
            cons.gridx = 1;
            cons.weightx = 1.0;
            this.polygonSidePanel.add((Component)this.getMultiPointSidesCombo(), cons);
        }
        return this.multiPointSidePanel;
    }

    private JLabel getMultiPointSideLabel() {
        if (this.multiPointSideLabel == null) {
            this.multiPointSideLabel = new JLabel(PluginServices.getText((Object)this.multiPointSideLabel, (String)"MultiPoint") + ":");
            this.multiPointSideLabel.setToolTipText(PluginServices.getText(null, (String)"multiPointSideLabel_TOOLTIP_HTML_explanation"));
        }
        return this.multiPointSideLabel;
    }

    private JComboBox getMultiPointSidesCombo() {
        if (this.multiPointSidesCombo == null) {
            this.multiPointSidesCombo = new JComboBox();
            this.multiPointSidesCombo.addItem((Object)this.outside);
            this.multiPointSidesCombo.setToolTipText(PluginServices.getText(null, (String)"multiPointSideLabel_TOOLTIP_HTML_explanation"));
        }
        return this.multiPointSidesCombo;
    }

    private AdaptedAcceptCancelPanel getAdaptedAcceptCancelPanel() {
        if (this.acceptCancelPanel == null) {
            this.acceptCancelPanel = new AdaptedAcceptCancelPanel();
        }
        return this.acceptCancelPanel;
    }

    public WindowInfo getWindowInfo() {
        if (this.viewInfo == null) {
            this.viewInfo = new WindowInfo(9);
            this.viewInfo.setTitle(Messages.getText((String)"Select_by_buffer"));
            this.viewInfo.setWidth(this.getWidth());
            this.viewInfo.setHeight(this.getHeight());
        }
        return this.viewInfo;
    }

    private void closeThis() {
        PluginServices.getMDIManager().closeWindow((IWindow)this);
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    private class SideInfo {
        private byte side;
        private String name;

        public SideInfo(byte side, String name) {
            this.side = side;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public byte getSide() {
            return this.side;
        }
    }

    private class AdaptedAcceptCancelPanel
    extends AcceptCancelPanel {
        public AdaptedAcceptCancelPanel() {
            this.addOkButtonActionListener(this.getOKAction());
            this.addCancelButtonActionListener(this.getCancelAction());
        }

        private ActionListener getOKAction() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double width;
                    try {
                        width = Double.parseDouble(BufferConfigurationPanel.this.getWidthText().getText());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_Invalid_width_value") + " : \"" + BufferConfigurationPanel.this.getWidthText().getText() + "\"", Messages.getText((String)"Select_by_buffer"), 2);
                        return;
                    }
                    BufferConfigurationPanel.this.closeThis();
                    ArrayList tmpLayersToProccess = new ArrayList();
                    tmpLayersToProccess.addAll(BufferConfigurationPanel.this.layers);
                    if (!BufferConfigurationPanel.this.multiLayerSelectionCBox.isSelected()) {
                        Iterator iter = tmpLayersToProccess.iterator();
                        while (iter.hasNext()) {
                            FLyrVect curLayer = (FLyrVect)iter.next();
                            try {
                                if (!curLayer.getFeatureStore().getFeatureSelection().isEmpty()) continue;
                                iter.remove();
                            }
                            catch (DataException e1) {
                                NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Failed_selecting_layer"), (Exception)((Object)e1));
                                return;
                            }
                        }
                    }
                    FLyrVect[] layersToProcess = tmpLayersToProccess.toArray(new FLyrVect[tmpLayersToProccess.size()]);
                    BufferSelectionProcess iprocess = new BufferSelectionProcess(PluginServices.getText((Object)this, (String)"Select_by_buffer"), PluginServices.getText((Object)this, (String)"Ongoing_process_please_wait"), BufferConfigurationPanel.this.mapControl, ((SideInfo)BufferConfigurationPanel.this.getPolygonSidesCombo().getSelectedItem()).getSide(), ((SideInfo)BufferConfigurationPanel.this.getLineSidesCombo().getSelectedItem()).getSide(), ((SideInfo)BufferConfigurationPanel.this.getPointSidesCombo().getSelectedItem()).getSide(), ((SideInfo)BufferConfigurationPanel.this.getMultiPointSidesCombo().getSelectedItem()).getSide(), width, (short)BufferConfigurationPanel.this.getDistanceUnitsCombo().getSelectedIndex(), layersToProcess, BufferConfigurationPanel.this.getMultiLayerSelectionCBox().isSelected());
                    IncrementableTask iTask = new IncrementableTask((IIncrementable)iprocess, new ProgressPanel(false));
                    iTask.addIncrementableListener((IncrementableListener)iprocess);
                    iprocess.setIncrementableTask(iTask);
                    iTask.getProgressPanel().addComponentListener((ComponentListener)new ComponentAdapter(){

                        @Override
                        public void componentHidden(ComponentEvent e) {
                            BufferConfigurationPanel.this.mapControl.getMapContext().invalidate();
                        }
                    });
                    iprocess.start();
                    iTask.start();
                }
            };
        }

        private ActionListener getCancelAction() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BufferConfigurationPanel.this.closeThis();
                }
            };
        }
    }
}

