/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import java.util.List;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.ControlFlow;
import org.springframework.core.ControlFlowFactory;

public abstract class AbstractAdvisorAutoProxyCreator
extends AbstractAutoProxyCreator {
    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.findCandidateAdvisors();
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String name, TargetSource targetSource) {
        List advisors = this.findEligibleAdvisors(beanClass);
        if (advisors.isEmpty()) {
            return DO_NOT_PROXY;
        }
        advisors = this.sortAdvisors(advisors);
        return advisors.toArray();
    }

    protected List findEligibleAdvisors(Class clazz) {
        return AopUtils.findAdvisorsThatCanApply(this.findCandidateAdvisors(), clazz);
    }

    protected List sortAdvisors(List advisors) {
        return AopUtils.sortAdvisorsByOrder(advisors);
    }

    protected boolean shouldSkip(Class beanClass, String name) {
        ControlFlow cflow = ControlFlowFactory.createControlFlow();
        return cflow.under(this.getClass(), "findCandidateAdvisors");
    }

    protected abstract List findCandidateAdvisors();
}

