/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import opendap.dap.BaseType;
import opendap.dap.DAP2Exception;
import opendap.dap.DGrid;
import opendap.dap.NoSuchFunctionException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.Server.DAP2ServerSideException;
import opendap.dap.Server.ServerArrayMethods;
import opendap.dap.parser.AST;
import opendap.dap.parser.ASTslice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ASTsegment
extends AST {
    String name = null;
    List<ASTslice> slices = new ArrayList<ASTslice>();

    public ASTsegment(List<AST> nodes) {
        super(nodes);
    }

    @Override
    Stack collect(Stack components) throws DAP2ServerSideException, DAP2Exception, NoSuchFunctionException, NoSuchVariableException {
        block7: {
            BaseType bt = null;
            ServerArrayMethods sam = null;
            components = this.getSdds().search(this.name, components);
            if (this.slices == null || this.slices.size() <= 0) break block7;
            try {
                bt = (BaseType)components.peek();
            }
            catch (ClassCastException cce) {
                String msg = "Attempt to treat the variable `" + this.name + "' as if it is an array.";
                throw new DAP2Exception(3, msg);
            }
            if (bt instanceof DGrid) {
                ASTslice slice;
                int i;
                DGrid grid = (DGrid)bt;
                bt = grid.getArray();
                sam = (ServerArrayMethods)((Object)bt);
                for (i = 0; i < this.slices.size(); ++i) {
                    slice = this.slices.get(i);
                    slice.walk(sam, i);
                }
                for (i = 0; i < this.slices.size(); ++i) {
                    slice = this.slices.get(i);
                    bt = grid.getVar(i + 1);
                    sam = (ServerArrayMethods)((Object)bt);
                    slice.walk(sam, 0);
                }
            } else {
                sam = (ServerArrayMethods)((Object)bt);
                for (int i = 0; i < this.slices.size(); ++i) {
                    ASTslice slice = this.slices.get(i);
                    slice.walk(sam, i);
                }
            }
        }
        return components;
    }
}

