/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MFile;

public class MetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(MetadataManager.class);
    private static final String UTF8 = "UTF-8";
    private static String root = null;
    private static Environment myEnv = null;
    private static List<MetadataManager> openDatabases = new ArrayList<MetadataManager>();
    private static boolean readOnly = false;
    private static boolean debug = false;
    private static boolean debugDelete = false;
    private String collectionName;
    private Database database;

    public static void setCacheDirectory(String dir) {
        root = dir;
    }

    private static synchronized void setup() throws DatabaseException {
        if (myEnv != null) {
            return;
        }
        EnvironmentConfig myEnvConfig = new EnvironmentConfig();
        myEnvConfig.setReadOnly(false);
        myEnvConfig.setAllowCreate(true);
        myEnvConfig.setSharedCache(true);
        File dir = new File(root);
        if (!dir.exists() && !dir.mkdirs()) {
            logger.warn("MetadataManager failed to make directory " + root);
        }
        try {
            myEnv = new Environment(dir, myEnvConfig);
            logger.info("MetadataManager opened bdb in directory=" + dir);
            readOnly = false;
        }
        catch (EnvironmentLockedException e) {
            logger.warn("MetadataManager failed to open directory, try read-only");
            readOnly = true;
            myEnvConfig.setReadOnly(true);
            myEnvConfig.setAllowCreate(false);
            myEnv = new Environment(dir, myEnvConfig);
        }
        logger.info("MetadataManager: open bdb at root " + root + " readOnly = " + readOnly);
    }

    public static synchronized void closeAll() {
        ArrayList<MetadataManager> closeDatabases = new ArrayList<MetadataManager>(openDatabases);
        for (MetadataManager mm : closeDatabases) {
            if (debug) {
                System.out.println("  close database " + mm.collectionName);
            }
            mm.close();
        }
        openDatabases = new ArrayList<MetadataManager>();
        if (myEnv != null) {
            try {
                myEnv.close();
                myEnv = null;
                logger.info("closed bdb caching");
            }
            catch (DatabaseException dbe) {
                logger.error("Error closing bdb: ", dbe);
            }
        }
    }

    public static void showEnvStats(Formatter f) {
        if (myEnv == null) {
            MetadataManager.setup();
        }
        try {
            EnvironmentStats stats = myEnv.getStats(null);
            f.format("EnvironmentStats%n%s%n", stats);
            f.format("%nDatabaseNames%n", new Object[0]);
            for (String dbName : myEnv.getDatabaseNames()) {
                f.format(" %s%n", dbName);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public static String getCacheLocation() {
        return root;
    }

    public static void sync() {
        if (myEnv != null) {
            myEnv.sync();
        }
    }

    public static List<String> getCollectionNames() {
        if (myEnv == null) {
            MetadataManager.setup();
        }
        return myEnv.getDatabaseNames();
    }

    public static void deleteCollection(String collectionName) throws Exception {
        for (MetadataManager mm : openDatabases) {
            if (!mm.collectionName.equals(collectionName) || mm.database == null) continue;
            mm.database.close();
        }
        myEnv.removeDatabase(null, collectionName);
    }

    public static void delete(String collectionName, String key) {
        try {
            MetadataManager mm = new MetadataManager(collectionName);
            mm.delete(key);
            mm.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MetadataManager(String collectionName) throws DatabaseException, IOException {
        this.collectionName = collectionName;
        if (myEnv == null) {
            MetadataManager.setup();
        }
    }

    private void openDatabase() {
        if (this.database != null) {
            return;
        }
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReadOnly(readOnly);
        dbConfig.setAllowCreate(!readOnly);
        if (!readOnly) {
            dbConfig.setDeferredWrite(true);
        }
        this.database = myEnv.openDatabase(null, this.collectionName, dbConfig);
        openDatabases.add(this);
    }

    public void put(String key, String value) {
        if (readOnly) {
            return;
        }
        this.openDatabase();
        try {
            this.database.put(null, new DatabaseEntry(key.getBytes(UTF8)), new DatabaseEntry(value.getBytes(UTF8)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void put(byte[] key, byte[] value) {
        if (readOnly) {
            return;
        }
        this.openDatabase();
        this.database.put(null, new DatabaseEntry(key), new DatabaseEntry(value));
    }

    public void put(String key, byte[] value) {
        if (readOnly) {
            return;
        }
        this.openDatabase();
        try {
            this.database.put(null, new DatabaseEntry(key.getBytes(UTF8)), new DatabaseEntry(value));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public byte[] get(byte[] key) {
        this.openDatabase();
        DatabaseEntry value = new DatabaseEntry();
        this.database.get(null, new DatabaseEntry(key), value, LockMode.DEFAULT);
        return value.getData();
    }

    public byte[] getBytes(String key) {
        this.openDatabase();
        try {
            DatabaseEntry value = new DatabaseEntry();
            this.database.get(null, new DatabaseEntry(key.getBytes(UTF8)), value, LockMode.DEFAULT);
            return value.getData();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String get(String key) {
        this.openDatabase();
        try {
            DatabaseEntry value = new DatabaseEntry();
            OperationStatus status = this.database.get(null, new DatabaseEntry(key.getBytes(UTF8)), value, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return new String(value.getData(), UTF8);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(String theKey) {
        if (readOnly) {
            logger.warn("Cant dekete - readOnly mode");
            return;
        }
        this.openDatabase();
        try {
            DatabaseEntry entry = new DatabaseEntry(theKey.getBytes(UTF8));
            this.database.delete(null, entry);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Map<String, MFile> current) {
        if (readOnly) {
            logger.warn("Cant dekete - readOnly mode");
            return;
        }
        this.openDatabase();
        ArrayList<DatabaseEntry> result = new ArrayList<DatabaseEntry>();
        Cursor myCursor = null;
        try {
            myCursor = this.database.openCursor(null, null);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            int count = 0;
            while (myCursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                String filename;
                String key = new String(foundKey.getData(), UTF8);
                int pos = key.indexOf(35);
                if (pos <= 0 || null != current.get(filename = key.substring(0, pos))) continue;
                result.add(new DatabaseEntry(foundKey.getData()));
                ++count;
            }
            if (debugDelete) {
                for (DatabaseEntry entry : result) {
                    OperationStatus status = this.database.delete(null, entry);
                    String key = new String(entry.getData(), UTF8);
                    System.out.printf("%s deleted %s%n", status, key);
                }
            }
        }
        catch (UnsupportedOperationException e) {
            logger.error("Trying to delete " + this.collectionName, e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Trying to delete " + this.collectionName, e);
        }
        finally {
            if (null != myCursor) {
                myCursor.close();
            }
        }
    }

    public void close() {
        if (this.database != null) {
            this.database.close();
            openDatabases.remove(this);
            this.database = null;
        }
    }

    public void showStats(Formatter f) {
        this.openDatabase();
        try {
            DatabaseStats dstats = this.database.getStats(null);
            f.format("primary stats %n%s%n", dstats);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValue> getContent() throws DatabaseException, UnsupportedEncodingException {
        this.openDatabase();
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        Cursor myCursor = null;
        try {
            myCursor = this.database.openCursor(null, null);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            while (myCursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                String key = new String(foundKey.getData(), UTF8);
                String data = new String(foundData.getData(), UTF8);
                result.add(new KeyValue(key, data));
            }
        }
        finally {
            if (null != myCursor) {
                myCursor.close();
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        MetadataManager indexer = new MetadataManager("dummy");
        indexer.showStats(new Formatter(System.out));
        MetadataManager.closeAll();
    }

    static {
        String home = System.getProperty("user.home");
        if (home == null) {
            home = System.getProperty("user.dir");
        }
        if (home == null) {
            home = ".";
        }
        root = home + "/.unidata/bdb/";
    }

    public class KeyValue {
        public String key;
        public String value;

        KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

