/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribNumbers;
import ucar.grib.grib2.Grib2BitMapSection;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2DataSection;
import ucar.grib.grib2.Grib2EndSection;
import ucar.grib.grib2.Grib2GDSVariables;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2IndicatorSection;
import ucar.grib.grib2.Grib2LocalUseSection;
import ucar.grib.grib2.Grib2Product;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.Grib2Record;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2Input {
    private static Logger logger = LoggerFactory.getLogger(Grib2Input.class);
    private final RandomAccessFile raf;
    private String header = "GRIB2";
    private long startPos = -1L;
    private static final Pattern productID = Pattern.compile("(\\w{6} \\w{4} \\d{6})");
    private static final KMPMatch matcher = new KMPMatch("GRIB".getBytes());
    private final List<Grib2Record> records = new ArrayList<Grib2Record>();
    private final List<Grib2Product> products = new ArrayList<Grib2Product>();
    private final Map<String, Grib2GridDefinitionSection> gdsHM = new HashMap<String, Grib2GridDefinitionSection>();

    public static boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        if (!raf.searchForward(matcher, 8000)) {
            return false;
        }
        raf.skipBytes(4);
        Grib2IndicatorSection is = new Grib2IndicatorSection(raf);
        if (is.getGribEdition() != 1 && is.getGribEdition() != 2) {
            return false;
        }
        return is.getGribLength() <= raf.length();
    }

    public Grib2Input(RandomAccessFile raf) {
        this.raf = raf;
    }

    public final boolean scan(boolean getProductsOnly, boolean oneRecord) throws IOException {
        Grib2IndicatorSection is = null;
        Grib2IdentificationSection id = null;
        Grib2LocalUseSection lus = null;
        Grib2GridDefinitionSection gds = null;
        if (this.raf.getFilePointer() > 4L) {
            this.raf.seek(this.raf.getFilePointer() - 4L);
            Grib2EndSection es = new Grib2EndSection(this.raf);
            if (!es.getEndFound()) {
                return false;
            }
        }
        boolean startAtHeader = true;
        boolean processGDS = true;
        long gdsOffset = 0L;
        long pdsOffset = 0L;
        Grib2ProductDefinitionSection pds = null;
        Grib2DataRepresentationSection drs = null;
        Grib2BitMapSection bms = null;
        Grib2DataSection ds = null;
        while (this.raf.getFilePointer() < this.raf.length()) {
            if (startAtHeader) {
                if (!this.seekHeader(this.raf, this.raf.length())) {
                    return false;
                }
                is = new Grib2IndicatorSection(this.raf);
                long endPos = this.raf.getFilePointer() + is.getGribLength() - (long)is.getLength();
                is.setPos(this.startPos, endPos);
                if (is.getGribEdition() == 1) {
                    logger.warn("Grib1 record in Grib2 file at=" + this.raf.getLocation());
                    this.raf.seek(endPos);
                    continue;
                }
                if (is.getDiscipline() == 255) {
                    logger.warn("Missing Discipline in header at= " + this.raf.getLocation());
                    this.raf.seek(endPos);
                    continue;
                }
                id = new Grib2IdentificationSection(this.raf);
            }
            try {
                if (processGDS) {
                    lus = new Grib2LocalUseSection(this.raf);
                    gdsOffset = this.raf.getFilePointer();
                    gds = new Grib2GridDefinitionSection(this.raf, getProductsOnly);
                }
                pdsOffset = this.raf.getFilePointer();
                long refTime = id == null ? 0L : id.getRefTime();
                pds = new Grib2ProductDefinitionSection(this.raf, refTime);
                drs = new Grib2DataRepresentationSection(this.raf);
                bms = new Grib2BitMapSection(false, this.raf, gds);
                ds = new Grib2DataSection(false, this.raf, gds, drs, bms);
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
            if (getProductsOnly) {
                Grib2Product gp = new Grib2Product(this.header, is, id, this.getGDSkey(gds), pds, gdsOffset, pdsOffset);
                this.products.add(gp);
            } else {
                Grib2Record gr = new Grib2Record(this.header, is, id, lus.getLocalUseSection(), gds, pds, drs, gdsOffset, pdsOffset);
                this.records.add(gr);
            }
            if (oneRecord) {
                return true;
            }
            if (this.raf.getFilePointer() > this.raf.length()) {
                this.raf.seek(0L);
                return true;
            }
            int ending = GribNumbers.int4(this.raf);
            if (ending == 0x37373737) {
                startAtHeader = true;
                processGDS = true;
                continue;
            }
            int section = this.raf.read();
            this.raf.seek(this.raf.getFilePointer() - 5L);
            if (section == 3) {
                startAtHeader = false;
                processGDS = true;
                continue;
            }
            if (section == 4) {
                startAtHeader = false;
                processGDS = false;
                continue;
            }
            Grib2EndSection es = new Grib2EndSection(this.raf);
            if (es.getEndFound()) {
                startAtHeader = true;
                processGDS = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public final int getEdition() throws IOException {
        this.raf.seek(0L);
        if (!this.raf.searchForward(matcher, 8000)) {
            return 0;
        }
        this.raf.skipBytes(4);
        Grib2IndicatorSection is = new Grib2IndicatorSection(this.raf);
        return is.getGribEdition();
    }

    private boolean seekHeader(RandomAccessFile raf, long stop) throws IOException {
        StringBuffer hdr = new StringBuffer();
        int match = 0;
        while (raf.getFilePointer() < stop) {
            byte c = raf.readByte();
            hdr.append((char)c);
            if (c == 71) {
                match = 1;
                continue;
            }
            if (c == 82 && match == 1) {
                match = 2;
                continue;
            }
            if (c == 73 && match == 2) {
                match = 3;
                continue;
            }
            if (c == 66 && match == 3) {
                match = 4;
                Matcher m = productID.matcher(hdr.toString());
                this.header = m.find() ? m.group(1) : "GRIB2";
                this.startPos = raf.getFilePointer() - 4L;
                return true;
            }
            match = 0;
        }
        return false;
    }

    private String getGDSkey(Grib2GridDefinitionSection newgds) {
        Grib2GDSVariables newgdsv = newgds.getGdsVars();
        String newkey = Integer.toString(newgdsv.getGdsKey());
        if (this.gdsHM.size() == 0) {
            this.gdsHM.put(newkey, newgds);
            return newkey;
        }
        if (this.gdsHM.containsKey(newkey)) {
            return newkey;
        }
        float newlat1 = newgdsv.get80La1();
        float newlon1 = newgdsv.get80Lo1();
        Set<String> keys = this.gdsHM.keySet();
        for (String key : keys) {
            Grib2GridDefinitionSection gds = this.gdsHM.get(key);
            Grib2GDSVariables gdsv = gds.getGdsVars();
            float lat1 = gdsv.get80La1();
            float lon1 = gdsv.get80Lo1();
            if (!GribNumbers.closeEnough(newlat1, lat1) || !GribNumbers.closeEnough(newlon1, lon1)) continue;
            return key;
        }
        this.gdsHM.put(newkey, newgds);
        return newkey;
    }

    public final List<Grib2Product> getProducts() {
        return this.products;
    }

    public final List<Grib2Record> getRecords() {
        return this.records;
    }

    public final Map<String, Grib2GridDefinitionSection> getGDSs() {
        return this.gdsHM;
    }
}

