/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.log;

import java.sql.Timestamp;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLogData;

public class VCSGisRepositoryLogDataTableModel
extends AbstractTableModel
implements TableModel {
    private List<VCSGisRepositoryLogData> changes;
    private final String[] columnNames;
    private final Class[] columnClasses;

    public VCSGisRepositoryLogDataTableModel(List<VCSGisRepositoryLogData> changes) {
        this.changes = changes;
        this.columnNames = new String[]{"Date", "Revision", "Operation"};
        this.columnClasses = new Class[]{Timestamp.class, String.class, String.class};
    }

    public void dispose() {
        DisposeUtils.dispose(this.changes);
        this.changes = null;
    }

    @Override
    public int getRowCount() {
        if (this.changes == null) {
            return 0;
        }
        return this.changes.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.changes == null) {
            return "";
        }
        VCSGisRepositoryLogData change = this.changes.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return change.getEfectiveDate();
            }
            case 1: {
                return change.getRevisionNumber();
            }
            case 2: {
                return change.getOperationLabel();
            }
        }
        return "";
    }
}

