/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.managehistory;

import java.awt.Cursor;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.FolderPickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.VCSGisJBackupHistory;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.managehistory.BackupHistory;
import org.gvsig.vcsgis.swing.impl.managehistory.VCSGisJBackupHistoryView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJBackupHistoryImpl
extends VCSGisJBackupHistoryView
implements Component,
VCSGisJBackupHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJBackupHistoryImpl.class);
    private Dialog dialog;
    private boolean processing = false;
    private PickerController<VCSGisWorkspace> workspacePicker;
    private TaskStatusController taskStatusController;
    private VCSGisEntitySelectorController entitySelector;
    private FolderPickerController folderController;

    public VCSGisJBackupHistoryImpl() {
        this.initComponents();
    }

    private void initComponents() {
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        this.translate();
        this.btnCheckAllEntities.setCursor(Cursor.getPredefinedCursor(12));
        this.btnUnCheckAllEntities.setCursor(Cursor.getPredefinedCursor(12));
        this.entitySelector = VCSGisSwingLocator.getVCSGisSwingManager().createEntitySelectorController(this.treeTables, (JTextComponent)this.txtFilter, this.btnTable);
        this.entitySelector.setFilter(VCSGisEntitySelectorController.REMOTE_ENTITIES);
        this.entitySelector.setViewFilter(VCSGisEntitySelectorController.REMOTE_ENTITIES);
        this.entitySelector.setChecksEnabled(true);
        this.entitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 2: 
                case 3: 
                case 4: {
                    this.doUpdateComponents();
                    break;
                }
                case 1: {
                    this.doUpdateComponents();
                }
            }
        });
        this.entitySelector.addChangeListener(e -> this.doUpdateComponents());
        this.taskStatusController = taskStatusManager.createTaskStatusController(this.lblStatusTitle, this.lblStatusMessages, this.pbStatus);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind(ToolsLocator.getTaskStatusManager());
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspaces, this.btnInitWorkspace);
        this.workspacePicker.addChangeListener(e -> {
            this.doChangeWorkspace();
            this.doUpdateComponents();
        });
        this.folderController = ToolsSwingLocator.getToolsSwingManager().createFolderPickerController((JTextComponent)this.txtFolder, this.btnSelectFolder);
        this.folderController.addChangeListener(e -> this.doUpdateComponents());
        this.showMessage(" ", null);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)22, (int)60);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusTitle.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblStatusMessages.setVisible(true);
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeWorkspace() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        Cursor savedCursor = this.getCursor();
        try {
            this.processing = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            VCSGisWorkspace ws = this.getWorkspace();
            this.entitySelector.clear();
            if (this.isValidWorkspace(ws)) {
                this.entitySelector.setWorkspace(ws);
            } else {
                this.showMessage(i18n.getTranslation("_Working_copy_not_valid"), i18n.getTranslation("_The_repository_of_the_selected_working_copy_is_not_accessible_by_this_tool"));
            }
            this.doUpdateComponents();
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't set workspace.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Backup_history", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't set workspace.", (Throwable)e2);
            this.entitySelector.clear();
        }
        finally {
            this.processing = false;
            this.setCursor(savedCursor);
        }
    }

    public VCSGisWorkspace getWorkspace() {
        return (VCSGisWorkspace)this.workspacePicker.get();
    }

    private void doUpdateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        VCSGisWorkspace workspace = this.getWorkspace();
        boolean isProcessing = this.processing || this.entitySelector.isProcessing();
        boolean canBackup = !isProcessing && workspace != null && this.isValidWorkspace(workspace) && !this.getTables().isEmpty() && this.folderController.get() != null;
        this.workspacePicker.setEnabled(!isProcessing);
        this.entitySelector.setEnabled(!isProcessing);
        this.folderController.setEnabled(!isProcessing);
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, canBackup);
        }
    }

    private void showMessage(String message, String toolTipText) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.showMessage(message, toolTipText))) {
            return;
        }
        this.lblStatusMessages.setText(message);
        this.lblStatusMessages.setToolTipText(toolTipText);
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspace);
        swingManager.translate((AbstractButton)this.btnCheckAllEntities);
        swingManager.translate((AbstractButton)this.btnUnCheckAllEntities);
        swingManager.translate(this.lblTable);
        swingManager.translate(this.lblFolder);
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public static void selfRegister() {
        String[][] iconsInfo = new String[][]{{"VCSGis", "vcsgis", "vcsgis-backup-history"}};
        VCSGisSwingManagerImpl.registerIcons(iconsInfo);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int backupHistory() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        VCSGisWorkspace workspace = this.getWorkspace();
        VCSGisRepository repository = workspace.getRepository();
        if (!(repository instanceof VCSGisRepositoryLocaldb)) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog("Only local repositories allowed", "_VCS_Backup_history", 2);
            return 0;
        }
        this.setVisibleStatus(true);
        List entities = this.entitySelector.getCheckedEntities();
        boolean replaceLayerIfExists = true;
        if (workspace != null && !entities.isEmpty()) {
            SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Download changes");
            try {
                taskStatus.setAutoremove(true);
                taskStatus.add();
                taskStatus.setRangeOfValues(0L, (long)entities.size());
                taskStatus.setCurValue(0L);
                this.taskStatusController.bind((TaskStatus)taskStatus);
                this.processing = true;
                this.doUpdateComponents();
                JDBCServerExplorerParameters serverExplorerParameters = null;
                if (repository instanceof VCSGisRepositoryLocaldb) {
                    serverExplorerParameters = ((VCSGisRepositoryLocaldb)repository).getServerExplorer().getParameters();
                }
                int res = 0;
                for (VCSGisEntity entity : entities) {
                    taskStatus.setTitle("Backup history - " + entity.getLabel() + taskStatus.getProgressLabel());
                    this.showMessage(i18n.getTranslation("_Processing"), null);
                    BackupHistory backupHistory = new BackupHistory(serverExplorerParameters, (File)this.folderController.get(), entity, taskStatus);
                    res = backupHistory.call();
                    if (res != 0) {
                        this.showMessage(i18n.getTranslation("_Aborting_process"), null);
                        taskStatus.abort();
                        int n = res;
                        return n;
                    }
                    taskStatus.incrementCurrentValue();
                }
                this.showMessage(i18n.getTranslation("_Ended_process"), null);
                taskStatus.terminate();
                int n = res;
                return n;
            }
            catch (UserCancelledException ex) {
                LOGGER.warn("User cancelled");
                taskStatus.cancel();
            }
            catch (Exception ex) {
                LOGGER.warn("Can't backup history", (Throwable)ex);
                taskStatus.abort();
            }
            finally {
                this.processing = false;
                this.doUpdateComponents();
            }
        }
        return 600;
    }

    public List<VCSGisEntity> getTables() {
        return this.entitySelector.getCheckedEntities();
    }

    private boolean isValidWorkspace(VCSGisWorkspace ws) {
        VCSGisWorkspace workspace = this.getWorkspace();
        if (workspace != null) {
            VCSGisRepository repository = workspace.getRepository();
            return repository instanceof VCSGisRepositoryLocaldb;
        }
        return false;
    }
}

