/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.repoEntitiyFeatureTypeEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.FeatureTypePanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.VCSGisPanel;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.repoEntitiyFeatureTypeEditor.RepositoryEntityFeatureTypeEditorView;

public class RepositoryEntityFeatureTypeEditorImpl
extends RepositoryEntityFeatureTypeEditorView
implements VCSGisPanel {
    private VCSGisEntitySelectorController entitySelector;
    private PickerController<VCSGisWorkspace> workspacePicker;
    private FeatureTypePanel featureTypeEditor;
    private EditableFeatureType featureType;

    public RepositoryEntityFeatureTypeEditorImpl() {
        this.initComponents();
    }

    private void initComponents() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.translate();
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspace, this.btnWorkspace);
        this.workspacePicker.addChangeListener(e -> {
            this.doChangeWorkspace();
            this.doUpdateComponents();
        });
        this.entitySelector = VCSGisSwingLocator.getVCSGisSwingManager().createEntitySelectorController(this.cboEntity);
        this.entitySelector.setChecksEnabled(false);
        this.entitySelector.addChangeListener(e -> {
            this.doChangedEntity();
            this.doUpdateComponents();
        });
        this.entitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 2: {
                    this.doUpdateComponents();
                }
            }
        });
        this.featureTypeEditor = dataSwingManager.createFeatureTypePanel();
        this.pnlEditor.setLayout(new BorderLayout(0, 0));
        this.pnlEditor.add((Component)this.featureTypeEditor.asJComponent(), "Center");
        this.featureTypeEditor.asJComponent().setEnabled(false);
        this.featureTypeEditor.setMode(2);
        this.btnSave.addActionListener(e -> this.doSave());
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)30, (int)120, (int)40, (int)140);
    }

    private void doChangedEntity() {
        VCSGisEntity entity = this.entitySelector.getSelectedEntity();
        if (entity == null) {
            this.editor_clear();
            return;
        }
        FeatureType ft = entity.getFeatureType();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        this.featureTypeEditor.setMode(swingManager.getRepositoryEntityFeatureTypeEditorMode());
        this.editor_put(ft);
    }

    private void doUpdateComponents() {
        VCSGisWorkspace workspace = (VCSGisWorkspace)this.workspacePicker.get();
        if (workspace == null) {
            this.entitySelector.clear();
            this.entitySelector.setEnabled(false);
            this.editor_clear();
            this.editor_setEnabled(false);
            this.btnSave.setEnabled(false);
            return;
        }
        this.entitySelector.setEnabled(true);
        VCSGisEntity entity = this.entitySelector.getSelectedEntity();
        if (entity == null) {
            this.editor_clear();
            this.editor_setEnabled(false);
            this.btnSave.setEnabled(false);
            return;
        }
        this.editor_setEnabled(true);
        this.btnSave.setEnabled(workspace.isTheRepositoryLocal());
    }

    private void doChangeWorkspace() {
        VCSGisWorkspace workspace = (VCSGisWorkspace)this.workspacePicker.get();
        if (workspace == null) {
            this.entitySelector.setWorkspace(null);
            this.doUpdateComponents();
            return;
        }
        if (!workspace.isTheRepositoryLocal()) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_You_should_select_a_working_copy_that_uses_a_local_repository"), i18n.getTranslation("_VCSGis"), 1);
        }
        this.entitySelector.setWorkspace(workspace);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblWorkspace);
        toolsSwingManager.translate(this.lblEntity);
        toolsSwingManager.translate((AbstractButton)this.btnSave);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    private void editor_clear() {
        this.featureTypeEditor.put(null);
    }

    private void editor_setEnabled(boolean b) {
        this.featureTypeEditor.asJComponent().setEnabled(b);
    }

    private void editor_put(FeatureType ft) {
        this.featureType = (EditableFeatureType)ft;
        this.featureTypeEditor.put(ft);
    }

    private void doSave() {
        VCSGisWorkspace workspace = (VCSGisWorkspace)this.workspacePicker.get();
        if (workspace == null) {
            return;
        }
        VCSGisEntity entity = this.entitySelector.getSelectedEntity();
        if (entity == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        if (this.featureTypeEditor.isEditing()) {
            dialogs.messageDialog(i18n.getTranslation("_It_is_not_possible_to_save_the_changes_while_you_have_pending_changes_to_accept_or_discard"), i18n.getTranslation("_Save_definition"), 1);
            return;
        }
        this.featureTypeEditor.fetch(this.featureType);
        int n = dialogs.confirmDialog(i18n.getTranslation("_The_requested_operation_cannot_be_undone") + "\n" + i18n.getTranslation("_Do_you_want_to_save_the_changes_despite_this"), i18n.getTranslation("_Save_definition"), 0, 3);
        if (n != 0) {
            return;
        }
        VCSGisRepositoryLocaldb repository = (VCSGisRepositoryLocaldb)workspace.getRepository();
        repository.updateFeatureTypeOfEntity(entity.getEntityCode(), (FeatureType)this.featureType);
        dialogs.messageDialog(i18n.getTranslation("_Changes_saved"), i18n.getTranslation("_Save_definition"), 1);
    }

    public boolean isProcessing() {
        return false;
    }

    public void setDialog(Dialog dialog) {
    }

    public JComponent asJComponent() {
        return this;
    }
}

