/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.revisions;

import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJRevisions;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.revisions.VCSGisJRevisionsController;
import org.gvsig.vcsgis.swing.impl.revisions.VCSGisJRevisionsDialogView;

public class VCSGisJRevisionsDialog
extends VCSGisJRevisionsDialogView
implements VCSGisJRevisions {
    private boolean processing = false;
    private TaskStatusController taskStatusController;
    private VCSGisJRevisionsController revisionsController;
    private final VCSGisWorkspace workspace;
    private final VCSGisEntity entity;

    public VCSGisJRevisionsDialog(VCSGisWorkspace workspace, VCSGisEntity entity) {
        this.workspace = workspace;
        this.entity = entity;
        this.initComponents();
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        VCSGisSwingManager vcsSwingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        this.taskStatusController = taskStatusManager.createTaskStatusController(null, this.lblMessages, null);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind(ToolsLocator.getTaskStatusManager());
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.revisionsController = new VCSGisJRevisionsController(this.tblRevisions, this.btnMore, this.btnFilter, this.lblMessages);
        this.revisionsController.setWorkspace(this.workspace);
        this.revisionsController.setEntity(this.entity);
        this.revisionsController.addChangeListener(e -> {
            this.processing = this.revisionsController.isProcessing();
            this.updateStateComponents();
        });
        this.translate();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)12, (int)70);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((AbstractButton)this.btnMore);
        toolsSwingManager.translate((AbstractButton)this.btnFilter);
    }

    private void updateStateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.updateStateComponents())) {
            return;
        }
        this.revisionsController.setEnabled(!this.processing && this.workspace != null && this.entity != null);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    private void message(String msg) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.message(msg))) {
            return;
        }
        this.getTaskStatusController().message(msg);
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblMessages.setVisible(visible);
    }

    public TaskStatusController getTaskStatusController() {
        return this.taskStatusController;
    }

    public VCSGisRevision getSelectedRevision() {
        return this.revisionsController.getSelectedRevision();
    }

    public void setDialog(Dialog dialog) {
    }
}

