/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.io;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.CRSUtils;
import org.cresques.cts.IProjection;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.DatasetBand;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.BandNotFoundInListException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InfoByPointException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.raster.spi.CoverageStoreProvider;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.TileCacheLocator;
import org.gvsig.raster.cache.tile.TileCacheManager;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.cache.tile.provider.CacheStruct;
import org.gvsig.raster.cache.tile.provider.TileListener;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.BandListImpl;
import org.gvsig.raster.impl.datastruct.DatasetBandImpl;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.MemoryTileMatrixBuffer;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.RemoteRasterProvider;
import org.gvsig.raster.impl.provider.TiledRasterProvider;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.raster.impl.store.properties.RemoteStoreHistogram;
import org.gvsig.raster.util.DefaultProviderServices;
import org.gvsig.raster.wmts.io.TilePipe;
import org.gvsig.raster.wmts.io.WMTSDataParameters;
import org.gvsig.raster.wmts.io.WMTSDataParametersImpl;
import org.gvsig.raster.wmts.io.WMTSServerExplorer;
import org.gvsig.raster.wmts.io.WMTSServerExplorerParameters;
import org.gvsig.raster.wmts.io.downloader.WMTSTileServer;
import org.gvsig.raster.wmts.ogc.WMTSClient;
import org.gvsig.raster.wmts.ogc.WMTSOGCLocator;
import org.gvsig.raster.wmts.ogc.WMTSStatus;
import org.gvsig.raster.wmts.ogc.exception.DownloadException;
import org.gvsig.raster.wmts.ogc.exception.ServerErrorException;
import org.gvsig.raster.wmts.ogc.exception.WMTSException;
import org.gvsig.raster.wmts.ogc.struct.WMTSLayer;
import org.gvsig.raster.wmts.ogc.struct.WMTSTile;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrix;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixLimits;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixSet;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixSetLink;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSProvider
extends AbstractRasterProvider
implements RemoteRasterProvider,
TiledRasterProvider {
    public static String NAME = "Wmts Store";
    public static String DESCRIPTION = "Wmts Raster file";
    public static final String METADATA_DEFINITION_NAME = "WmtsStore";
    private static Logger logger = LoggerFactory.getLogger(WMTSProvider.class);
    public static boolean TILED = true;
    public static int SEQUENTIAL = 0;
    public static int LIMITED_THREADS = 1;
    public static int UNLIMITED_THREADS = 2;
    private int requestType = LIMITED_THREADS;
    private static final double MTS_X_GRADO = 111319.490793274;
    private Extent viewRequest = null;
    private WMTSClient ogcClient = null;
    private boolean open = false;
    private File lastRequest = null;
    private DataStoreTransparency lastFileTransparency = null;
    private int lastWidthRequest = 0;
    private int lastHeightRequest = 0;
    private WMTSStatus lastStatus = null;
    private boolean gridSubsets = true;
    private Extent[] extentByLevel = null;
    private Extent bbox = null;
    private MathUtils math = RasterLocator.getManager().getMathUtils();

    public static void register() {
        List explorerProviders;
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (dataman == null) {
            return;
        }
        if (!dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProvider(NAME, WMTSProvider.class, WMTSDataParametersImpl.class);
        }
        if ((explorerProviders = dataman.getExplorerProviders()) != null && !explorerProviders.contains(WMTSServerExplorer.NAME)) {
            dataman.registerExplorerProvider(WMTSServerExplorer.NAME, WMTSServerExplorer.class, WMTSServerExplorerParameters.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    public WMTSProvider() throws NotSupportedExtensionException {
    }

    public WMTSProvider(String params) throws NotSupportedExtensionException, OpenException {
        super(params);
        logger.info("Deprecated use of WMTSProvider constructor");
        if (params instanceof String) {
            WMTSDataParametersImpl p = new WMTSDataParametersImpl();
            try {
                p.setURI(new URI(params));
            }
            catch (URISyntaxException e) {
                throw new OpenException("Can't create URI from" + params, (Throwable)e);
            }
            super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
            this.init((DataStoreParameters)p, null);
        }
    }

    public WMTSProvider(URI uri) throws NotSupportedExtensionException {
        super(uri);
        WMTSDataParametersImpl p = new WMTSDataParametersImpl();
        p.setURI(uri);
        super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((DataStoreParameters)p, null);
    }

    public WMTSProvider(WMTSDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException {
        super((DataStoreParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((DataStoreParameters)params, storeServices);
    }

    public WMTSClient getOGCClient() throws WMTSException {
        if (this.ogcClient == null) {
            WMTSDataParameters p = (WMTSDataParameters)this.parameters;
            this.ogcClient = p.getOGCClient();
            if (this.ogcClient != null) {
                return this.ogcClient;
            }
            URL url = null;
            try {
                url = p.getURI().toURL();
            }
            catch (Exception e) {
                throw new WMTSException("Malformed URL", (Throwable)e);
            }
            try {
                this.ogcClient = WMTSOGCLocator.getManager().createWMTSClient(url.toString());
                this.ogcClient.connect(true, new ICancellable(){

                    public boolean isCanceled() {
                        return false;
                    }

                    public Object getID() {
                        return null;
                    }
                });
            }
            catch (ConnectException e) {
                throw new WMTSException("Connect exception", (Throwable)e);
            }
            catch (IOException e) {
                throw new WMTSException("Connect exception", (Throwable)e);
            }
        }
        return this.ogcClient;
    }

    public void init(DataStoreParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException {
        this.setParam(storeServices, params);
        if (((WMTSDataParameters)params).getImageFormat().compareTo("image/gif") == 0) {
            this.setDataType(new int[]{0});
            this.bandCount = 1;
        } else {
            this.setDataType(new int[]{0, 0, 0, 0});
            this.bandCount = 4;
        }
        if (!(this.param instanceof WMTSDataParameters)) {
            return;
        }
        this.gridSubsets = this.hasGridSubsets((WMTSDataParameters)this.param);
        this.open = true;
    }

    public boolean hasGridSubsets() {
        return this.gridSubsets;
    }

    private boolean hasGridSubsets(WMTSDataParameters p) {
        List tileMatrixSetLimits = null;
        List tileMatrixSetLinkList = p.getLayer().getTileMatrixSetLink();
        String srs = p.getSRSCode();
        for (int i = 0; i < tileMatrixSetLinkList.size(); ++i) {
            WMTSTileMatrixSetLink tileMatrixSetLink = (WMTSTileMatrixSetLink)tileMatrixSetLinkList.get(i);
            WMTSTileMatrixSet tms = tileMatrixSetLink.getTileMatrixSet();
            List tmsl = tileMatrixSetLink.getTileMatrixLimits();
            String srsTileSet = tms.getSupportedCRS();
            if (!this.areSrsEquals(srsTileSet, srs)) continue;
            tileMatrixSetLimits = tmsl;
        }
        return tileMatrixSetLimits != null && !tileMatrixSetLimits.isEmpty();
    }

    private boolean areSrsEquals(String sourceSrs, String appSrs) {
        if (sourceSrs.compareTo(appSrs) == 0) {
            return true;
        }
        if ((sourceSrs.contains("CRS:84") || sourceSrs.contains("CRS84")) && appSrs.equals("EPSG:4326")) {
            return true;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)CRSUtils.ogcProjectionToAuthorityAndCode((String)sourceSrs), (CharSequence)CRSUtils.ogcProjectionToAuthorityAndCode((String)appSrs));
    }

    public ColorInterpretation getColorInterpretation() {
        if (super.getColorInterpretation() == null) {
            DataStoreColorInterpretation colorInterpretation = new DataStoreColorInterpretation(this.getBandCount());
            if (this.getBandCount() == 1) {
                colorInterpretation = DataStoreColorInterpretation.createGrayInterpretation();
            }
            if (this.getBandCount() == 3) {
                colorInterpretation = DataStoreColorInterpretation.createRGBInterpretation();
            }
            if (this.getBandCount() == 4) {
                colorInterpretation = DataStoreColorInterpretation.createRGBAInterpretation();
            }
            if (this.getBandCount() > 4 || this.getBandCount() == 2) {
                for (int i = 0; i < this.getBandCount(); ++i) {
                    colorInterpretation.setColorInterpValue(i, "Undefined");
                }
            }
            this.setColorInterpretation((ColorInterpretation)colorInterpretation);
        }
        return super.getColorInterpretation();
    }

    public boolean isTiled() {
        return true;
    }

    public AffineTransform getAffineTransform() {
        WMTSDataParameters p = (WMTSDataParameters)this.parameters;
        Extent e = this.getExtent();
        double psX = e.width() / (double)(this.lastWidthRequest <= 0 ? p.getWidth() : this.lastWidthRequest);
        double psY = -(e.height() / (double)(this.lastHeightRequest <= 0 ? p.getHeight() : this.lastHeightRequest));
        this.ownTransformation = new AffineTransform(psX, 0.0, 0.0, psY, e.getULX() - psX / 2.0, e.getULY() - psY / 2.0);
        this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
        return this.ownTransformation;
    }

    public Extent getExtent() {
        String crsCode;
        Rectangle2D r;
        WMTSDataParameters p = (WMTSDataParameters)this.parameters;
        WMTSLayer layer = p.getLayer();
        if (layer.getBBox() != null) {
            return new ExtentImpl(layer.getBBox().toRectangle2D());
        }
        if (layer.getWGS84BBox() != null && (r = layer.getWGS84BBoxTransformed(crsCode = p.getSRSCode())) != null) {
            return new ExtentImpl(r);
        }
        if (this.bbox == null) {
            this.getExtentByResolutionLevel();
        }
        return this.bbox;
    }

    public String getFileSuffix() {
        WMTSDataParameters p = (WMTSDataParameters)this.parameters;
        String format = p.getImageFormat();
        if (format == null) {
            return "xml";
        }
        if (format.contains("png")) {
            return "png";
        }
        if (format.contains("xml")) {
            return "xml";
        }
        if (format.contains("gif")) {
            return "gif";
        }
        if (format.contains("tif")) {
            return "tif";
        }
        if (format.contains("bmp")) {
            return "bmp";
        }
        if (format.contains("jpg") || format.contains("jpeg")) {
            return "jpg";
        }
        return "xml";
    }

    public Extent[] getExtentByResolutionLevel() {
        if (this.extentByLevel == null) {
            WMTSDataParameters p = (WMTSDataParameters)this.parameters;
            WMTSTileMatrixSetLink tileMatrixSetLink = this.getTileMatrixSetLink();
            WMTSTileMatrixSet tileMatrixSet = tileMatrixSetLink.getTileMatrixSet();
            List tileMatrixList = tileMatrixSet.getTileMatrix();
            this.extentByLevel = new ExtentImpl[tileMatrixList.size()];
            double minX = 0.0;
            double minY = 0.0;
            double maxX = 0.0;
            double maxY = 0.0;
            for (int i = 0; i < tileMatrixList.size(); ++i) {
                double heightMtsTile;
                double widthMtsTile;
                WMTSTileMatrix tileMatrix = (WMTSTileMatrix)tileMatrixList.get(i);
                if (!p.isProjected()) {
                    widthMtsTile = tileMatrix.getScaleDenominator() * (double)tileMatrix.getTileWidth() * 0.28 / 1.11319490793274E8;
                    heightMtsTile = tileMatrix.getScaleDenominator() * (double)tileMatrix.getTileHeight() * 0.28 / 1.11319490793274E8;
                } else {
                    widthMtsTile = tileMatrix.getScaleDenominator() * (double)tileMatrix.getTileWidth() * 0.28 / 1000.0;
                    heightMtsTile = tileMatrix.getScaleDenominator() * (double)tileMatrix.getTileHeight() * 0.28 / 1000.0;
                }
                double h = Math.abs(tileMatrix.getTopLeftCorner()[1] - (tileMatrix.getTopLeftCorner()[1] - (double)tileMatrix.getMatrixHeight() * heightMtsTile));
                Rectangle2D.Double r = new Rectangle2D.Double(tileMatrix.getTopLeftCorner()[0], tileMatrix.getTopLeftCorner()[1] - h, Math.abs(tileMatrix.getTopLeftCorner()[0] - (tileMatrix.getTopLeftCorner()[0] + (double)tileMatrix.getMatrixWidth() * widthMtsTile)), h);
                this.extentByLevel[i] = new ExtentImpl((Rectangle2D)r);
                if (i == 0) {
                    minX = this.extentByLevel[i].getMin().getX();
                    minY = this.extentByLevel[i].getMin().getY();
                    maxX = this.extentByLevel[i].getMax().getX();
                    maxY = this.extentByLevel[i].getMax().getY();
                    continue;
                }
                minX = Math.min(minX, this.extentByLevel[i].getMin().getX());
                minY = Math.min(minY, this.extentByLevel[i].getMin().getY());
                maxX = Math.max(maxX, this.extentByLevel[i].getMax().getX());
                maxY = Math.max(maxY, this.extentByLevel[i].getMax().getY());
            }
            this.bbox = new ExtentImpl(minX, maxY, maxX, minY);
        }
        return this.extentByLevel;
    }

    public Rectangle2D getLayerExtent(String layerName, String srs) throws RemoteServiceException {
        return null;
    }

    public RasterProvider load() {
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.open = false;
    }

    public Transparency getTransparency() {
        if (this.lastFileTransparency == null) {
            this.lastFileTransparency = new DataStoreTransparency(this.getColorInterpretation());
            this.lastFileTransparency.setTransparencyBand(3);
        }
        return this.lastFileTransparency;
    }

    public NoData getNoDataValue() {
        NoData nodata = super.getNoDataValue();
        if (nodata != null) {
            nodata.setNoDataTransparent(false);
        }
        return this.noData;
    }

    public URI translateURI(URI uri) {
        return uri;
    }

    public void setView(Extent e) {
        this.viewRequest = e;
    }

    public Extent getView() {
        return this.viewRequest;
    }

    public double getWidth() {
        WMTSDataParameters p = (WMTSDataParameters)this.parameters;
        if (this.lastWidthRequest <= 0) {
            return p.getWidth();
        }
        return this.lastWidthRequest;
    }

    public double getHeight() {
        WMTSDataParameters p = (WMTSDataParameters)this.parameters;
        if (this.lastHeightRequest <= 0) {
            return p.getHeight();
        }
        return this.lastHeightRequest;
    }

    public Object readCompleteLine(int line, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        return null;
    }

    public File getFileLayer() throws RasterDriverException {
        return null;
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        return null;
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        return null;
    }

    public Buffer getBuffer(Buffer rasterBuf, BandList bandList, File lastFile, double ulx, double uly, double lrx, double lry) throws RasterDriverException, ProcessInterruptedException {
        return null;
    }

    private WMTSTileMatrix getTileMatrixByLevel(int level) {
        level = this.adjustLevel(level);
        WMTSTileMatrixSetLink tileMatrixSetLink = this.getTileMatrixSetLink();
        WMTSTileMatrixSet tileMatrixSet = tileMatrixSetLink.getTileMatrixSet();
        List tileMatrixSetLimits = tileMatrixSetLink.getTileMatrixLimits();
        WMTSTileMatrixLimits tileMatrixLimits = null;
        WMTSTileMatrix tileMatrix = (WMTSTileMatrix)tileMatrixSet.getTileMatrix().get(level);
        if (this.hasGridSubsets()) {
            tileMatrixLimits = (WMTSTileMatrixLimits)tileMatrixSetLimits.get(level);
            tileMatrix = tileMatrixLimits.getTileMatrix();
        }
        return tileMatrix;
    }

    public int getZoomLevels() {
        WMTSTileMatrixSetLink tileMatrixSetLink = this.getTileMatrixSetLink();
        WMTSTileMatrixSet tileMatrixSet = tileMatrixSetLink.getTileMatrixSet();
        if (this.hasGridSubsets()) {
            List tileMatrixSetLimits = tileMatrixSetLink.getTileMatrixLimits();
            return Math.min(tileMatrixSet.getTileMatrix().size(), tileMatrixSetLimits.size());
        }
        return tileMatrixSet.getTileMatrix().size();
    }

    public Extent getCoordsInTheNearestLevel(Extent extent, int w, int h) {
        double[] pixelSizes = this.getPixelSizeByLevel();
        double currentPixelSize = extent.width() / (double)w;
        int level = 0;
        for (int i = 0; i < pixelSizes.length - 1; ++i) {
            if (!(currentPixelSize < pixelSizes[i]) || !(currentPixelSize >= pixelSizes[i + 1])) continue;
            level = i + 1;
            break;
        }
        return this.getZoomLevelCoordinates(level, extent, w, h);
    }

    public Extent getCoordsInLevel(Point2D viewCenter, int level, int w, int h) {
        WMTSDataParameters p = (WMTSDataParameters)this.param;
        level = this.adjustLevel(level);
        WMTSTileMatrix tileMatrix = this.getTileMatrixByLevel(level);
        boolean isProjected = p.isProjected();
        double psX = tileMatrix.getWidthWCTile(isProjected) / (double)tileMatrix.getTileWidth();
        double psY = tileMatrix.getHeightWCTile(isProjected) / (double)tileMatrix.getTileHeight();
        double ulx = viewCenter.getX() - (double)(w / 2) * psX;
        double uly = viewCenter.getY() - (double)(h / 2) * psY;
        double lrx = ulx + (double)w * psX;
        double lry = uly + (double)h * psY;
        return new ExtentImpl(ulx, uly, lrx, lry);
    }

    public Extent getZoomLevelCoordinates(int level, Extent extent, int w, int h) {
        double centerX = extent.getCenterX();
        double centerY = extent.getCenterY();
        return this.getCoordsInLevel(new Point2D.Double(centerX, centerY), level, w, h);
    }

    public double[] getPixelSizeByLevel() {
        WMTSDataParameters p = (WMTSDataParameters)this.param;
        double[] list = new double[this.getZoomLevels()];
        for (int i = 0; i < this.getZoomLevels(); ++i) {
            WMTSTileMatrix tileMatrix = this.getTileMatrixByLevel(i);
            list[i] = this.math.adjustDouble(tileMatrix.getWidthWCTile(p.isProjected()) / (double)tileMatrix.getTileWidth());
        }
        return list;
    }

    private int adjustLevel(int level) {
        if (level < 0) {
            level = 0;
        }
        if (level > this.getZoomLevels()) {
            level = this.getZoomLevels();
        }
        return level;
    }

    public Tile getTile(SpiRasterQuery q) throws TileGettingException {
        CacheStruct str = this.getTileServer().getStruct();
        WMTSTileMatrixSetLink tileMatrixSetLink = this.getTileMatrixSetLink();
        WMTSTileMatrixSet tileMatrixSet = tileMatrixSetLink.getTileMatrixSet();
        List tileMatrixSetLimits = tileMatrixSetLink.getTileMatrixLimits();
        WMTSTileMatrix tileMatrix = (WMTSTileMatrix)tileMatrixSet.getTileMatrix().get(q.getResolutionLevel());
        if (this.gridSubsets) {
            WMTSTileMatrixLimits tileMatrixLimits = (WMTSTileMatrixLimits)tileMatrixSetLimits.get(q.getResolutionLevel());
            tileMatrix = tileMatrixLimits.getTileMatrix();
        }
        int bufWidth = tileMatrix.getTileWidth();
        int bufHeight = tileMatrix.getTileHeight();
        try {
            Extent adjBbox = q.getAdjustedRequestBoundingBox();
            Rectangle2D r = adjBbox.toRectangle2D();
            WMTSStatus status = this.buildWMTSStatus(r, bufWidth, bufHeight);
            int[] size = str.getTileSizeByLevel(q.getResolutionLevel());
            WMTSTile tile = WMTSOGCLocator.getManager().createTile(size, new int[]{q.getTileRow(), q.getTileCol()}, new double[]{adjBbox.getULX(), adjBbox.getULY(), adjBbox.getLRX(), adjBbox.getLRY()});
            File file = this.getOGCClient().getTile(status, null);
            tile.setFile(file);
            BandListImpl bandList = new BandListImpl();
            for (int i = 0; i < this.getBandCount(); ++i) {
                try {
                    DatasetBandImpl band = new DatasetBandImpl(this.getURIOfFirstProvider().getPath(), i, this.getDataType()[i], this.getBandCount());
                    bandList.addBand((DatasetBand)band);
                    continue;
                }
                catch (BandNotFoundInListException bandNotFoundInListException) {
                    // empty catch block
                }
            }
            return this.drawTile(tile, null, (BandList)bandList);
        }
        catch (RasterDriverException | ServerErrorException | WMTSException e) {
            throw new TileGettingException("Error getting tiles", e);
        }
    }

    public void loadBuffer(SpiRasterQuery q) throws ProcessInterruptedException, RasterDriverException {
        Rectangle2D r = q.getAdjustedRequestBoundingBox().toRectangle2D();
        WMTSStatus status = this.buildWMTSStatus(r, q.getAdjustedWidth(), q.getAdjustedBufHeight());
        this.request(status, q.getBandList(), q.getTileListener(), this.requestType);
        Tile[] tileList = this.request(status, q.getBandList(), null, this.requestType);
        MemoryTileMatrixBuffer matrixBuffer = new MemoryTileMatrixBuffer(tileList);
        Buffer b = matrixBuffer.getWindow(q.getAdjustedRequestBoundingBox(), q.getBufWidth(), q.getBufHeight(), q.getBandList().getDrawableBandsCount());
        q.setBufferResult(b);
    }

    public String getFeatureInfo(double wcx, double wcy, int level) throws RasterDriverException {
        PointInfo pointInfo = new PointInfo(new Point2D.Double(wcx, wcy));
        pointInfo.level = level;
        this.getTileInfo(pointInfo);
        try {
            WMTSClient theOgcClient = this.getOGCClient();
            this.lastStatus.setTileRow((int)pointInfo.tile.getX());
            this.lastStatus.setTileCol((int)pointInfo.tile.getY());
            String fi = theOgcClient.getFeatureInfo(this.lastStatus, (int)pointInfo.pixelInTile.getX(), (int)pointInfo.pixelInTile.getY(), null);
            return fi;
        }
        catch (WMTSException e) {
            throw new RasterDriverException("Error getting the connector object", (Exception)((Object)e));
        }
    }

    private void getTileInfo(PointInfo pointInfo) {
        WMTSDataParameters p = (WMTSDataParameters)this.param;
        WMTSTileMatrixSetLink tileMatrixSetLink = this.getTileMatrixSetLink();
        WMTSTileMatrixSet tileMatrixSet = tileMatrixSetLink.getTileMatrixSet();
        List tileMatrixSetLimits = tileMatrixSetLink.getTileMatrixLimits();
        WMTSTileMatrixLimits tileMatrixLimits = null;
        WMTSTileMatrix tileMatrix = (WMTSTileMatrix)tileMatrixSet.getTileMatrix().get(pointInfo.level);
        if (this.hasGridSubsets()) {
            tileMatrixLimits = (WMTSTileMatrixLimits)tileMatrixSetLimits.get(pointInfo.level);
            tileMatrix = tileMatrixLimits.getTileMatrix();
        }
        List tiles = this.hasGridSubsets() ? tileMatrix.contains(p.isProjected(), tileMatrixLimits, pointInfo.worldCoord, this.getExtent().toRectangle2D()) : tileMatrix.contains(p.isProjected(), pointInfo.worldCoord, this.getExtent().toRectangle2D());
        pointInfo.tile = new Point2D.Double(((WMTSTile)tiles.get(0)).getRow(), ((WMTSTile)tiles.get(0)).getCol());
        Point2D rasterPoint = ((WMTSTile)tiles.get(0)).worldToRaster(pointInfo.worldCoord);
        pointInfo.pixelInTile = new Point2D.Double(rasterPoint.getX(), rasterPoint.getY());
    }

    public WMTSStatus buildWMTSStatus(Rectangle2D r, int bufWidth, int bufHeight) throws RasterDriverException {
        WMTSDataParameters p = (WMTSDataParameters)this.param;
        p.setExtent(r);
        p.setWidth(bufWidth);
        p.setHeight(bufHeight);
        this.lastWidthRequest = bufWidth;
        this.lastHeightRequest = bufHeight;
        WMTSTileMatrixSetLink tileMatrixSetLink = this.getTileMatrixSetLink();
        WMTSTileMatrixSet tileMatrixSet = tileMatrixSetLink.getTileMatrixSet();
        List tileMatrixSetLimits = tileMatrixSetLink.getTileMatrixLimits();
        int initialLevel = p.getLayer().getInitialLevel(tileMatrixSet.getIdentifier());
        double scale = this.getScale(r, bufWidth);
        int level = this.getLevelFromScale(scale, tileMatrixSet);
        int dif = 0;
        if (this.gridSubsets) {
            dif = level - initialLevel >= tileMatrixSetLimits.size() ? level - initialLevel - tileMatrixSetLimits.size() + 1 : 0;
        }
        WMTSTileMatrixLimits tileMatrixLimits = null;
        WMTSTileMatrix tileMatrix = (WMTSTileMatrix)tileMatrixSet.getTileMatrix().get(level - dif);
        if (this.gridSubsets) {
            tileMatrixLimits = (WMTSTileMatrixLimits)tileMatrixSetLimits.get(level - initialLevel - dif);
        }
        List tiles = null;
        Extent[] extList = this.getExtentByResolutionLevel();
        tiles = tileMatrix.intersects(p.isProjected(), r, extList[level].toRectangle2D());
        WMTSStatus status = null;
        try {
            status = this.getOGCClient().createStatus();
        }
        catch (WMTSException e) {
            throw new RasterDriverException("Error creating WMTSStatus", (Exception)((Object)e));
        }
        WMTSLayer wmtsLayer = p.getLayer();
        status.setTileList(tiles);
        status.setLayer(wmtsLayer.getIdentifier());
        status.setFormat(p.getImageFormat());
        status.setInfoFormat(p.getInfoFormat());
        status.setStyle(p.getStyle() != null ? p.getStyle().getIdentifier() : "");
        status.setTileMatrixSet(tileMatrixSet.getIdentifier());
        status.setTileMatrix(tileMatrix.getIdentifier());
        status.setLevel(level - dif);
        status.setDimension(p.getDimension());
        status.setValueForDimension(p.getDimensionSelectedValue());
        wmtsLayer.buildResourceURLListFromTemplate(status);
        this.lastStatus = status;
        return status;
    }

    public int getLevelFromRealCoords(Rectangle2D r, int width) throws RasterDriverException {
        double scale = this.getScale(r, width);
        WMTSTileMatrixSetLink tileMatrixSetLink = this.getTileMatrixSetLink();
        WMTSTileMatrixSet tileMatrixSet = tileMatrixSetLink.getTileMatrixSet();
        return this.getLevelFromScale(scale, tileMatrixSet);
    }

    public int getLevelFromScale(double scale, WMTSTileMatrixSet tileMatrixSet) throws RasterDriverException {
        int levelModifier = 0;
        scale = this.math.adjustDouble(scale);
        try {
            for (int resolutionLevel = 0; resolutionLevel < tileMatrixSet.getTileMatrix().size(); ++resolutionLevel) {
                WMTSTileMatrix tm = (WMTSTileMatrix)tileMatrixSet.getTileMatrix().get(resolutionLevel);
                double scaleDenominator = this.math.adjustDouble(tm.getScaleDenominator());
                if (!(scale >= scaleDenominator)) continue;
                return Math.max(resolutionLevel + levelModifier, 0);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new RasterDriverException("Error in this resolution level", (Exception)e);
        }
        return 0;
    }

    public WMTSTileMatrixSetLink getTileMatrixSetLink() {
        WMTSDataParameters p = (WMTSDataParameters)this.param;
        List tileMatrixSetLinkList = p.getLayer().getTileMatrixSetLink();
        if (tileMatrixSetLinkList == null) {
            return null;
        }
        String layerSrsCode = CRSUtils.ogcProjectionToAuthorityAndCode((String)p.getSRSCode());
        for (int i = 0; i < tileMatrixSetLinkList.size(); ++i) {
            WMTSTileMatrixSetLink tileMatrixSetLink = (WMTSTileMatrixSetLink)tileMatrixSetLinkList.get(i);
            String srsTileSet = CRSUtils.ogcProjectionToAuthorityAndCode((String)tileMatrixSetLink.getTileMatrixSet().getSupportedCRS());
            if (srsTileSet.compareTo(layerSrsCode) != 0) continue;
            return tileMatrixSetLink;
        }
        if (!tileMatrixSetLinkList.isEmpty()) {
            return (WMTSTileMatrixSetLink)tileMatrixSetLinkList.get(0);
        }
        return null;
    }

    private double getScale(Rectangle2D r, int width) {
        WMTSDataParameters p = (WMTSDataParameters)this.param;
        if (!p.isProjected()) {
            return r.getWidth() * 111319.490793274 / ((double)width * 2.8E-4);
        }
        return r.getWidth() / ((double)width * 2.8E-4);
    }

    private synchronized Tile[] request(WMTSStatus status, BandList bandList, TileListener listener, int requestType) throws RasterDriverException, ProcessInterruptedException {
        WMTSTile tile;
        WMTSClient theOgcClient = null;
        try {
            theOgcClient = this.getOGCClient();
        }
        catch (WMTSException e) {
            throw new RasterDriverException("Error getting the connector object", (Exception)((Object)e));
        }
        if (theOgcClient == null) {
            throw new RasterDriverException("Error getting the connector object");
        }
        List tiles = status.getTileList();
        TilePipe pipe = new TilePipe();
        if (requestType == LIMITED_THREADS) {
            RequestThreadManager threadManager = new RequestThreadManager(pipe, tiles, status);
            pipe.setRequestManager(threadManager);
            threadManager.start();
        } else if (requestType == UNLIMITED_THREADS) {
            for (int i = 0; i < tiles.size(); ++i) {
                WMTSTile tile2 = (WMTSTile)tiles.get(i);
                WMTSStatus statusCopy = status.cloneStatus();
                statusCopy.setTileRow(tile2.getRow());
                statusCopy.setTileCol(tile2.getCol());
                new RequestTileLauncher(pipe, statusCopy, tile2).start();
            }
        }
        Tile[] tileList = new Tile[tiles.size()];
        if (requestType == LIMITED_THREADS || requestType == UNLIMITED_THREADS) {
            for (int nCollected = 0; nCollected < tiles.size(); ++nCollected) {
                tile = pipe.getTile();
                tileList[nCollected] = this.drawTile(tile, listener, bandList);
            }
        }
        if (requestType == SEQUENTIAL) {
            for (int i = 0; i < tiles.size(); ++i) {
                tile = (WMTSTile)tiles.get(i);
                status.setTileRow(tile.getRow());
                status.setTileCol(tile.getCol());
                try {
                    File file = theOgcClient.getTile(status, null);
                    tile.setFile(file);
                    tileList[i] = this.drawTile(tile, listener, bandList);
                    continue;
                }
                catch (ServerErrorException | WMTSException e) {
                    throw new RasterDriverException("Error getting tiles", (Exception)e);
                }
            }
        }
        if (listener != null) {
            listener.endReading();
        }
        return tileList;
    }

    private synchronized Tile drawTile(WMTSTile tile, TileListener listener, BandList bandList) throws RasterDriverException {
        WMTSDataParameters p = (WMTSDataParameters)this.param;
        try {
            AbstractRasterProvider driver = DefaultProviderServices.loadProvider((File)tile.getFile());
            this.colorTable = driver.getColorTable();
            this.bandCount = driver.getBandCount();
            this.lastFileTransparency = (DataStoreTransparency)driver.getTransparency();
            RasterQuery q = RasterLocator.getManager().createQuery();
            q.setAreaOfInterest(new Rectangle(0, 0, tile.getWidthPx(), tile.getHeightPx()));
            int[] drawableBands = bandList.getDrawableBands();
            if (drawableBands.length > 3) {
                drawableBands = new int[]{drawableBands[0], drawableBands[1], drawableBands[2]};
            }
            q.setDrawableBands(bandList.getDrawableBands());
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((CoverageStoreProvider)driver);
            Buffer buf = store.query(q);
            buf.setDataExtent((Rectangle2D)new Rectangle2D.Double(Math.min(tile.getULX(), tile.getLRX()), Math.min(tile.getULY(), tile.getLRY()), Math.abs(tile.getULX() - tile.getLRX()), Math.abs(tile.getULY() - tile.getLRY())));
            Buffer alphaBand = null;
            if (p.getAlphaBand() != -1 && listener != null && p.getAlphaBand() < this.bandCount) {
                q = RasterLocator.getManager().createQuery();
                q.setAreaOfInterest(new Rectangle(0, 0, tile.getWidthPx(), tile.getHeightPx()));
                q.setDrawableBands(new int[]{p.getAlphaBand()});
                alphaBand = store.query(q);
            }
            try {
                store.close();
            }
            catch (CloseException e) {
                logger.info("I cannot close the DataStore", (Throwable)e);
            }
            TileCacheManager m = TileCacheLocator.getManager();
            Tile t = m.createTile(-1, tile.getRow(), tile.getCol());
            t.setData(new Object[]{buf, alphaBand});
            t.setUl((Point2D)new Point2D.Double(tile.getULX(), tile.getULY()));
            t.setLr((Point2D)new Point2D.Double(tile.getLRX(), tile.getLRY()));
            t.setDownloaderParams("AffineTransform", (Object)this.getAffineTransform());
            t.setDownloaderParams("Tiling", (Object)true);
            if (listener == null) {
                return t;
            }
            listener.tileReady(t);
        }
        catch (ProcessInterruptedException driver) {
        }
        catch (QueryException | InitializeException | ProviderNotRegisteredException | TileGettingException e) {
            throw new RasterDriverException("Error throwing a tile", (Exception)e);
        }
        return null;
    }

    public Image getImageLegend() {
        try {
            File file = this.getOGCClient().getLegendGraphic(((WMTSDataParameters)this.param).getLayer(), ((WMTSDataParameters)this.param).getStyle(), new ICancellable(){

                public boolean isCanceled() {
                    return false;
                }

                public Object getID() {
                    return null;
                }
            });
            Image img = null;
            if (file != null && file.length() > 0L) {
                img = new ImageIcon(file.getAbsolutePath()).getImage();
            }
            return img;
        }
        catch (Exception e) {
            logger.info("Problems in GetLegendGraphic", (Throwable)e);
            return null;
        }
    }

    public int getBlockSize() {
        return 0;
    }

    public void setAffineTransform(AffineTransform t) {
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public boolean isOverviewsSupported() {
        return false;
    }

    public boolean isReproyectable() {
        return false;
    }

    public String getProviderName() {
        return NAME;
    }

    public String getName() {
        return this.getParameters().getLayer().getTitle();
    }

    public WMTSDataParameters getParameters() {
        return (WMTSDataParameters)this.param;
    }

    public Point2D rasterToWorld(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        this.getAffineTransform().transform(pt, p);
        return p;
    }

    public Point2D worldToRaster(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        try {
            this.getAffineTransform().inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof WMTSProvider) {
            // empty if block
        }
    }

    public File getLastRequest() {
        return this.lastRequest;
    }

    public void setParam(DataStoreProviderServices storeServices, DataStoreParameters param) {
        if (param instanceof WMTSDataParameters) {
            this.uri = ((WMTSDataParameters)param).getURI();
        }
        this.param = param;
        this.storeServices = storeServices;
    }

    public String getInfoByPoint(int x, int y, Extent bbox, int w, int h, ICancellable cancellable) throws InfoByPointException {
        try {
            int level = this.getLevelFromRealCoords(bbox.toRectangle2D(), w);
            return this.getFeatureInfo(x, y, level);
        }
        catch (RasterDriverException e) {
            throw new InfoByPointException("Error in getFeatureInfo", (Throwable)e);
        }
    }

    public int getNearestLevel(double pixelSize) {
        double[] pixelSizes = this.getPixelSizeByLevel();
        for (int i = 0; i < pixelSizes.length - 1; ++i) {
            if (!(pixelSize <= pixelSizes[i]) || !(pixelSize > pixelSizes[i + 1])) continue;
            return i;
        }
        if (pixelSize < pixelSizes[this.getZoomLevels() - 1]) {
            return this.getZoomLevels() - 1;
        }
        return 0;
    }

    public TileServer getTileServer() {
        if (this.tileServer == null) {
            DefaultRasterStore theStore = new DefaultRasterStore();
            theStore.setProvider((RasterProvider)this);
            this.tileServer = new WMTSTileServer((RasterDataStore)theStore, this.getTileMatrixSetLink());
        }
        return this.tileServer;
    }

    public int[] getTileSize(int level) {
        return this.getTileServer().getStruct().getTileSizeByLevel(level);
    }

    public boolean isRasterEnclosed() {
        return true;
    }

    public Buffer getBufferLastRequest() throws ProcessInterruptedException, RasterDriverException {
        return null;
    }

    public String getSRSCode() {
        WMTSDataParameters p = (WMTSDataParameters)this.param;
        return p.getSRSCode();
    }

    public RasterProvider getInternalProvider() {
        return this;
    }

    public HistogramComputer getHistogramComputer() {
        if (this.histogram == null) {
            this.histogram = new RemoteStoreHistogram((RemoteRasterProvider)this);
        }
        return this.histogram;
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }

    public IProjection getProjection() {
        if (this.proj == null) {
            this.proj = ((WMTSDataParameters)this.param).getSRS();
        }
        return this.proj;
    }

    public class PointInfo {
        public Point2D worldCoord;
        public Point2D tile;
        public Point2D pixelInTile;
        public int level;

        public PointInfo(Point2D worldCoord) {
            this.worldCoord = worldCoord;
        }
    }

    class RequestTileLauncher
    extends Thread {
        private TilePipe pipe = null;
        private WMTSStatus status = null;
        private WMTSTile tile = null;

        public RequestTileLauncher(TilePipe pipe, WMTSStatus status, WMTSTile tile) {
            this.pipe = pipe;
            this.status = status;
            this.tile = tile;
        }

        @Override
        public void run() {
            try {
                URL url = WMTSProvider.this.getOGCClient().getTileURL(this.status);
                this.tile.setFile(WMTSProvider.this.getOGCClient().downloadFile(url, null));
                this.pipe.setTile(this.tile);
            }
            catch (DownloadException e) {
                logger.info("Error downloading files", (Throwable)e);
            }
            catch (MalformedURLException e) {
                logger.info("Malformed URL", (Throwable)e);
            }
            catch (WMTSException e) {
                logger.info("", (Throwable)e);
            }
        }
    }

    public class RequestThreadManager
    extends Thread {
        private TilePipe pipe = null;
        private List<WMTSTile> tiles = null;
        private WMTSStatus status = null;

        public RequestThreadManager(TilePipe pipe, List<WMTSTile> tiles, WMTSStatus status) {
            this.pipe = pipe;
            this.tiles = tiles;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int i = 0; i < this.tiles.size(); ++i) {
                WMTSTile tile = this.tiles.get(i);
                WMTSStatus statusCopy = this.status.cloneStatus();
                statusCopy.setTileRow(tile.getRow());
                statusCopy.setTileCol(tile.getCol());
                if (this.pipe.getSize() > TilePipe.NTHREADS_QUEUE) {
                    try {
                        RequestThreadManager requestThreadManager = this;
                        synchronized (requestThreadManager) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                new RequestTileLauncher(this.pipe, statusCopy, tile).start();
            }
        }
    }
}

