/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.exceptions.WrongOutputIDException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.geoprocess.lib.api.GeoProcess;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.lib.api.GeoProcessManager;
import org.gvsig.geoprocess.lib.sextante.SimpleTaskStatusDelegated;
import org.gvsig.geoprocess.lib.sextante.core.DefaultOutputFactory;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.namestranslator.NamesTranslator;

public abstract class AbstractSextanteGeoProcess
extends GeoAlgorithm
implements GeoProcess {
    protected String[] attrNames = null;
    private SimpleTaskStatusDelegated status = null;
    protected GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private NamesTranslator namesTranslator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ITaskMonitor task, OutputFactory outputFactory, HashMap<String, String> outputMap) throws GeoAlgorithmExecutionException {
        this.status = new SimpleTaskStatusDelegated(this.m_Task, this.getGeoProcessName());
        this.status.add();
        boolean result = false;
        try {
            result = super.execute(task, outputFactory, outputMap);
        }
        finally {
            this.status.remove();
        }
        return result;
    }

    protected IRasterLayer getNewRORasterLayer(String sName, String sDescription, int iDataType, int iBands) throws UnsupportedOutputChannelException {
        IOutputChannel channel = this.getOutputChannel(sName);
        IRasterLayer newLayer = ((DefaultOutputFactory)this.m_OutputFactory).getNewEmptyRORasterLayer(sName, iDataType, this.m_AnalysisExtent, iBands, channel, this.m_CRS);
        this.addOutputRasterLayer(sName, sDescription, iBands, channel, newLayer);
        return newLayer;
    }

    protected FeatureStore buildOutPutStore(FeatureType featureType, int shapeType, String sextanteLayerName, String sextanteLayerLabel) {
        block11: {
            ArrayList<Class> types = new ArrayList<Class>();
            ArrayList<Integer> sizes = new ArrayList<Integer>();
            ArrayList<String> theAttrNames = new ArrayList<String>();
            ArrayList<FeatureAttributeDescriptor> emulateds = new ArrayList<FeatureAttributeDescriptor>();
            for (FeatureAttributeDescriptor attribute : featureType) {
                if (attribute.isComputed()) {
                    emulateds.add(attribute);
                    continue;
                }
                String attrName = attribute.getName();
                if (attribute.getDataType().getType() == 66) continue;
                theAttrNames.add(attrName);
                types.add(attribute.getObjectClass());
                sizes.add(attribute.getSize());
            }
            try {
                int[] arraySizes = sizes.stream().mapToInt(i -> i).toArray();
                FlyrVectIVectorLayer output = (FlyrVectIVectorLayer)this.getNewVectorLayer(sextanteLayerLabel, sextanteLayerName, shapeType, types.toArray(new Class[types.size()]), theAttrNames.toArray(new String[theAttrNames.size()]), arraySizes);
                if (output == null) break block11;
                FeatureStore store = output.getFeatureStore();
                if (!emulateds.isEmpty()) {
                    try {
                        boolean needStartEditingMode;
                        boolean bl = needStartEditingMode = !store.isEditing() && !store.isAppending();
                        if (needStartEditingMode) {
                            store.edit();
                        }
                        EditableFeatureType ft = store.getDefaultFeatureType().getEditable();
                        for (FeatureAttributeDescriptor emulated : emulateds) {
                            theAttrNames.add(emulated.getName());
                            ft.add(emulated.getName(), emulated.getType(), emulated.getFeatureAttributeEmulator());
                        }
                        store.update(ft);
                        if (needStartEditingMode) {
                            store.finishEditing();
                        }
                    }
                    catch (Exception e) {
                        Sextante.addErrorToLog((Throwable)e);
                    }
                }
                this.attrNames = theAttrNames.toArray(new String[theAttrNames.size()]);
                return output.getFeatureStore();
            }
            catch (UnsupportedOutputChannelException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            catch (GeoAlgorithmExecutionException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return null;
    }

    protected FeatureStore buildOutPutStoreFromUnion(FeatureType featureType1, FeatureType featureType2, int shapeType, String sextanteLayerName, String sextanteLayerLabel) {
        return this.buildOutPutStoreFromUnion(featureType1, featureType2, shapeType, sextanteLayerName, sextanteLayerLabel, null, null);
    }

    protected FeatureStore buildOutPutStoreFromUnion(FeatureType featureType1, FeatureType featureType2, int shapeType, String sextanteLayerName, String sextanteLayerLabel, String newField, Class<?> newFieldType) {
        NamesTranslator myNamesTranslator = this.getNamesTranslator();
        int sizeAux = 0;
        if (newField != null && newFieldType != null) {
            sizeAux = 1;
        }
        Class[] types = null;
        if (featureType1.getDefaultGeometryAttribute() != null) {
            this.attrNames = new String[featureType1.size() + featureType2.size() - 2 + sizeAux];
            types = new Class[featureType1.size() + featureType2.size() - 2 + sizeAux];
        } else {
            this.attrNames = new String[featureType1.size() + featureType2.size() + sizeAux];
            types = new Class[featureType1.size() + featureType2.size() + sizeAux];
        }
        int i = 0;
        Iterator it = featureType1.iterator();
        myNamesTranslator.clear();
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        while (it.hasNext()) {
            FeatureAttributeDescriptor attribute = (FeatureAttributeDescriptor)it.next();
            if (attribute.getDataType().getType() == 66) continue;
            this.attrNames[i] = attribute.getName();
            myNamesTranslator.addSource(attribute.getName());
            types[i] = attribute.getObjectClass();
            int size = attribute.getSize();
            if (attribute.getObjectClass().equals(BigDecimal.class)) {
                size = attribute.getPrecision();
            }
            sizes.add(size);
            ++i;
        }
        for (FeatureAttributeDescriptor attribute : featureType2) {
            String attrName;
            if (attribute.getDataType().getType() == 66) continue;
            this.attrNames[i] = attrName = this.checkAttrName(attribute.getName(), featureType1.size() - 1);
            myNamesTranslator.addSource(attribute.getName());
            types[i] = attribute.getObjectClass();
            int size = attribute.getSize();
            if (attribute.getObjectClass().equals(BigDecimal.class)) {
                size = attribute.getPrecision();
            }
            sizes.add(size);
            ++i;
        }
        if (newField != null && newFieldType != null) {
            this.attrNames[this.attrNames.length - 1] = newField;
            myNamesTranslator.addSource(newField);
            types[types.length - 1] = newFieldType;
            sizes.add(0);
        }
        int[] arrayOfSizes = sizes.stream().mapToInt(ii -> ii).toArray();
        try {
            IVectorLayer output = this.getNewVectorLayer(sextanteLayerLabel, sextanteLayerName, shapeType, types, myNamesTranslator.getTranslatedNamesAsArray(), arrayOfSizes);
            if (output != null) {
                return ((FlyrVectIVectorLayer)output).getFeatureStore();
            }
        }
        catch (UnsupportedOutputChannelException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (GeoAlgorithmExecutionException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return null;
    }

    protected String checkAttrName(String name, int size) {
        return this.checkAttrName(name, size, this.attrNames);
    }

    protected int getShapeType(FeatureStore storeLayer1) throws ReadException {
        FeatureType featureType;
        try {
            featureType = storeLayer1.getDefaultFeatureType();
        }
        catch (DataException e) {
            throw new ReadException(storeLayer1.getName(), (Throwable)e);
        }
        int indexGeom = featureType.getDefaultGeometryAttributeIndex();
        return featureType.getAttributeDescriptor(indexGeom).getGeomType().getType();
    }

    protected boolean isPoint(FeatureStore store) throws ReadException {
        return this.getShapeType(store) == 1 || this.getShapeType(store) == 7;
    }

    protected boolean isPolygon(FeatureStore store) throws ReadException {
        int type = this.getShapeType(store);
        return this.geomManager.isSubtype(3, type) || this.geomManager.isSubtype(9, type);
    }

    protected boolean isLine(FeatureStore store) throws ReadException {
        int type = this.getShapeType(store);
        return this.geomManager.isSubtype(2, type) || this.geomManager.isSubtype(8, type);
    }

    protected boolean isUndefined(FeatureStore store) throws ReadException {
        return this.getShapeType(store) == 0;
    }

    public String getGeoProcessName() {
        return this.getName();
    }

    protected void setProgressText(String sText) {
        super.setProgressText(sText);
        this.getStatus().message(sText);
    }

    public boolean setProgress(int iStep, int iTotalNumberOfSteps) {
        boolean cancelled = super.setProgress(iStep, iTotalNumberOfSteps);
        SimpleTaskStatusDelegated status = this.getStatus();
        status.setRangeOfValues(0L, iTotalNumberOfSteps);
        status.setCurValue(iStep);
        return cancelled || status.isCancelled();
    }

    protected SimpleTaskStatusDelegated getStatus() {
        return this.status;
    }

    public String getCommandLineName() {
        return "gvSIG-".concat(super.getCommandLineName());
    }

    public GeoProcessManager getGeoProcessManager() {
        return GeoProcessLocator.getGeoProcessManager();
    }

    protected String getTranslation(String label) {
        return this.getGeoProcessManager().getTranslation(label);
    }

    public Class<? extends GeoAlgorithmParametersPanel> getCustomParametersPanelClass() {
        return null;
    }

    public FeatureQuery getQueryFromAnalysisExtent(AnalysisExtent e, FeatureStore store) throws CreateEnvelopeException, DataException {
        Envelope analysisEnvelope = this.geomManager.createEnvelope(e.getXMin(), e.getYMin(), e.getXMax(), e.getYMax(), 0);
        FeatureQuery query = store.createFeatureQuery();
        Evaluator filter = SpatialEvaluatorsFactory.getInstance().intersects(analysisEnvelope, store.getDefaultFeatureType().getDefaultSRS(), store);
        query.setFilter(filter);
        return query;
    }

    public boolean existsOutPutFile(String resultLabel, int type) {
        String s;
        Output out;
        OutputObjectsSet ooSet = this.getOutputObjects();
        try {
            out = ooSet.getOutput(resultLabel);
        }
        catch (WrongOutputIDException e) {
            return false;
        }
        String string = s = out.getOutputChannel() != null ? out.getOutputChannel().getAsCommandLineParameter() : "";
        if (new File(s).exists()) {
            return true;
        }
        if (type == 0) {
            return new File(s + ".shp").exists();
        }
        if (type == 1) {
            return new File(s + ".tif").exists();
        }
        return false;
    }

    public String getOutPutFile(String resultLabel) {
        Output out;
        OutputObjectsSet ooSet = this.getOutputObjects();
        try {
            out = ooSet.getOutput(resultLabel);
        }
        catch (WrongOutputIDException e) {
            return null;
        }
        return out.getOutputChannel().getAsCommandLineParameter();
    }

    public ITaskMonitor getTaskMonitor() {
        return this.m_Task;
    }

    public void setTaskMonitor(ITaskMonitor task) {
        this.m_Task = task;
    }

    public NamesTranslator getNamesTranslator() {
        if (this.namesTranslator == null) {
            this.namesTranslator = NamesTranslator.createTrimTranslator((int)10);
            if (this.attrNames != null) {
                for (String attrName : this.attrNames) {
                    this.namesTranslator.addSource(attrName);
                }
            }
        }
        return this.namesTranslator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Envelope calculateEnvelope(IVectorLayer input, boolean selectedGeom) {
        Object fset = null;
        try {
            FeatureStore store = null;
            if (!(input instanceof FlyrVectIVectorLayer)) {
                Envelope envelope = null;
                return envelope;
            }
            store = ((FlyrVectIVectorLayer)input).getFeatureStore();
            fset = selectedGeom ? store.getFeatureSelectionQuietly() : store.getFeatureSet();
            Envelope envelope = null;
            for (Feature feature : fset) {
                Geometry geom = feature.getDefaultGeometry();
                if (geom == null) continue;
                if (envelope == null) {
                    envelope = geom.getEnvelope();
                    continue;
                }
                envelope.add(geom);
            }
            DisposableIterator disposableIterator = envelope;
            DisposeUtils.disposeQuietly((Disposable)fset);
            return disposableIterator;
        }
        catch (Exception ex) {
            Envelope envelope = null;
            return envelope;
        }
        finally {
            DisposeUtils.disposeQuietly(fset);
        }
    }

    protected Geometry calculateSurfaceUnion(IVectorLayer input, boolean selectedGeom) {
        return this.calculateUnion(input, selectedGeom, t -> GeometryUtils.isSubtype((int)3, (int)t.getType()) || GeometryUtils.isSubtype((int)9, (int)t.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Geometry calculateUnion(IVectorLayer input, boolean selectedGeom, Predicate<Geometry> filter) {
        Object fset = null;
        try {
            FeatureStore store = null;
            if (!(input instanceof FlyrVectIVectorLayer)) {
                Geometry geometry = null;
                return geometry;
            }
            store = ((FlyrVectIVectorLayer)input).getFeatureStore();
            fset = selectedGeom ? store.getFeatureSelectionQuietly() : store.getFeatureSet();
            Geometry union = null;
            for (Feature feature : fset) {
                Geometry geom = feature.getDefaultGeometry();
                if (!filter.test(geom) || geom == null) continue;
                if (union == null) {
                    union = geom.cloneGeometry();
                    continue;
                }
                union = union.union(geom);
            }
            DisposableIterator disposableIterator = union;
            DisposeUtils.disposeQuietly((Disposable)fset);
            return disposableIterator;
        }
        catch (Exception ex) {
            Geometry geometry = null;
            return geometry;
        }
        finally {
            DisposeUtils.disposeQuietly(fset);
        }
    }

    public boolean queryImprovePerformance(FeatureStore store) {
        FeatureStoreProviderFactory inFeatStoreProviderFactory = (FeatureStoreProviderFactory)store.getProviderFactory();
        return !StringUtils.equalsIgnoreCase((CharSequence)"Shape", (CharSequence)inFeatStoreProviderFactory.getName());
    }
}

