/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.core;

import es.unex.sextante.core.AbstractInputFactory;
import es.unex.sextante.core.NamedExtent;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IDataObject;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.view.DefaultViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayersIterator;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FLyrRasterIRasterLayer;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FileTools;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.geoprocess.lib.sextante.dataObjects.TableDocumentITable;
import org.gvsig.raster.fmap.layers.FLyrRaster;

public class DefaultInputFactory
extends AbstractInputFactory {
    public void createDataObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
            List views = project.getDocuments(ViewManager.TYPENAME);
            for (int i = 0; i < views.size(); ++i) {
                try {
                    DefaultViewDocument view = (DefaultViewDocument)views.get(i);
                    FLayers layers = view.getMapContext().getLayers();
                    LayersIterator iter = new LayersIterator((FLayer)layers);
                    while (iter.hasNext()) {
                        try {
                            FLayer layer = iter.nextLayer();
                            if (layer instanceof FLyrRaster) {
                                FLyrRasterIRasterLayer rasterLayer = new FLyrRasterIRasterLayer();
                                rasterLayer.create((FLyrRaster)layer);
                                rasterLayer.setViewName(view.getName());
                                list.add((Object)rasterLayer);
                                continue;
                            }
                            if (!(layer instanceof FLyrVect)) continue;
                            FlyrVectIVectorLayer vectorLayer = new FlyrVectIVectorLayer();
                            vectorLayer.create((FLyrVect)layer);
                            vectorLayer.setViewName(view.getName());
                            list.add((Object)vectorLayer);
                        }
                        catch (Throwable th) {
                            Sextante.addErrorToLog((Throwable)th);
                        }
                    }
                    continue;
                }
                catch (Throwable th) {
                    Sextante.addErrorToLog((Throwable)th);
                }
            }
            List tables = project.getDocuments(TableManager.TYPENAME);
            for (int i = 0; i < tables.size(); ++i) {
                try {
                    TableDocumentITable table = new TableDocumentITable();
                    table.create((TableDocument)tables.get(i));
                    list.add((Object)table);
                    continue;
                }
                catch (Throwable th) {
                    Sextante.addErrorToLog((Throwable)th);
                }
            }
        }
        catch (Throwable th) {
            Sextante.addErrorToLog((Throwable)th);
        }
        this.m_Objects = list.toArray(new IDataObject[list.size()]);
    }

    public NamedExtent[] getPredefinedExtents() {
        Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        NamedExtent[] ne = new NamedExtent[views.size()];
        for (int i = 0; i < views.size(); ++i) {
            DefaultViewDocument view = (DefaultViewDocument)views.get(i);
            Envelope envelope = view.getMapContext().getViewPort().getAdjustedEnvelope();
            if (envelope == null) continue;
            double x = envelope.getMinimum(0);
            double y = envelope.getMinimum(1);
            double width = envelope.getMaximum(0) - x;
            double height = envelope.getMaximum(1) - y;
            Rectangle2D.Double extent = new Rectangle2D.Double(x, y, width, height);
            String sName = view.getName();
            ne[i] = new NamedExtent(sName, (Rectangle2D)extent);
        }
        return ne;
    }

    public String[] getRasterLayerInputExtensions() {
        return FileTools.RASTER_EXT_IN;
    }

    public String[] get3DRasterLayerInputExtensions() {
        return FileTools.RASTER3D_EXT_IN;
    }

    public String[] getVectorLayerInputExtensions() {
        return FileTools.VECTOR_EXT_IN;
    }

    public String[] getTableInputExtensions() {
        return FileTools.TABLE_EXT;
    }

    public IDataObject openDataObjectFromFile(String sFilename) {
        Object object = FileTools.open(sFilename);
        if (object == null) {
            return null;
        }
        if (object instanceof FLyrRaster) {
            FLyrRasterIRasterLayer layer = new FLyrRasterIRasterLayer();
            layer.create((FLyrRaster)object);
            return layer;
        }
        if (object instanceof FLyrVect) {
            FlyrVectIVectorLayer layer = new FlyrVectIVectorLayer();
            layer.create((FLyrVect)object);
            return layer;
        }
        if (object instanceof I3DRasterLayer) {
            return (I3DRasterLayer)object;
        }
        return null;
    }

    public void close(String sName) {
        IDataObject dataObject = this.getInputFromName(sName);
        Object obj = dataObject.getBaseDataObject();
        if (obj instanceof FLayer) {
            DefaultInputFactory.removeLayer((FLayer)obj);
        } else {
            Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
            project.remove((Document)obj);
        }
    }

    private static void removeLayer(FLayer baseLayer) {
        Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (int i = 0; i < views.size(); ++i) {
            DefaultViewDocument view = (DefaultViewDocument)views.get(i);
            FLayers layers = view.getMapContext().getLayers();
            LayersIterator iter = new LayersIterator((FLayer)layers);
            while (iter.hasNext()) {
                FLayer layer = iter.nextLayer();
                if (!layer.equals(baseLayer)) continue;
                layers.removeLayer(baseLayer);
                return;
            }
        }
    }

    public I3DRasterLayer[] get3DRasterLayers() {
        return new I3DRasterLayer[0];
    }
}

