/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.dataObjects;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.AbstractVectorLayer;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.geoprocess.lib.sextante.dataObjects.DALIFeatureIterator;
import org.gvsig.geoprocess.lib.sextante.dataObjects.OutputParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlyrVectIVectorLayer
extends AbstractVectorLayer {
    private static final Logger logger = LoggerFactory.getLogger(FlyrVectIVectorLayer.class);
    private static final DataManager DATA_MANAGER = DALLocator.getDataManager();
    private final int PRECISION = 5;
    private FeatureStore featureStore = null;
    private IProjection m_Projection = null;
    private FeatureType featureType = null;
    private GeometryManager geometryManager = null;
    private FLyrVect m_Layer;
    private String m_sName;
    private IOutputChannel m_Channel;
    private String fileName = null;
    private List<String> names = new ArrayList<String>();
    private List<Class<?>> types = new ArrayList();
    private String viewName = null;
    private NamesTranslator namesTranslator;

    public FlyrVectIVectorLayer() {
        this.geometryManager = GeometryLocator.getGeometryManager();
    }

    public void create(String sName, Object inputParams, int iShapeType, Class[] types, String[] sFields, Object crs, int[] fieldSize) {
        this.create(sName, inputParams, iShapeType, types, sFields, crs, fieldSize, 4);
    }

    public void create(String sName, Object inputParams, int iShapeType, Class[] types, String[] sFields, Object crs, int[] fieldSize, int subtype) {
        try {
            this.m_sName = sName;
            this.m_Projection = (IProjection)crs;
            if (inputParams instanceof OutputParameters) {
                OutputParameters outputParam = (OutputParameters)inputParams;
                NewFeatureStoreParameters newParams = outputParam.getDataParameters();
                DataServerExplorer dataServerExplorer = outputParam.getExplorer();
                this.featureType = newParams.getDefaultFeatureType();
                this.loadFeatureType(sFields, types, iShapeType, crs, (EditableFeatureType)this.featureType, fieldSize, subtype);
                newParams.setDynValue("CRS", (Object)this.m_Projection);
                DATA_MANAGER.newStore(dataServerExplorer.getProviderName(), newParams.getDataStoreName(), (NewDataStoreParameters)newParams, true);
                this.featureStore = (FeatureStore)DATA_MANAGER.openStore(newParams.getDataStoreName(), (DataStoreParameters)newParams);
                this.initializeNamesAndTypes();
                this.featureStore.edit(2);
            }
            if (inputParams instanceof FilesystemStoreParameters) {
                String path = ((FilesystemStoreParameters)inputParams).getFile().getAbsolutePath();
                this.create(sName, path, iShapeType, types, sFields, crs, fieldSize);
            }
            if (inputParams instanceof String) {
                this.create(sName, (String)inputParams, iShapeType, types, sFields, crs, fieldSize);
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void create(String sName, String sFilename, int iShapeType, Class<?>[] types, String[] sFields, Object crs, int[] fieldSize) {
        this.create(sName, sFilename, iShapeType, types, sFields, crs, fieldSize, 4);
    }

    public void create(String sName, String sFilename, int iShapeType, Class<?>[] types, String[] sFields, Object crs, int[] fieldSize, int subtype) {
        try {
            this.m_sName = sName;
            this.m_Projection = (IProjection)crs;
            this.fileName = sFilename;
            FilesystemServerExplorerParameters explorerParams = (FilesystemServerExplorerParameters)DATA_MANAGER.createServerExplorerParameters("FilesystemExplorer");
            explorerParams.setRoot(new File(sFilename).getParent());
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)DATA_MANAGER.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)explorerParams);
            File file = new File(sFilename);
            NewFeatureStoreParameters newParams = (NewFeatureStoreParameters)explorer.getAddParameters(file);
            EditableFeatureType editableFeatureType = newParams.getDefaultFeatureType();
            this.featureType = editableFeatureType;
            this.loadFeatureType(sFields, types, iShapeType, crs, editableFeatureType, fieldSize, subtype);
            newParams.setDefaultFeatureType(this.featureType);
            newParams.setDynValue("crs", (Object)this.m_Projection);
            explorer.add(newParams.getDataStoreName(), (NewDataStoreParameters)newParams, true);
            DataStoreParameters params = DATA_MANAGER.createStoreParameters(newParams.getDataStoreName());
            params.setDynValue("shpfile", (Object)sFilename);
            params.setDynValue("crs", (Object)this.m_Projection);
            this.featureStore = (FeatureStore)DATA_MANAGER.openStore(params.getDataStoreName(), params);
            this.featureStore.edit(2);
            this.featureType = this.featureStore.getDefaultFeatureType();
            this.initializeNamesAndTypes();
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void loadFeatureType(String[] fields, Class<?>[] types, int shapeType, Object crs, EditableFeatureType featureType, int[] fieldSize, int subtype) {
        int[] iTypes = this.getTypes(types);
        this.namesTranslator = NamesTranslator.createTrimTranslator((int)10);
        this.namesTranslator.setSourceNames(fields);
        fields = this.namesTranslator.getTranslatedNamesAsArray();
        block6: for (int i = 0; i < fields.length; ++i) {
            switch (iTypes[i]) {
                case 66: {
                    continue block6;
                }
                case 19: {
                    featureType.add(fields[i], iTypes[i]).setAllowNull(true).setPrecision(20).setScale(3);
                    continue block6;
                }
                case 6: 
                case 7: {
                    featureType.add(fields[i], iTypes[i]).setAllowNull(true);
                    continue block6;
                }
                case 8: {
                    featureType.add(fields[i], iTypes[i]).setAllowNull(true).setSize(fieldSize[i]);
                    continue block6;
                }
                default: {
                    featureType.add(fields[i], iTypes[i]).setAllowNull(true);
                }
            }
        }
        FeatureAttributeDescriptor desc = featureType.getDefaultGeometryAttribute();
        if (desc == null) {
            this.addGeometryAttribute("GEOMETRY", shapeType, subtype, featureType);
            featureType.setDefaultGeometryAttributeName("GEOMETRY");
        }
    }

    private void addGeometryAttribute(String fieldName, int shapeType, int subtype, EditableFeatureType featureType) {
        try {
            GeometryType type = subtype == 4 ? this.geometryManager.getGeometryType(this.getgvSIGShapeType(shapeType), 0) : this.geometryManager.getGeometryType(this.getgvSIGShapeType(shapeType), subtype);
            featureType.add(fieldName, 66).setGeometryType(type);
        }
        catch (GeometryTypeNotSupportedException e) {
            throw new RuntimeException("Error getting geometry type with type = " + this.getgvSIGShapeType(shapeType) + ", subtype = " + 0, e);
        }
        catch (GeometryTypeNotValidException e) {
            throw new RuntimeException("Error getting geometry type with type = " + this.getgvSIGShapeType(shapeType) + ", subtype = " + 0, e);
        }
    }

    private int[] getTypes(Class<?>[] classes) {
        DataTypesManager typesManager = ToolsLocator.getDataTypesManager();
        int[] types = new int[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types[i] = typesManager.getDataType(classes[i]).getType();
        }
        return types;
    }

    public void create(FLyrVect layer) {
        this.m_Layer = layer;
        try {
            this.featureStore = layer.getFeatureStore();
            this.featureType = this.featureStore.getDefaultFeatureType();
            this.initializeNamesAndTypes();
            this.m_Projection = layer.getProjection();
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void open() {
        if (this.m_Layer == null) {
            try {
                this.m_Layer = (FLyrVect)MapContextLocator.getMapContextManager().createLayer(this.getFilename(), (DataStore)this.featureStore);
            }
            catch (LoadLayerException e) {
                Sextante.addErrorToLog((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void close() {
        if (this.m_Layer == null) {
            this.free();
        }
    }

    public int getDataTypeLength(int dataType) {
        switch (dataType) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return 20;
            }
            case -1: 
            case 1: 
            case 12: {
                return 254;
            }
            case 91: {
                return 8;
            }
            case -7: 
            case 16: {
                return 1;
            }
        }
        return 0;
    }

    public void addFeature(Geometry geom, Object[] values) {
        try {
            org.gvsig.fmap.geom.Geometry iGeo = null;
            GeometryOperationContext ctx = new GeometryOperationContext();
            ctx.setAttribute("JTSGeometry", (Object)geom);
            try {
                iGeo = (org.gvsig.fmap.geom.Geometry)this.geometryManager.invokeOperation("fromJTS", ctx);
            }
            catch (GeometryOperationNotSupportedException e) {
                Sextante.addErrorToLog((Throwable)e);
                return;
            }
            catch (GeometryOperationException e) {
                Sextante.addErrorToLog((Throwable)e);
                return;
            }
            EditableFeature ef = this.featureStore.createNewFeature();
            Iterator features = this.featureType.iterator();
            int i = 0;
            while (features.hasNext()) {
                FeatureAttributeDescriptor featureAttributeDescriptor = (FeatureAttributeDescriptor)features.next();
                if (!featureAttributeDescriptor.getName().equals(this.featureType.getDefaultGeometryAttributeName())) {
                    ef.set(featureAttributeDescriptor.getName(), values[i]);
                }
                ++i;
            }
            ef.set(this.featureType.getDefaultGeometryAttributeIndex(), (Object)iGeo);
            this.featureStore.insert(ef);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IFeatureIterator iterator() {
        if (this.m_Layer != null) {
            return new DALIFeatureIterator(this.m_Layer, this.getFilters());
        }
        return new DALIFeatureIterator();
    }

    public String getFieldName(int i) {
        if (this.names != null) {
            return this.names.get(i);
        }
        return null;
    }

    public Class<?> getFieldType(int i) {
        return this.types.get(i);
    }

    public int getFieldCount() {
        if (this.featureStore != null) {
            return this.names.size();
        }
        return 0;
    }

    public int getShapesCount() {
        if (this.featureStore != null) {
            try {
                FeatureSelection featureSelection = this.featureStore.getFeatureSelection();
                if (!featureSelection.isEmpty()) {
                    return (int)featureSelection.getSize();
                }
                return (int)this.featureStore.getFeatureSet().getSize();
            }
            catch (DataException e) {
                Sextante.addErrorToLog((Throwable)e);
                return 0;
            }
        }
        return 0;
    }

    public int getShapeType() {
        if (this.featureStore != null) {
            if (this.featureType == null) {
                logger.warn("The layer '" + this.getName() + "' not has a feature type.");
                return 0;
            }
            FeatureAttributeDescriptor attr = this.featureType.getDefaultGeometryAttribute();
            if (attr == null) {
                logger.warn("The layer '" + this.getName() + "' not has a geometry attribute.");
                return 0;
            }
            GeometryType geomType = attr.getGeomType();
            if (geomType == null) {
                logger.warn("The geometry field of layer '" + this.getName() + "' not has a geometry type.");
                return 0;
            }
            return this.getShapeTypeFromGvSIGShapeType(geomType.getType());
        }
        return 0;
    }

    private int getShapeTypeFromGvSIGShapeType(int shapeType) {
        if (this.geometryManager.isSubtype(3, shapeType)) {
            return 2;
        }
        if (this.geometryManager.isSubtype(9, shapeType)) {
            return 2;
        }
        if (this.geometryManager.isSubtype(2, shapeType)) {
            return 1;
        }
        if (this.geometryManager.isSubtype(8, shapeType)) {
            return 1;
        }
        if (this.geometryManager.isSubtype(1, shapeType)) {
            return 0;
        }
        if (this.geometryManager.isSubtype(7, shapeType)) {
            return 0;
        }
        try {
            throw new IllegalArgumentException();
        }
        catch (Exception ex) {
            logger.warn("Geometry type " + shapeType + " not supported, POLYGON type is assumed.");
            logger.debug("Geometry type " + shapeType + " not supported, POLYGON type is assumed.", (Throwable)ex);
            return 2;
        }
    }

    private int getgvSIGShapeType(int shapeType) {
        switch (shapeType) {
            case 2: {
                return 19;
            }
            case 1: {
                return 18;
            }
            case 0: {
                return 1;
            }
            case 6: {
                return 22;
            }
            case 5: {
                return 21;
            }
            case 4: {
                return 7;
            }
        }
        return 19;
    }

    public String getName() {
        if (this.m_Layer != null) {
            return this.m_Layer.getName();
        }
        return this.m_sName;
    }

    public void postProcess() {
        if (this.featureStore == null) {
            return;
        }
        try {
            if (this.featureStore.isEditing() || this.featureStore.isAppending()) {
                this.featureStore.finishEditing();
            }
            String name = this.featureStore.getProviderName();
            DataStoreParameters params = this.featureStore.getParameters();
            this.featureStore.dispose();
            this.featureStore = (FeatureStore)DALLocator.getDataManager().openStore(name, params);
            this.featureType = this.featureStore.getDefaultFeatureType();
        }
        catch (Exception e) {
            logger.warn("Can't execute postProcess on '" + this.getName() + "'.", (Throwable)e);
        }
    }

    public String getFilename() {
        if (this.fileName != null) {
            return this.fileName;
        }
        return this.m_sName;
    }

    public Object getCRS() {
        return this.m_Projection;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    public Object getBaseDataObject() {
        return this.m_Layer;
    }

    public void free() {
        if (this.featureStore != null) {
            if (this.featureStore.isEditing() || this.featureStore.isAppending()) {
                try {
                    this.featureStore.finishEditing();
                }
                catch (DataException ex) {
                    logger.warn("Can't free '" + this.getName() + "'.", (Throwable)ex);
                }
            }
            this.featureStore.dispose();
            this.featureStore = null;
        }
        if (this.m_Layer != null) {
            this.m_Layer.dispose();
            this.m_Layer = null;
        }
    }

    public IOutputChannel getOutputChannel() {
        if (this.featureStore != null) {
            DataStoreParameters dsp = this.featureStore.getParameters();
            if (dsp instanceof FilesystemStoreParameters) {
                String file = ((FilesystemStoreParameters)dsp).getFile().getAbsolutePath();
                return new FileOutputChannel(file);
            }
            return null;
        }
        return this.m_Channel;
    }

    public boolean canBeEdited() {
        return true;
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public Rectangle2D getFullExtent() {
        try {
            Envelope envelope = this.featureStore.getEnvelope();
            return new Rectangle2D.Double(envelope.getMinimum(0), envelope.getMinimum(1), envelope.getLength(0), envelope.getLength(1));
        }
        catch (DataException e) {
            return null;
        }
    }

    public String[] getFieldNames() {
        return this.names.toArray(new String[this.names.size()]);
    }

    public int getFieldIndexByName(String sFieldName) {
        String[] names = this.getFieldNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(sFieldName)) continue;
            return i;
        }
        return -1;
    }

    public Class<?>[] getFieldTypes() {
        return this.types.toArray(new Class[this.types.size()]);
    }

    private void initializeNamesAndTypes() {
        int defaultGeometryAttributeIndex = this.featureType.getDefaultGeometryAttributeIndex();
        for (int i = 0; i < this.featureType.size(); ++i) {
            if (i == defaultGeometryAttributeIndex) continue;
            FeatureAttributeDescriptor attributeDescriptor = this.featureType.getAttributeDescriptor(i);
            this.names.add(attributeDescriptor.getName());
            this.types.add(attributeDescriptor.getDataType().getDefaultClass());
        }
    }

    public int getSubType() throws ReadException {
        if (this.m_Layer != null) {
            return this.m_Layer.getGeometryType().getSubType();
        }
        return 4;
    }

    public int getFeatureIndexByFieldIndex(int i) {
        String name = this.names.get(i);
        FeatureAttributeDescriptor attrDesc = this.featureType.getAttributeDescriptor(name);
        int x = attrDesc.getIndex();
        return x;
    }

    public String getFeatureNameByFieldIndex(int i) {
        String name = this.names.get(i);
        FeatureAttributeDescriptor attrDesc = this.featureType.getAttributeDescriptor(name);
        return attrDesc.getName();
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getContextName() {
        return this.viewName;
    }

    public boolean hasSelection() {
        try {
            FeatureSelection featureSelection = this.featureStore.getFeatureSelection();
            return !featureSelection.isEmpty();
        }
        catch (DataException ex) {
            return false;
        }
    }
}

