/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaturalIntervalGenerator {
    private static final Logger logger = LoggerFactory.getLogger(NaturalIntervalGenerator.class);
    private String msFieldName;
    private int miNumIntervalosSolicitados;
    private int miNumIntervalosGenerados;
    private double[] mdaValoresRuptura;
    private double[] mdaValInit;
    private FeatureStore featureStore;

    public NaturalIntervalGenerator(FeatureStore fs, String field, int numIntervals) {
        this.featureStore = fs;
        this.msFieldName = field;
        this.miNumIntervalosSolicitados = numIntervals;
    }

    private boolean mbObtenerPosicionEnVector(List<udtDatosEstudio> rVectorDatos, double vdValorAInsertar, int[] rlIndiceCorrespondiente, boolean[] rbNuevoElemento) {
        double ldValorComparacion;
        rbNuevoElemento[0] = false;
        rlIndiceCorrespondiente[0] = -1;
        if (rVectorDatos.size() == 1 && rVectorDatos.get(0).Coincidencias == 0L) {
            rlIndiceCorrespondiente[0] = 0;
            rbNuevoElemento[0] = false;
            return true;
        }
        int llIndiceIzq = 0;
        int llIndiceDer = rVectorDatos.size() - 1;
        int llMedio = (llIndiceIzq + llIndiceDer) / 2;
        while (llIndiceIzq <= llIndiceDer) {
            ldValorComparacion = rVectorDatos.get(llMedio).Valor;
            if (vdValorAInsertar > ldValorComparacion) {
                llIndiceIzq = llMedio + 1;
                llMedio = (llIndiceIzq + llIndiceDer) / 2;
                continue;
            }
            if (vdValorAInsertar < ldValorComparacion) {
                llIndiceDer = llMedio - 1;
                llMedio = (llIndiceIzq + llIndiceDer) / 2;
                continue;
            }
            if (vdValorAInsertar != ldValorComparacion) continue;
            rlIndiceCorrespondiente[0] = llMedio;
            rbNuevoElemento[0] = false;
            return true;
        }
        rbNuevoElemento[0] = true;
        ldValorComparacion = rVectorDatos.get(llMedio).Valor;
        rlIndiceCorrespondiente[0] = vdValorAInsertar > ldValorComparacion ? llMedio + 1 : llMedio;
        return true;
    }

    public boolean generarIntervalos() throws DataException {
        int i;
        double[] ldMediaTotal = new double[1];
        double[] ldSDAM = new double[1];
        double[] ldUltimaGVF = new double[1];
        double[] ldNuevaGVF = new double[1];
        ArrayList<udtDatosEstudio> lVectorDatos = new ArrayList<udtDatosEstudio>();
        lVectorDatos.add(new udtDatosEstudio());
        if (!this.mbObtenerDatos(lVectorDatos, ldMediaTotal)) {
            return false;
        }
        logger.info("Analizando datos en generarIntervalos() ...");
        ldSDAM[0] = this.mbGetSumSquaredDeviationArrayMean(lVectorDatos, ldMediaTotal[0]);
        if (lVectorDatos.isEmpty()) {
            this.mdaValoresRuptura[0] = ((udtDatosEstudio)lVectorDatos.get(0)).Valor;
            this.mdaValInit[0] = ((udtDatosEstudio)lVectorDatos.get(0)).Valor;
            this.miNumIntervalosGenerados = 2;
            return true;
        }
        int liNumClasesReales = this.miNumIntervalosSolicitados > lVectorDatos.size() ? lVectorDatos.size() + 1 : this.miNumIntervalosSolicitados;
        int[] llaIndicesRupturas = new int[liNumClasesReales - 1];
        int llNumElementosPorClase = lVectorDatos.size() / liNumClasesReales;
        for (i = 0; i < llaIndicesRupturas.length; ++i) {
            llaIndicesRupturas[i] = i == 0 ? llNumElementosPorClase - 1 : llaIndicesRupturas[i - 1] + llNumElementosPorClase;
        }
        udtDatosClase[] ldaSDCM_Parciales = new udtDatosClase[llaIndicesRupturas.length + 1];
        udtDatosClase[] ldaSDCM_Validos = new udtDatosClase[llaIndicesRupturas.length + 1];
        if (llaIndicesRupturas.length == 0) {
            return true;
        }
        if (!this.mbCalcularGVF(lVectorDatos, ldaSDCM_Parciales, llaIndicesRupturas, ldSDAM[0], ldUltimaGVF, -1, false)) {
            this.miNumIntervalosSolicitados = lVectorDatos.size();
            this.generarIntervalos();
            return false;
        }
        ldaSDCM_Validos = this.getArray(ldaSDCM_Parciales);
        double ldGVFentrepasadas = ldUltimaGVF[0];
        for (long k = 1L; k <= 100L; ++k) {
            for (i = 0; i < llaIndicesRupturas.length; ++i) {
                boolean lbMoverADerecha = false;
                boolean lbMoverAIzquierda = false;
                int llIndiceRupturaOriginal = llaIndicesRupturas[i];
                ldaSDCM_Validos = this.getArray(ldaSDCM_Parciales);
                boolean lbIntentarDesplazamiento = false;
                if (i == llaIndicesRupturas.length - 1) {
                    if (llaIndicesRupturas[i] + 1 < lVectorDatos.size()) {
                        lbIntentarDesplazamiento = true;
                    }
                } else if (llaIndicesRupturas[i] + 1 < llaIndicesRupturas[i + 1]) {
                    lbIntentarDesplazamiento = true;
                }
                if (lbIntentarDesplazamiento) {
                    llaIndicesRupturas[i] = llaIndicesRupturas[i] + 1;
                    if (!this.mbCalcularGVF(lVectorDatos, ldaSDCM_Parciales, llaIndicesRupturas, ldSDAM[0], ldNuevaGVF, i, false)) {
                        return false;
                    }
                    if (ldNuevaGVF[0] > ldUltimaGVF[0]) {
                        lbMoverADerecha = true;
                        ldaSDCM_Validos = this.getArray(ldaSDCM_Parciales);
                    } else {
                        llaIndicesRupturas[i] = llIndiceRupturaOriginal;
                        ldaSDCM_Parciales = this.getArray(ldaSDCM_Validos);
                    }
                }
                lbIntentarDesplazamiento = false;
                if (!lbMoverADerecha) {
                    if (i == 0) {
                        if (llaIndicesRupturas[i] - 1 >= 0) {
                            lbIntentarDesplazamiento = true;
                        }
                    } else if (llaIndicesRupturas[i] - 1 > llaIndicesRupturas[i - 1]) {
                        lbIntentarDesplazamiento = true;
                    }
                }
                if (lbIntentarDesplazamiento) {
                    llaIndicesRupturas[i] = llaIndicesRupturas[i] - 1;
                    if (!this.mbCalcularGVF(lVectorDatos, ldaSDCM_Parciales, llaIndicesRupturas, ldSDAM[0], ldNuevaGVF, i, true)) {
                        return false;
                    }
                    if (ldNuevaGVF[0] > ldUltimaGVF[0]) {
                        lbMoverAIzquierda = true;
                        ldaSDCM_Validos = this.getArray(ldaSDCM_Parciales);
                    } else {
                        llaIndicesRupturas[i] = llIndiceRupturaOriginal;
                        ldaSDCM_Parciales = this.getArray(ldaSDCM_Validos);
                    }
                }
                lbIntentarDesplazamiento = false;
                if (!lbMoverAIzquierda && !lbMoverADerecha) continue;
                ldUltimaGVF[0] = ldNuevaGVF[0];
                boolean exit = false;
                while (!exit) {
                    llIndiceRupturaOriginal = llaIndicesRupturas[i];
                    if (lbMoverADerecha) {
                        if (i == llaIndicesRupturas.length - 1) {
                            if (llaIndicesRupturas[i] + 1 >= lVectorDatos.size()) {
                                exit = true;
                            }
                        } else if (llaIndicesRupturas[i] + 1 >= llaIndicesRupturas[i + 1]) {
                            exit = true;
                        }
                        llaIndicesRupturas[i] = llaIndicesRupturas[i] + 1;
                    } else {
                        if (i == 0) {
                            if (llaIndicesRupturas[i] - 1 < 0) {
                                exit = true;
                            }
                        } else if (llaIndicesRupturas[i] - 1 <= llaIndicesRupturas[i - 1]) {
                            exit = true;
                        }
                        llaIndicesRupturas[i] = llaIndicesRupturas[i] - 1;
                    }
                    if (!this.mbCalcularGVF(lVectorDatos, ldaSDCM_Parciales, llaIndicesRupturas, ldSDAM[0], ldNuevaGVF, i, lbMoverAIzquierda)) {
                        return false;
                    }
                    if (ldNuevaGVF[0] < ldUltimaGVF[0]) {
                        llaIndicesRupturas[i] = llIndiceRupturaOriginal;
                        ldaSDCM_Parciales = this.getArray(ldaSDCM_Validos);
                        exit = true;
                        continue;
                    }
                    ldUltimaGVF[0] = ldNuevaGVF[0];
                    ldaSDCM_Validos = this.getArray(ldaSDCM_Parciales);
                }
            }
            if (ldUltimaGVF[0] <= ldGVFentrepasadas) {
                i = 101;
            }
            ldGVFentrepasadas = ldUltimaGVF[0];
        }
        this.mdaValoresRuptura = new double[llaIndicesRupturas.length];
        this.mdaValInit = new double[llaIndicesRupturas.length];
        for (i = 0; i < this.mdaValoresRuptura.length; ++i) {
            if (llaIndicesRupturas[i] == -1) {
                llaIndicesRupturas[i] = 1;
            }
            if (llaIndicesRupturas[i] > lVectorDatos.size() - 1) {
                llaIndicesRupturas[i] = lVectorDatos.size() - 1;
            }
            this.mdaValoresRuptura[i] = ((udtDatosEstudio)lVectorDatos.get(llaIndicesRupturas[i])).Valor;
            this.mdaValInit[i] = llaIndicesRupturas[i] + 1 < lVectorDatos.size() ? ((udtDatosEstudio)lVectorDatos.get(llaIndicesRupturas[i] + 1)).Valor : ((udtDatosEstudio)lVectorDatos.get(llaIndicesRupturas[i])).Valor;
        }
        this.miNumIntervalosGenerados = this.mdaValoresRuptura.length + 2;
        ldaSDCM_Validos = null;
        ldaSDCM_Parciales = null;
        lVectorDatos = null;
        return true;
    }

    private udtDatosClase[] getArray(udtDatosClase[] array) {
        udtDatosClase[] aux = new udtDatosClase[array.length];
        for (int i = 0; i < array.length; ++i) {
            aux[i] = new udtDatosClase();
            aux[i].Media = array[i].Media;
            aux[i].NumElementos = array[i].NumElementos;
            aux[i].SDCM = array[i].SDCM;
            aux[i].SumaCuadradoTotal = array[i].SumaCuadradoTotal;
            aux[i].SumaTotal = array[i].SumaTotal;
        }
        return aux;
    }

    private double mbGetSumSquaredDeviationArrayMean(List<udtDatosEstudio> rVectorDatos, double vdMedia) {
        double rdSDAM = 0.0;
        for (int i = 0; i < rVectorDatos.size(); ++i) {
            rdSDAM += Math.pow(rVectorDatos.get(i).Valor - vdMedia, 2.0) * (double)rVectorDatos.get(i).Coincidencias;
        }
        return rdSDAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mbObtenerDatos(List<udtDatosEstudio> rVectorDatos, double[] rdMediaTotal) throws DataException {
        long llRecordCount = 0L;
        int[] llIndice = new int[1];
        boolean[] lbNuevoElemento = new boolean[1];
        if (!this.gbExisteCampoEnRegistro(this.featureStore, this.msFieldName)) {
            if (this.msFieldName == "") {
                System.out.println("No se ha establecido el nombre del campo origen!");
            } else {
                System.out.println("El campo '" + this.msFieldName + "' no pertence a la capa!");
            }
            return false;
        }
        FeatureQuery featureQuery = this.featureStore.createFeatureQuery();
        featureQuery.setAttributeNames(new String[]{this.msFieldName});
        FeatureSet set = null;
        DisposableIterator iterator = null;
        try {
            set = this.featureStore.getFeatureSet(featureQuery);
            iterator = set.fastIterator();
            while (iterator.hasNext()) {
                double ldValor;
                Feature feature = (Feature)iterator.next();
                try {
                    ldValor = feature.getDouble(0);
                    ++llRecordCount;
                }
                catch (Exception e) {
                    continue;
                }
                rdMediaTotal[0] = rdMediaTotal[0] + ldValor;
                if (!this.mbObtenerPosicionEnVector(rVectorDatos, ldValor, llIndice, lbNuevoElemento)) {
                    boolean e = false;
                    return e;
                }
                if (!lbNuevoElemento[0]) {
                    if (llIndice[0] < 0 || llIndice[0] > rVectorDatos.size()) {
                        System.out.println("\u00ef\u00bf\u00bdndice incorrecto!");
                        boolean e = false;
                        return e;
                    }
                    rVectorDatos.get(llIndice[0]).Valor = ldValor;
                    rVectorDatos.get(llIndice[0]).Coincidencias = rVectorDatos.get(llIndice[0]).Coincidencias + 1L;
                    continue;
                }
                udtDatosEstudio udt = new udtDatosEstudio();
                udt.Valor = ldValor;
                udt.Coincidencias = 1L;
                rVectorDatos.add(llIndice[0], udt);
            }
            rdMediaTotal[0] = rdMediaTotal[0] / (double)llRecordCount;
            boolean bl = true;
            return bl;
        }
        finally {
            if (iterator != null) {
                iterator.dispose();
            }
            if (set != null) {
                set.dispose();
            }
        }
    }

    private boolean gbExisteCampoEnRegistro(FeatureStore fs, String msFieldName2) throws DataException {
        return ((FeatureType)fs.getFeatureTypes().get(0)).getIndex(msFieldName2) != -1;
    }

    private boolean mbCalcularGVF(List<udtDatosEstudio> rVectorDatos, udtDatosClase[] raClases, int[] rlaIndicesRuptura, double vdSDAM, double[] rdGVF, int vlIndiceRupturaActual, boolean vbDesplazAIzquierda) {
        int i;
        if (vlIndiceRupturaActual == -1) {
            for (i = 0; i < rlaIndicesRuptura.length; ++i) {
                if (!(i == 0 ? !this.mbGetDatosClase(rVectorDatos, 0, rlaIndicesRuptura[i], raClases, i) : !this.mbGetDatosClase(rVectorDatos, rlaIndicesRuptura[i - 1] + 1, rlaIndicesRuptura[i], raClases, i))) continue;
                return false;
            }
            if (!this.mbGetDatosClase(rVectorDatos, rlaIndicesRuptura[rlaIndicesRuptura.length - 1] + 1, rVectorDatos.size() - 1, raClases, raClases.length - 1)) {
                return false;
            }
        } else {
            i = vlIndiceRupturaActual;
            if (vbDesplazAIzquierda) {
                if (!this.mbRecalcularDatosClase(raClases, i, rVectorDatos, rlaIndicesRuptura[i] + 1, vdSDAM, false)) {
                    return false;
                }
                if (!this.mbRecalcularDatosClase(raClases, i + 1, rVectorDatos, rlaIndicesRuptura[i] + 1, vdSDAM, true)) {
                    return false;
                }
            } else {
                if (!this.mbRecalcularDatosClase(raClases, i, rVectorDatos, rlaIndicesRuptura[i], vdSDAM, true)) {
                    return false;
                }
                if (!this.mbRecalcularDatosClase(raClases, i + 1, rVectorDatos, rlaIndicesRuptura[i], vdSDAM, false)) {
                    return false;
                }
            }
        }
        double ldSDCM_aux = 0.0;
        for (i = 0; i < raClases.length; ++i) {
            ldSDCM_aux += raClases[i].SDCM;
        }
        rdGVF[0] = (vdSDAM - ldSDCM_aux) / vdSDAM;
        return true;
    }

    private boolean mbGetDatosClase(List<udtDatosEstudio> rVectorDatos, int vlLimiteInf, int vlLimiteSup, udtDatosClase[] rClase, int numClas) {
        if (vlLimiteInf < 0) {
            return false;
        }
        if (vlLimiteSup > rVectorDatos.size()) {
            return false;
        }
        if (vlLimiteSup < vlLimiteInf) {
            return false;
        }
        rClase[numClas] = new udtDatosClase();
        for (int i = vlLimiteInf; i < vlLimiteSup + 1; ++i) {
            rClase[numClas].NumElementos = rClase[numClas].NumElementos + rVectorDatos.get(i).Coincidencias;
            rClase[numClas].SumaTotal = rClase[numClas].SumaTotal + rVectorDatos.get(i).Valor * (double)rVectorDatos.get(i).Coincidencias;
            rClase[numClas].SumaCuadradoTotal = rClase[numClas].SumaCuadradoTotal + Math.pow(rVectorDatos.get(i).Valor * (double)rVectorDatos.get(i).Coincidencias, 2.0);
        }
        rClase[numClas].Media = rClase[numClas].SumaTotal / (double)rClase[numClas].NumElementos;
        rClase[numClas].SDCM = rClase[numClas].SumaCuadradoTotal - 2.0 * rClase[numClas].Media * rClase[numClas].SumaTotal + (double)rClase[numClas].NumElementos * Math.pow(rClase[numClas].Media, 2.0);
        return true;
    }

    private boolean mbRecalcularDatosClase(udtDatosClase[] rClase, int i, List<udtDatosEstudio> rVectorDatos, int vlIndiceElemento, double vdSDAM, boolean vbAnyadir) {
        try {
            if (vlIndiceElemento > rVectorDatos.size() - 1) {
                return true;
            }
            double ldValor = rVectorDatos.get(vlIndiceElemento).Valor;
            long llNumCoincidencias = rVectorDatos.get(vlIndiceElemento).Coincidencias;
            if (vbAnyadir) {
                rClase[i].SumaTotal = rClase[i].SumaTotal + ldValor * (double)llNumCoincidencias;
                rClase[i].SumaCuadradoTotal = rClase[i].SumaCuadradoTotal + Math.pow(ldValor * (double)llNumCoincidencias, 2.0);
                rClase[i].NumElementos = rClase[i].NumElementos + llNumCoincidencias;
            } else {
                rClase[i].SumaTotal = rClase[i].SumaTotal - ldValor * (double)llNumCoincidencias;
                rClase[i].SumaCuadradoTotal = rClase[i].SumaCuadradoTotal - Math.pow(ldValor * (double)llNumCoincidencias, 2.0);
                rClase[i].NumElementos = rClase[i].NumElementos - llNumCoincidencias;
            }
            if (rClase[i].NumElementos <= 0L) {
                rClase[i].NumElementos = 1L;
            }
            rClase[i].Media = rClase[i].SumaTotal / (double)rClase[i].NumElementos;
            rClase[i].SDCM = rClase[i].SumaCuadradoTotal - 2.0 * rClase[i].Media * rClase[i].SumaTotal + (double)rClase[i].NumElementos * Math.pow(rClase[i].Media, 2.0);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public double getValorRuptura(int viIndice) {
        return this.mdaValoresRuptura[viIndice];
    }

    public double getValInit(int index) {
        return this.mdaValInit[index];
    }

    public int getNumIntervals() {
        return this.miNumIntervalosGenerados;
    }

    private class udtDatosClase {
        private long NumElementos;
        private double Media;
        private double SumaTotal;
        private double SumaCuadradoTotal;
        private double SDCM;

        private udtDatosClase() {
        }
    }

    private class udtDatosEstudio {
        private double Valor;
        private long Coincidencias;

        private udtDatosEstudio() {
        }
    }
}

