/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.dispose.DisposableIterator;

public class QuantileIntervalGenerator {
    private FeatureStore featureStore;
    private String msFieldName;
    private int miNumIntervalosSolicitados;
    private double[] mdaValoresRuptura;
    private double[] mdaValInit;
    private int num = 0;

    public QuantileIntervalGenerator(FeatureStore fs, String field, int numIntervals) {
        this.featureStore = fs;
        this.msFieldName = field;
        this.miNumIntervalosSolicitados = numIntervals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generarIntervalos() throws DataException {
        ArrayList<Number> ordenadas = new ArrayList<Number>();
        ArrayList<Integer> coincidencias = new ArrayList<Integer>();
        this.mdaValoresRuptura = new double[this.miNumIntervalosSolicitados - 1];
        this.mdaValInit = new double[this.miNumIntervalosSolicitados - 1];
        FeatureQuery featureQuery = this.featureStore.createFeatureQuery();
        featureQuery.setAttributeNames(new String[]{this.msFieldName});
        FeatureSet set = null;
        DisposableIterator iterator = null;
        try {
            set = this.featureStore.getFeatureSet(featureQuery);
            iterator = set.fastIterator();
            long rowCount = 0L;
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                this.insertarEnVector(ordenadas, coincidencias, feature.get(0));
                ++rowCount;
            }
            int index = 0;
            int posj = 0;
            block4: for (int i = 1; i < this.miNumIntervalosSolicitados; ++i) {
                long x = (long)i * rowCount / (long)this.miNumIntervalosSolicitados;
                for (int j = posj; j < ordenadas.size(); ++j) {
                    int auxcoin = (Integer)coincidencias.get(j);
                    if (x > (long)(index += auxcoin)) continue;
                    this.mdaValoresRuptura[i - 1] = this.getValue(ordenadas.get(j));
                    posj = j + 1;
                    this.mdaValInit[i - 1] = posj < ordenadas.size() ? this.getValue(ordenadas.get(posj)) : this.getValue(ordenadas.get(j));
                    ++this.num;
                    continue block4;
                }
            }
        }
        finally {
            if (iterator != null) {
                iterator.dispose();
            }
            if (set != null) {
                set.dispose();
            }
        }
    }

    private void insertarEnVector(List<Number> rVectorDatos, List<Integer> coincidencia, Object vdValorAInsertar) {
        double ldValorComparacion;
        int indice = -1;
        double valorAInsertar = this.getValue(vdValorAInsertar);
        if (rVectorDatos.size() == 0) {
            rVectorDatos.add((Number)vdValorAInsertar);
            coincidencia.add(new Integer(1));
            return;
        }
        int llIndiceIzq = 0;
        int llIndiceDer = rVectorDatos.size() - 1;
        int llMedio = (llIndiceIzq + llIndiceDer) / 2;
        while (llIndiceIzq <= llIndiceDer) {
            ldValorComparacion = this.getValue(rVectorDatos.get(llMedio));
            if (valorAInsertar > ldValorComparacion) {
                llIndiceIzq = llMedio + 1;
                llMedio = (llIndiceIzq + llIndiceDer) / 2;
                continue;
            }
            if (valorAInsertar < ldValorComparacion) {
                llIndiceDer = llMedio - 1;
                llMedio = (llIndiceIzq + llIndiceDer) / 2;
                continue;
            }
            if (valorAInsertar != ldValorComparacion) continue;
            indice = llMedio;
            int index = rVectorDatos.indexOf(vdValorAInsertar);
            int coin = coincidencia.get(index) + 1;
            coincidencia.remove(index);
            coincidencia.add(index, new Integer(coin));
            return;
        }
        ldValorComparacion = this.getValue(rVectorDatos.get(llMedio));
        indice = valorAInsertar > ldValorComparacion ? llMedio + 1 : llMedio;
        rVectorDatos.add(indice, (Number)vdValorAInsertar);
        coincidencia.add(indice, new Integer(1));
    }

    private double getValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    public double getValRuptura(int index) {
        return this.mdaValoresRuptura[index];
    }

    public double getValInit(int index) {
        return this.mdaValInit[index];
    }

    public int getNumIntervalGen() {
        return this.num + 1;
    }
}

