/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import org.apache.batik.ext.awt.geom.DefaultPathLength;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.PathLength;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextPath {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(GeometryManager.class);
    public static final int NO_POS = Integer.MIN_VALUE;
    public static final int DEFAULT_WORD_SPACING = Integer.MIN_VALUE;
    private double[][] posList;
    private float characterSpacing;
    private float wordSpacing;
    private float margin;
    private boolean rightToLeft;
    private int numGlyphs = 0;
    private float characterWidth;
    private char[] wordSeparators = new char[]{' '};

    public TextPath(Graphics2D g, Geometry path, char[] text, Font font, float characterSpacing, float characterWidth, boolean kerning, float leading, int alignment, float wordSpacing, float margin, boolean rightToLeft) {
        if (alignment != 94 && alignment != 95 && alignment != 96 && alignment != 97) {
            throw new IllegalArgumentException(Messages.getText((String)"invalid_value_for") + ": " + Messages.getText((String)"alignment") + " ( " + alignment + ")");
        }
        this.characterWidth = characterWidth;
        this.characterSpacing = characterSpacing;
        this.wordSpacing = wordSpacing;
        this.margin = margin;
        this.rightToLeft = rightToLeft;
        FontRenderContext frc = g.getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, text);
        try {
            DefaultPathLength pl = new DefaultPathLength(this.softenShape(path, gv).getShape());
            if (alignment == 95) {
                this.posList = this.computeAtRight(gv, pl, text);
            } else if (alignment == 96) {
                this.computeAtMiddle(frc, text, font, pl);
            } else {
                this.posList = this.computeAtLeft(gv, pl, text);
            }
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating a curve", (Throwable)e);
        }
    }

    protected Geometry softenShape(Geometry shape, GlyphVector gv) throws CreateGeometryException {
        float interval = (float)gv.getVisualBounds().getWidth() / (float)(gv.getNumGlyphs() * 3);
        DefaultPathLength pl = new DefaultPathLength(shape.getShape());
        if (pl.lengthOfPath() == 0.0f) {
            return shape;
        }
        GeneralPathX correctedPath = new GeneralPathX();
        int controlPoints = 16;
        double[][] points = new double[controlPoints][2];
        double xsum = 0.0;
        double ysum = 0.0;
        int nextPos = 0;
        boolean bufferComplete = false;
        boolean movedTo = false;
        for (float curPos = 0.0f; curPos < pl.lengthOfPath(); curPos += interval) {
            double prevX = points[nextPos][0];
            double prevY = points[nextPos][1];
            Point2D point = pl.pointAtLength(curPos);
            if (!movedTo) {
                correctedPath.moveTo(point.getX(), point.getY());
                movedTo = true;
            }
            points[nextPos][0] = point.getX();
            points[nextPos][1] = point.getY();
            if (!bufferComplete) {
                xsum += points[nextPos][0];
                ysum += points[nextPos][1];
                if (++nextPos != controlPoints) continue;
                nextPos = 0;
                bufferComplete = true;
                double auxX2 = xsum / (double)controlPoints;
                double auxY2 = ysum / (double)controlPoints;
                for (int i = 1; i < controlPoints / 2 - 1; ++i) {
                    double auxX = (points[0][0] + points[i][0] + auxX2) / 3.0;
                    double auxY = (points[0][1] + points[i][1] + auxY2) / 3.0;
                    correctedPath.lineTo(auxX, auxY);
                }
                correctedPath.lineTo(auxX2, auxY2);
                continue;
            }
            xsum = xsum - prevX + points[nextPos][0];
            ysum = ysum - prevY + points[nextPos][1];
            if (!movedTo) {
                correctedPath.moveTo(xsum / (double)controlPoints, ysum / (double)controlPoints);
                movedTo = true;
            } else {
                correctedPath.lineTo(xsum / (double)controlPoints, ysum / (double)controlPoints);
            }
            nextPos = (nextPos + 1) % controlPoints;
        }
        Point2D endPoint = pl.pointAtLength(pl.lengthOfPath());
        double endPointX = endPoint.getX();
        double endPointY = endPoint.getY();
        if (bufferComplete) {
            double auxX2 = xsum / (double)controlPoints;
            double auxY2 = ysum / (double)controlPoints;
            nextPos = (nextPos + controlPoints / 2) % controlPoints;
            for (int i = 0; i < controlPoints / 2 - 1; ++i) {
                double auxX = (auxX2 + points[nextPos][0] + endPointX) / 3.0;
                double auxY = (auxY2 + points[nextPos][1] + endPointY) / 3.0;
                correctedPath.lineTo(auxX, auxY);
                nextPos = (nextPos + 1) % controlPoints;
            }
        }
        correctedPath.lineTo(endPointX, endPointY);
        return geomManager.createCurve(new GeneralPathX(correctedPath.getPathIterator(null)), 0);
    }

    private double[][] computeAtRight(GlyphVector gv, PathLength pl, char[] text) {
        int i;
        this.numGlyphs = gv.getNumGlyphs();
        double[][] pos = new double[this.numGlyphs][3];
        float[] charAnchors = new float[this.numGlyphs];
        float lengthOfPath = pl.lengthOfPath();
        float charDistance = lengthOfPath - this.margin;
        int glyphsConsumed = this.numGlyphs - 1;
        float previousAngle = 0.0f;
        float angle = 0.0f;
        boolean correction = true;
        float charWidth = this.characterWidth;
        for (i = this.numGlyphs - 1; i >= 0; --i) {
            if (correction && charDistance >= 0.0f) {
                previousAngle = angle;
                angle = pl.angleAtLength(charDistance);
                if (i < this.numGlyphs - 1) {
                    float auxAngle;
                    float auxDistance;
                    int turn = GeometryUtils.angleGetTurn((double)previousAngle, (double)angle);
                    if (turn == 1) {
                        auxDistance = charDistance - (float)((double)(charWidth * 2.5f) * GeometryUtils.angleDiff((double)previousAngle, (double)angle) / Math.PI);
                        auxAngle = pl.angleAtLength(auxDistance);
                        if (GeometryUtils.angleGetTurn((double)previousAngle, (double)auxAngle) == 1) {
                            charDistance = auxDistance;
                            angle = auxAngle;
                        }
                    } else if (turn == -1 && GeometryUtils.angleGetTurn((double)previousAngle, (double)(auxAngle = pl.angleAtLength(auxDistance = charDistance + (float)((double)(charWidth * 0.9f) * GeometryUtils.angleDiff((double)previousAngle, (double)angle) / Math.PI)))) == -1) {
                        charDistance = auxDistance;
                        angle = auxAngle;
                    }
                }
            }
            charWidth = this.wordSpacing != -2.1474836E9f && TextPath.isWordSeparator(text[gv.getGlyphCharIndex(glyphsConsumed)], this.wordSeparators) ? this.wordSpacing : Math.max(gv.getGlyphMetrics(glyphsConsumed).getAdvance(), this.characterWidth);
            charAnchors[glyphsConsumed] = charDistance -= charWidth;
            charDistance -= this.characterSpacing;
            --glyphsConsumed;
        }
        for (i = this.numGlyphs - 1; i >= 0; --i) {
            float anchor = this.rightToLeft ? charAnchors[charAnchors.length - 1 - i] : charAnchors[i];
            Point2D p = pl.pointAtLength(anchor);
            if (p == null) {
                if (i < this.numGlyphs - 1) {
                    pos[i][0] = pos[i + 1][0] + (double)(charAnchors[i] - charAnchors[i + 1]) * Math.cos(pos[i + 1][2]);
                    pos[i][1] = pos[i + 1][1] + (double)(charAnchors[i] - charAnchors[i + 1]) * Math.sin(pos[i + 1][2]);
                    pos[i][2] = pos[i + 1][2];
                    continue;
                }
                pos[i][0] = -2.147483648E9;
                pos[i][1] = -2.147483648E9;
                continue;
            }
            pos[i][0] = p.getX();
            pos[i][1] = p.getY();
            pos[i][2] = pl.angleAtLength(anchor);
        }
        return pos;
    }

    private double[][] computeAtLeft(GlyphVector gv, PathLength pl, char[] text) {
        int i;
        this.numGlyphs = gv.getNumGlyphs();
        double[][] pos = new double[this.numGlyphs][3];
        float[] charAnchors = new float[this.numGlyphs];
        float[] charWidths = new float[this.numGlyphs];
        float lengthOfPath = pl.lengthOfPath();
        float charDistance = this.margin;
        int glyphsConsumed = 0;
        float previousAngle = 0.0f;
        float angle = 0.0f;
        boolean correction = true;
        float charWidth = this.characterWidth;
        for (i = 0; i < gv.getNumGlyphs(); ++i) {
            if (correction && charDistance <= lengthOfPath) {
                previousAngle = angle;
                angle = pl.angleAtLength(charDistance);
                if (i > 0) {
                    float auxAngle;
                    float auxDistance;
                    int turn = GeometryUtils.angleGetTurn((double)previousAngle, (double)angle);
                    if (turn == 1) {
                        auxDistance = charDistance - (float)((double)charWidth * 0.9 * GeometryUtils.angleDiff((double)previousAngle, (double)angle) / Math.PI);
                        auxAngle = pl.angleAtLength(auxDistance);
                        if (GeometryUtils.angleGetTurn((double)previousAngle, (double)auxAngle) == 1) {
                            charDistance = auxDistance;
                            angle = auxAngle;
                        }
                    } else if (turn == -1 && GeometryUtils.angleGetTurn((double)previousAngle, (double)(auxAngle = pl.angleAtLength(auxDistance = charDistance + (float)((double)charWidth * 2.5 * GeometryUtils.angleDiff((double)previousAngle, (double)angle) / Math.PI)))) == -1) {
                        charDistance = auxDistance;
                        angle = auxAngle;
                    }
                }
            }
            charWidth = this.wordSpacing != -2.1474836E9f && TextPath.isWordSeparator(text[gv.getGlyphCharIndex(glyphsConsumed)], this.wordSeparators) ? this.wordSpacing : Math.max(gv.getGlyphMetrics(glyphsConsumed).getAdvance(), this.characterWidth);
            charWidths[glyphsConsumed] = charWidth;
            charAnchors[glyphsConsumed] = charDistance;
            charDistance += charWidth;
            charDistance += this.characterSpacing;
            ++glyphsConsumed;
        }
        for (i = 0; i < charAnchors.length; ++i) {
            float anchor = this.rightToLeft ? charAnchors[charAnchors.length - 1 - i] : charAnchors[i];
            Point2D p = pl.pointAtLength(anchor);
            if (p == null) {
                if (i > 0) {
                    pos[i][0] = pos[i - 1][0] + (double)(charAnchors[i] - charAnchors[i - 1]) * Math.cos(pos[i - 1][2]);
                    pos[i][1] = pos[i - 1][1] + (double)(charAnchors[i] - charAnchors[i - 1]) * Math.sin(pos[i - 1][2]);
                    pos[i][2] = pos[i - 1][2];
                    continue;
                }
                pos[i][0] = -2.147483648E9;
                pos[i][1] = -2.147483648E9;
                continue;
            }
            pos[i][2] = pl.angleAtLength(anchor);
            pos[i][0] = p.getX();
            pos[i][1] = p.getY();
        }
        return pos;
    }

    private void computeAtMiddle(FontRenderContext frc, char[] text, Font font, PathLength pl) {
        float halfLength;
        if (text.length == 0) {
            return;
        }
        int middleChar = (text.length - 1) / 2;
        char[] text1 = new char[middleChar + 1];
        char[] text2 = new char[text.length - text1.length];
        System.arraycopy(text, 0, text1, 0, text1.length);
        System.arraycopy(text, text1.length, text2, 0, text2.length);
        this.margin = halfLength = pl.lengthOfPath() / 2.0f;
        GlyphVector gv = font.createGlyphVector(frc, text1);
        double[][] pos1 = this.computeAtRight(gv, pl, text1);
        int glyphCount = this.numGlyphs;
        gv = font.createGlyphVector(frc, text2);
        this.margin = halfLength + this.characterSpacing;
        double[][] pos2 = this.computeAtLeft(gv, pl, text2);
        this.numGlyphs += glyphCount;
        this.posList = new double[pos1.length + pos2.length][3];
        System.arraycopy(pos1, 0, this.posList, 0, pos1.length);
        System.arraycopy(pos2, 0, this.posList, pos1.length, pos2.length);
    }

    public double[] nextPosForGlyph(int glyphIndex) {
        return this.posList[glyphIndex];
    }

    public int getGlyphCount() {
        return this.numGlyphs;
    }

    protected static boolean isWordSeparator(char c, char[] wordSeparators) {
        for (int i = 0; i < wordSeparators.length; ++i) {
            char separator = wordSeparators[i];
            if (c != separator) continue;
            return true;
        }
        return false;
    }
}

