/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.IMultiLayerLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl.AbstractLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ILineStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.TransparencySupport;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;

public class MultiLayerLineSymbol
extends AbstractLineSymbol
implements ILineSymbol,
IMultiLayerSymbol,
IMultiLayerLineSymbol {
    public static final String MULTILAYER_LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME = "MultiLayerLineSymbol";
    private static final String FIELD_LAYERS = "layers";
    private ISymbol[] layers = new ISymbol[0];
    private MultiLayerLineSymbol selectionSymbol;
    private double lineWidth;

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public ILineStyle getLineStyle() {
        return null;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double width) {
        if (width > 0.0 && width != this.lineWidth) {
            this.lineWidth = width;
            double scaleFactor = width / this.lineWidth;
            for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
                if (!(this.layers[i] instanceof ILineSymbol)) continue;
                ILineSymbol layer = (ILineSymbol)this.layers[i];
                layer.setLineWidth(layer.getLineWidth() * scaleFactor);
            }
        }
    }

    @Override
    public void setLineColor(Color color) {
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (!(this.layers[i] instanceof ILineSymbol)) continue;
            ILineSymbol layer = (ILineSymbol)this.layers[i];
            layer.setLineColor(color);
        }
    }

    @Override
    public void setLineStyle(ILineStyle lineStyle) {
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (!(this.layers[i] instanceof ILineSymbol)) continue;
            ILineSymbol layer = (ILineSymbol)this.layers[i];
            layer.setLineStyle(lineStyle);
        }
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        for (int i = 0; !(cancel != null && cancel.isCanceled() || this.layers == null || i >= this.layers.length); ++i) {
            ISymbol layer = this.layers[i];
            if (layer == null) continue;
            if (layer instanceof CartographicSupport) {
                ((CartographicSupport)layer).setCartographicContext(this.getCartographicContext());
            }
            if (layer instanceof ISymbol_v2) {
                ((ISymbol_v2)layer).draw(g, affineTransform, geom, f, cancel, r);
                continue;
            }
            layer.draw(g, affineTransform, geom, f, cancel);
        }
    }

    public ISymbol getSymbolForSelection() {
        if (this.selectionSymbol == null) {
            this.selectionSymbol = new MultiLayerLineSymbol();
            this.selectionSymbol.setDescription(this.getDescription());
            for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
                this.selectionSymbol.addLayer(this.layers[i].getSymbolForSelection());
            }
        } else {
            for (int i = 0; i < this.selectionSymbol.getLayerCount(); ++i) {
                this.selectionSymbol.setLayer(i, this.selectionSymbol.getLayer(i).getSymbolForSelection());
            }
        }
        if (this.selectionSymbol instanceof CartographicSupport) {
            this.selectionSymbol.setUnit(this.getUnit());
        }
        return this.selectionSymbol;
    }

    @Override
    public boolean isSuitableFor(Geometry geom) {
        return geom.getGeometryType().isTypeOf(2);
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes properties) {
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            this.layers[i].print(g, at, geom, properties);
        }
    }

    public void setLayer(int index, ISymbol layer) throws IndexOutOfBoundsException {
        this.layers[index] = layer;
    }

    public void swapLayers(int index1, int index2) {
        ISymbol aux1 = this.getLayer(index1);
        ISymbol aux2 = this.getLayer(index2);
        this.layers[index2] = aux1;
        this.layers[index1] = aux2;
    }

    public ISymbol getLayer(int layerIndex) {
        return this.layers[layerIndex];
    }

    public int getLayerCount() {
        return this.layers.length;
    }

    public void addLayer(ISymbol newLayer) {
        this.addLayer(newLayer, this.layers.length);
    }

    public void addLayer(ISymbol newLayer, int layerIndex) throws IndexOutOfBoundsException {
        ILineSymbol newLine;
        ILineSymbol iLineSymbol = newLine = newLayer instanceof ILineSymbol ? (ILineSymbol)newLayer : null;
        if (newLayer == null) {
            return;
        }
        if (!(newLayer instanceof ISymbol_v2)) {
            LOGGER.info("Symbol " + newLayer.getClass().getName() + " does not implement ISymbol_v2");
        }
        if (this.getLayerCount() == 0) {
            this.setReferenceSystem(((CartographicSupport)newLayer).getReferenceSystem());
            this.setUnit(((CartographicSupport)newLayer).getUnit());
            if (newLine != null) {
                this.lineWidth = newLine.getLineWidth();
            }
        } else {
            if (newLine != null && newLine.getLineWidth() > this.getLineWidth()) {
                this.lineWidth = newLine.getLineWidth();
            }
            ((CartographicSupport)newLayer).setReferenceSystem(this.getReferenceSystem());
            ((CartographicSupport)newLayer).setUnit(this.getUnit());
        }
        this.selectionSymbol = null;
        if (layerIndex < 0 || this.layers.length < layerIndex) {
            throw new IndexOutOfBoundsException(layerIndex + " < 0 or " + layerIndex + " > " + this.layers.length);
        }
        ArrayList<ISymbol> newLayers = new ArrayList<ISymbol>();
        newLayers.addAll(Arrays.asList(this.layers));
        try {
            newLayers.add(layerIndex, newLayer);
            this.layers = newLayers.toArray(new ISymbol[0]);
        }
        catch (ArrayStoreException asEx) {
            throw new ClassCastException(newLayer.getClass().getName() + " is not an ISymbol");
        }
    }

    public boolean removeLayer(ISymbol layer) {
        int capacity = this.layers.length;
        ArrayList<ISymbol> lst = new ArrayList<ISymbol>(capacity);
        for (int i = 0; i < capacity; ++i) {
            lst.add(this.layers[i]);
        }
        boolean contains = lst.remove(layer);
        this.layers = lst.toArray(new ISymbol[0]);
        return contains;
    }

    @Override
    public int getAlpha() {
        double myAlpha = 0.0;
        for (ISymbol layer1 : this.layers) {
            TransparencySupport layer;
            if (layer1 instanceof TransparencySupport) {
                layer = (TransparencySupport)layer1;
                myAlpha += (1.0 - myAlpha) * layer.getTransparency();
                continue;
            }
            if (!(layer1 instanceof ILineSymbol)) continue;
            layer = (ILineSymbol)layer1;
            double layerAlpha = (double)layer.getAlpha() / 255.0;
            myAlpha += (1.0 - myAlpha) * layerAlpha;
        }
        int result = (int)Math.round(myAlpha * 255.0);
        return result > 255 ? 255 : result;
    }

    @Override
    public void setAlpha(int outlineAlpha) {
        ILineSymbol layer;
        int i;
        int maxAlpha = Integer.MIN_VALUE;
        int maxAlphaLayerIndex = 0;
        for (i = 0; i < this.layers.length; ++i) {
            if (!(this.layers[i] instanceof ILineSymbol) || (layer = (ILineSymbol)this.layers[i]).getAlpha() <= maxAlpha) continue;
            maxAlpha = layer.getAlpha();
            maxAlphaLayerIndex = i;
        }
        for (i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (!(this.layers[i] instanceof ILineSymbol)) continue;
            layer = (ILineSymbol)this.layers[i];
            if (i != maxAlphaLayerIndex) {
                double scaledAlpha = (double)layer.getAlpha() / (double)maxAlpha;
                int myAlpha = (int)((double)outlineAlpha * scaledAlpha);
                if (myAlpha == 0) {
                    myAlpha = 1;
                }
                layer.setAlpha(myAlpha);
                continue;
            }
            int myAlpha = outlineAlpha;
            if (myAlpha == 0) {
                myAlpha = 1;
            }
            layer.setAlpha(myAlpha);
        }
    }

    @Override
    public void setUnit(int unitIndex) {
        super.setUnit(unitIndex);
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (!(this.layers[i] instanceof CartographicSupport)) continue;
            CartographicSupport layer = (CartographicSupport)this.layers[i];
            layer.setUnit(unitIndex);
        }
    }

    @Override
    public void setReferenceSystem(int system) {
        super.setReferenceSystem(system);
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (!(this.layers[i] instanceof CartographicSupport)) continue;
            CartographicSupport layer = (CartographicSupport)this.layers[i];
            layer.setReferenceSystem(system);
        }
    }

    public void setCartographicSize(double cartographicSize, Geometry geom) {
        this.setLineWidth(cartographicSize);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultiLayerLineSymbol copy = (MultiLayerLineSymbol)((Object)super.clone());
        if (this.layers != null && this.layers.length > 0) {
            ISymbol[] layersCopy = new ISymbol[this.layers.length];
            for (int i = 0; i < this.layers.length; ++i) {
                layersCopy[i] = (ISymbol)this.layers[i].clone();
            }
            copy.layers = layersCopy;
        }
        if (this.selectionSymbol != null) {
            copy.selectionSymbol = (MultiLayerLineSymbol)((Object)this.selectionSymbol.clone());
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        List theLayers = state.getList(FIELD_LAYERS);
        if (theLayers != null) {
            for (int i = 0; i < theLayers.size(); ++i) {
                ISymbol sym = (ISymbol)theLayers.get(i);
                if (sym instanceof CartographicSupport) {
                    ((CartographicSupport)sym).setReferenceSystem(this.getReferenceSystem());
                    ((CartographicSupport)sym).setUnit(this.getUnit());
                }
                this.addLayer(sym);
            }
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_LAYERS, (Object[])this.layers);
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            int[] shapeTypes = new int[]{2, 8};
            manager.registerMultiLayerSymbol("line", shapeTypes, MultiLayerLineSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(MultiLayerLineSymbol.MULTILAYER_LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(MultiLayerLineSymbol.class, MultiLayerLineSymbol.MULTILAYER_LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME, "MultiLayerLineSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("LineSymbol"));
                definition.addDynFieldList(MultiLayerLineSymbol.FIELD_LAYERS).setClassOfItems(ISymbol.class);
            }
            return Boolean.TRUE;
        }
    }
}

