/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.collections4.map.LRUMap;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.BackgroundFileStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class ImageStyle
extends BackgroundFileStyle {
    private static final int DEFAULT_CACHE_SIZE = 100;
    public static final String IMAGE_STYLE_PERSISTENCE_DEFINITION_NAME = "ImageStyle";
    private static final String SOURCE = "source";
    private static BufferedImage imageNotFound = null;
    private static LRUMap<URL, BufferedImage> cachedImages = null;
    private BufferedImage img;

    private URL getEfectiveURL() {
        if (!ExpressionUtils.isDynamicURL((URL)this.source)) {
            return this.source;
        }
        try {
            return ExpressionUtils.evaluateURL((SymbolTable)this.symbolTable, (URL)this.source);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private BufferedImage getEfectiveImage() {
        BufferedImage theImage;
        if (!ExpressionUtils.isDynamicURL((URL)this.source)) {
            if (this.img == null) {
                try {
                    this.img = ImageIO.read(this.source);
                }
                catch (IOException ex) {
                    LOGGER.warn("Can't load image from url (" + Objects.toString(this.source) + ")", (Throwable)ex);
                }
            }
            return this.img;
        }
        URL url = this.getEfectiveURL();
        if (url == null) {
            return null;
        }
        if (cachedImages == null) {
            cachedImages = new LRUMap(ImageStyle.getCacheSize());
        }
        if ((theImage = (BufferedImage)cachedImages.get((Object)url)) == null) {
            try {
                theImage = ImageIO.read(url);
                cachedImages.put((Object)url, (Object)theImage);
            }
            catch (IOException ex) {
                theImage = this.getImageNotFound();
            }
        }
        return theImage;
    }

    private static int getCacheSize() {
        return 100;
    }

    private BufferedImage getImageNotFound() {
        if (imageNotFound == null) {
            URL url = ((Object)((Object)this)).getClass().getResource("imageStyle-filenotfound.png");
            if (url == null) {
                return null;
            }
            try {
                imageNotFound = ImageIO.read(url);
            }
            catch (IOException ex) {
                imageNotFound = null;
            }
        }
        return imageNotFound;
    }

    @Override
    public void setSource(URL url) throws IOException {
        this.source = url;
        this.img = null;
    }

    @Override
    public Rectangle getBounds() {
        if (this.getEfectiveImage() == null) {
            return new Rectangle();
        }
        return new Rectangle(new Dimension(this.img.getWidth(), this.img.getHeight()));
    }

    @Override
    public void drawInsideRectangle(Graphics2D g, Rectangle r, boolean keepAspectRatio) {
        BufferedImage theImage = this.getEfectiveImage();
        if (theImage != null) {
            double xOffset = 0.0;
            double yOffset = 0.0;
            double xScale = 1.0;
            double yScale = 1.0;
            if (keepAspectRatio) {
                double scale;
                if (theImage.getWidth() > theImage.getHeight()) {
                    scale = r.getWidth() / (double)theImage.getWidth();
                    yOffset = 0.5 * (r.getHeight() - (double)theImage.getHeight() * scale);
                } else {
                    scale = r.getHeight() / (double)theImage.getHeight();
                    xOffset = 0.5 * (r.getWidth() - (double)theImage.getWidth() * scale);
                }
                xScale = yScale = scale;
            } else {
                xScale = r.getWidth() / (double)theImage.getWidth();
                yScale = r.getHeight() / (double)theImage.getHeight();
                yOffset = (double)theImage.getHeight() * 0.5 * yScale;
            }
            AffineTransform at = AffineTransform.getTranslateInstance(xOffset, yOffset);
            at.concatenate(AffineTransform.getScaleInstance(xScale, yScale));
            g.drawRenderedImage(theImage, at);
        }
    }

    public boolean isSuitableFor(ISymbol symbol) {
        throw new Error("Not yet implemented!");
    }

    public void drawOutline(Graphics2D g, Rectangle r) throws SymbolDrawingException {
        this.drawInsideRectangle(g, r);
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        try {
            String sourceSymbolInLibrary = state.getString("sourceSymbolInLibrary");
            if (sourceSymbolInLibrary != null) {
                this.setSource(new URL(this.getSymbolLibraryURL().toString() + sourceSymbolInLibrary));
            } else {
                this.setSource(state.getURL(SOURCE));
            }
        }
        catch (Exception e) {
            throw new BackgroundFileStyle.PersistenceCantSetSourceException(this, e);
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        if (this.isLibrarySymbol()) {
            state.set("sourceSymbolInLibrary", this.getSourceSymbolInLibrary());
        } else {
            state.setNull("sourceSymbolInLibrary");
        }
        state.set(SOURCE, this.source);
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(ImageStyle.IMAGE_STYLE_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(ImageStyle.class, ImageStyle.IMAGE_STYLE_PERSISTENCE_DEFINITION_NAME, "ImageStyle Persistence definition", null, null);
                definition.extend(manager.getDefinition("BackgroundFileStyle"));
                definition.addDynFieldURL(ImageStyle.SOURCE).setMandatory(true);
                definition.addDynFieldString("sourceSymbolInLibrary").setMandatory(false);
            }
            return Boolean.TRUE;
        }
    }
}

