/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IBackgroundFileStyle;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.ILabelStyle;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.SimpleFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl.SimpleLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.AbstractStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLabelStyle
extends AbstractStyle
implements ILabelStyle {
    private static final Logger logger = LoggerFactory.getLogger(SimpleLabelStyle.class);
    public static final String SIMPLE_LABEL_STYLE_PERSISTENCE_NAME = "SIMPLE_LABEL_STYLE_PERSISTENCE_NAME";
    private Point2D markerPoint = new Point2D.Double();
    private List<Rectangle2D> textFieldAreas = new ArrayList<Rectangle2D>();
    private IBackgroundFileStyle background;
    private Dimension defaultSize = new Dimension(32, 32);
    private Dimension sz;

    public int getFieldCount() {
        return this.textFieldAreas.size();
    }

    public void setTextFields(String[] texts) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; texts != null && i < texts.length; ++i) {
            sb.append(texts[i]);
            if (i >= texts.length) continue;
            sb.append(" ");
        }
    }

    public boolean isSuitableFor(ISymbol symbol) {
        return true;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Rectangle2D[] getTextBounds() {
        return this.textFieldAreas.toArray(new Rectangle2D[this.textFieldAreas.size()]);
    }

    public void drawInsideRectangle(Graphics2D g, Rectangle r) throws SymbolDrawingException {
        if (this.getBackgroundFileStyle() != null) {
            this.getBackgroundFileStyle().drawInsideRectangle(g, r);
        }
    }

    public Dimension getSize() {
        if (this.sz == null && this.getBackgroundFileStyle() != null) {
            Rectangle bgBounds = this.getBackgroundFileStyle().getBounds();
            this.setSize(bgBounds.getWidth(), bgBounds.getHeight());
        } else if (this.sz == null) {
            this.sz = this.defaultSize;
        }
        return this.sz;
    }

    public Point2D getMarkerPoint() {
        return this.markerPoint;
    }

    public void setMarkerPoint(Point2D p) throws IllegalArgumentException {
        if (p.getX() < 0.0 || p.getX() > 1.0) {
            throw new IllegalArgumentException("X must be >=0 and <=1 (" + p.getX() + ")");
        }
        if (p.getY() < 0.0 || p.getY() > 1.0) {
            throw new IllegalArgumentException("Y must be >=0 and <=1 (" + p.getY() + ")");
        }
        this.markerPoint = p;
    }

    public void drawOutline(Graphics2D g, Rectangle r) throws SymbolDrawingException {
        if (this.getBackgroundFileStyle() != null) {
            this.getBackgroundFileStyle().drawOutline(g, r);
        }
        double[] xy = new double[]{this.markerPoint.getX(), this.markerPoint.getY()};
        int x = (int)Math.round((double)r.width * xy[0]);
        int y = (int)Math.round((double)r.height * xy[1]);
        int size = 7;
        g.setColor(Color.ORANGE.darker());
        g.fillOval(x, y, size, size);
        g.setColor(Color.BLACK.brighter());
        g.drawString(Messages.getText((String)"labeled_point"), x + size + 10, y + size);
        g.setColor(Color.BLACK);
        g.drawLine(x - size, (int)((double)y + (double)size * 0.5), x + 2 * size - 1, (int)((double)y + (double)size * 0.5));
        g.drawLine((int)((double)x + (double)size * 0.5), y - size, (int)((double)x + (double)size * 0.5), y + 2 * size - 1);
        if (this.textFieldAreas.size() > 0) {
            SimpleFillSymbol sym = new SimpleFillSymbol();
            Color c = Color.blue.brighter().brighter();
            sym.setFillColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 100));
            SimpleLineSymbol outline = new SimpleLineSymbol();
            c = Color.BLACK;
            outline.setLineColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 100));
            sym.setOutline(outline);
            for (int i = 0; i < this.textFieldAreas.size(); ++i) {
                if (this.getBackgroundFileStyle() == null) {
                    Rectangle2D textFieldArea = this.textFieldAreas.get(i);
                    xy[0] = textFieldArea.getX();
                    xy[1] = textFieldArea.getY();
                    int x2 = (int)Math.round((double)r.width * xy[0]);
                    int y2 = (int)Math.round((double)r.height * xy[1]);
                    xy[0] = textFieldArea.getMaxX();
                    xy[1] = textFieldArea.getMaxY();
                    int width = (int)Math.round((double)r.width * xy[0] - (double)x2);
                    int height = (int)Math.round((double)r.height * xy[1] - (double)y2);
                    Envelope env = null;
                    try {
                        env = GeometryLocator.getGeometryManager().createEnvelope((double)x2, (double)y2, (double)(x2 + width), (double)(y2 + height), 0);
                    }
                    catch (Exception e) {
                        logger.error("While creating envelope", (Throwable)e);
                        throw new SymbolDrawingException(3);
                    }
                    sym.draw(g, null, env.getGeometry(), null, null);
                    g.setColor(Color.BLACK);
                    g.drawString(String.valueOf(i + 1), x2 + 5, y2 + 10);
                    continue;
                }
                double xOffset = 0.0;
                double yOffset = 0.0;
                double scale = 1.0;
                Dimension backgroundBounds = this.getSize();
                if (backgroundBounds.getWidth() > backgroundBounds.getHeight()) {
                    scale = r.getWidth() / backgroundBounds.getWidth();
                    yOffset = 0.5 * (r.getHeight() - backgroundBounds.getHeight() * scale);
                } else {
                    scale = r.getHeight() / backgroundBounds.getHeight();
                    xOffset = 0.5 * (r.getWidth() - backgroundBounds.getWidth() * scale);
                }
                Rectangle2D textFieldArea = this.textFieldAreas.get(i);
                xy[0] = textFieldArea.getX();
                xy[1] = textFieldArea.getY();
                int x3 = (int)Math.round(xy[0] * backgroundBounds.getWidth() * scale + xOffset);
                int y3 = (int)Math.round(xy[1] * backgroundBounds.getHeight() * scale + yOffset);
                xy[0] = textFieldArea.getMaxX();
                xy[1] = textFieldArea.getMaxY();
                int width = (int)Math.round(xy[0] * backgroundBounds.getWidth() * scale + xOffset - (double)x3);
                int height = (int)Math.round(xy[1] * backgroundBounds.getHeight() * scale + yOffset - (double)y3);
                Envelope env = null;
                try {
                    env = GeometryLocator.getGeometryManager().createEnvelope((double)x3, (double)y3, (double)(x3 + width), (double)(y3 + height), 0);
                }
                catch (Exception e) {
                    logger.error("While creating envelope", (Throwable)e);
                    throw new SymbolDrawingException(3);
                }
                sym.draw(g, null, env.getGeometry(), null, null);
                g.setColor(Color.BLACK);
                g.drawString(String.valueOf(i + 1), x3 + 5, y3 + 10);
            }
        }
    }

    public void setTextFieldArea(int index, Rectangle2D rect) {
        this.textFieldAreas.set(index, rect);
    }

    public void addTextFieldArea(Rectangle2D rect) {
        this.textFieldAreas.add(rect);
    }

    public void deleteTextFieldArea(int index) {
        this.textFieldAreas.remove(index);
    }

    public void setSize(double width, double height) {
        this.sz = new Dimension((int)Math.round(width), (int)Math.round(height));
    }

    public IBackgroundFileStyle getBackgroundFileStyle() {
        return this.background;
    }

    public void setBackgroundFileStyle(IBackgroundFileStyle bg) {
        this.background = bg;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.markerPoint = (Point2D)state.get("markerPoint");
        this.textFieldAreas = (List)state.get("textFieldAreas");
        if (state.hasValue("background")) {
            this.background = (IBackgroundFileStyle)state.get("background");
        }
        this.defaultSize = (Dimension)state.get("defaultSize");
        this.sz = (Dimension)state.get("size");
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("markerPoint", (Object)this.markerPoint);
        state.set("textFieldAreas", this.textFieldAreas);
        if (this.background != null) {
            state.set("background", (Persistent)this.background);
        }
        state.set("defaultSize", (Object)this.defaultSize);
        state.set("size", (Object)this.getSize());
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.getDefinition(SimpleLabelStyle.SIMPLE_LABEL_STYLE_PERSISTENCE_NAME);
            if (definition == null) {
                definition = manager.addDefinition(SimpleLabelStyle.class, SimpleLabelStyle.SIMPLE_LABEL_STYLE_PERSISTENCE_NAME, "SIMPLE_LABEL_STYLE_PERSISTENCE_NAME Persistent definition", null, null);
                definition.extend(manager.getDefinition("Style"));
                definition.addDynFieldObject("markerPoint").setClassOfValue(Point2D.class).setMandatory(true);
                definition.addDynFieldList("textFieldAreas").setClassOfItems(Rectangle2D.class).setMandatory(true);
                definition.addDynFieldObject("background").setClassOfValue(IBackgroundFileStyle.class).setMandatory(false);
                definition.addDynFieldObject("defaultSize").setClassOfValue(Dimension.class).setMandatory(true);
                definition.addDynFieldObject("size").setClassOfValue(Dimension.class).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

