/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.annotation.swing.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.gvsig.annotation.AnnotationManager;
import org.gvsig.annotation.swing.AnnotationSwingLocator;
import org.gvsig.annotation.swing.AnnotationSwingManager;
import org.gvsig.annotation.swing.JAnnotationPreferencesPanel;
import org.gvsig.gui.beans.colorchooser.ColorChooser;

public class DefaultJAnnotationPreferencesPanel
extends JAnnotationPreferencesPanel {
    private static final long serialVersionUID = 8893693122931478526L;
    private JLabel jLabel1 = null;
    private JComboBox cmbTypeFont = null;
    private JLabel jLabel2 = null;
    private JComboBox cmbStyleFont = null;
    private JLabel jLabel3 = null;
    private JTextField txtHeight = null;
    private JLabel jLabel4 = null;
    private ColorChooser colorPanel = null;
    private JLabel jLabel5 = null;
    private JTextField txtRotate = null;
    private AnnotationManager annotationManager = null;
    private AnnotationSwingManager annotationSwingManager = AnnotationSwingLocator.getSwingManager();

    public DefaultJAnnotationPreferencesPanel(AnnotationManager annotationManager) {
        this.annotationManager = annotationManager;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        Insets rightInsets = new Insets(4, 4, 4, 0);
        Insets leftInsets = new Insets(4, 0, 4, 4);
        GridBagConstraints txtRotationConstraints = new GridBagConstraints();
        txtRotationConstraints.fill = 2;
        txtRotationConstraints.gridy = 5;
        txtRotationConstraints.weightx = 1.0;
        txtRotationConstraints.gridx = 1;
        txtRotationConstraints.insets = rightInsets;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 5;
        gridBagConstraints10.insets = leftInsets;
        gridBagConstraints10.anchor = 17;
        this.jLabel5 = new JLabel();
        this.jLabel5.setText(this.annotationSwingManager.getTranslation("fontrotate"));
        GridBagConstraints colorChooserConstraints = new GridBagConstraints();
        colorChooserConstraints.fill = 2;
        colorChooserConstraints.anchor = 17;
        colorChooserConstraints.gridy = 4;
        colorChooserConstraints.weightx = 1.0;
        colorChooserConstraints.gridx = 1;
        colorChooserConstraints.insets = rightInsets;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 4;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.insets = leftInsets;
        this.jLabel4 = new JLabel();
        this.jLabel4.setText(this.annotationSwingManager.getTranslation("fontcolor"));
        GridBagConstraints txtHeightConstraints = new GridBagConstraints();
        txtHeightConstraints.fill = 2;
        txtHeightConstraints.gridy = 3;
        txtHeightConstraints.weightx = 1.0;
        txtHeightConstraints.gridx = 1;
        txtHeightConstraints.insets = rightInsets;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 3;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = leftInsets;
        this.jLabel3 = new JLabel();
        this.jLabel3.setText(this.annotationSwingManager.getTranslation("fontheight"));
        GridBagConstraints fontStyleConstraints = new GridBagConstraints();
        fontStyleConstraints.fill = 2;
        fontStyleConstraints.gridy = 2;
        fontStyleConstraints.weightx = 1.0;
        fontStyleConstraints.gridx = 1;
        fontStyleConstraints.insets = rightInsets;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = leftInsets;
        this.jLabel2 = new JLabel();
        this.jLabel2.setText(this.annotationSwingManager.getTranslation("fontstyle"));
        GridBagConstraints fontTypeConstraints = new GridBagConstraints();
        fontTypeConstraints.fill = 2;
        fontTypeConstraints.gridy = 1;
        fontTypeConstraints.weightx = 1.0;
        fontTypeConstraints.gridx = 1;
        fontTypeConstraints.insets = rightInsets;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = leftInsets;
        this.jLabel1 = new JLabel();
        this.jLabel1.setText(this.annotationSwingManager.getTranslation("fonttype"));
        this.jLabel1.setHorizontalTextPosition(11);
        this.jLabel1.setHorizontalAlignment(10);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.insets = rightInsets;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftInsets;
        this.add(this.jLabel1, gridBagConstraints2);
        this.add(this.getCmbFontType(), fontTypeConstraints);
        this.add(this.jLabel2, gridBagConstraints4);
        this.add(this.getCmbFontStyle(), fontStyleConstraints);
        this.add(this.jLabel3, gridBagConstraints6);
        this.add(this.getTxtHeightField(), txtHeightConstraints);
        this.add(this.jLabel4, gridBagConstraints8);
        this.add((Component)this.getColorChooser(), colorChooserConstraints);
        this.add(this.jLabel5, gridBagConstraints10);
        this.add(this.getTxtRotationField(), txtRotationConstraints);
    }

    private JComboBox getCmbFontType() {
        if (this.cmbTypeFont == null) {
            this.cmbTypeFont = new JComboBox();
            List types = this.annotationManager.getFontTypes();
            for (int i = 0; i < types.size(); ++i) {
                this.cmbTypeFont.addItem(types.get(i));
            }
            this.cmbTypeFont.setSelectedItem(this.annotationManager.getDefaultFontType());
        }
        return this.cmbTypeFont;
    }

    private JComboBox getCmbFontStyle() {
        if (this.cmbStyleFont == null) {
            this.cmbStyleFont = new JComboBox();
            List styles = this.annotationManager.getFontStyles();
            for (int i = 0; i < styles.size(); ++i) {
                this.cmbStyleFont.addItem(styles.get(i));
            }
            this.cmbStyleFont.setSelectedItem(this.annotationManager.getDefaultFontStyle());
        }
        return this.cmbStyleFont;
    }

    private JTextField getTxtHeightField() {
        if (this.txtHeight == null) {
            this.txtHeight = new JTextField();
            this.txtHeight.setText("10");
        }
        return this.txtHeight;
    }

    private ColorChooser getColorChooser() {
        if (this.colorPanel == null) {
            this.colorPanel = new ColorChooser();
            this.colorPanel.setColor(Color.BLACK);
        }
        return this.colorPanel;
    }

    private JTextField getTxtRotationField() {
        if (this.txtRotate == null) {
            this.txtRotate = new JTextField();
            this.txtRotate.setText("0.0");
        }
        return this.txtRotate;
    }

    public String getDefaultFontType() {
        return this.getCmbFontType().getSelectedItem().toString();
    }

    public void setDefaultFontType(String typeFont) {
        this.getCmbFontType().setSelectedItem(typeFont);
    }

    public String getDefaultFontStyle() {
        return (String)this.getCmbFontStyle().getSelectedItem();
    }

    public void setDefaultFontStyle(String style) {
        this.getCmbFontStyle().setSelectedItem(style);
    }

    public double getDefaultFontHeight() {
        return Double.parseDouble(this.getTxtHeightField().getText());
    }

    public void setDefaultFontHeight(double height) {
        this.getTxtHeightField().setText(Double.toString(height));
    }

    public int getDefaultFontColor() {
        Color col = this.getColorChooser().getColor();
        int resp = col.getAlpha() << 24 | col.getRGB();
        return resp;
    }

    public void setDefaultFontColor(int color) {
        this.getColorChooser().setColor(new Color(color, true));
    }

    public double getDefaultFontRotation() {
        return Double.parseDouble(this.getTxtRotationField().getText());
    }

    public void setDefaultFontRotation(double rotation) {
        this.getTxtRotationField().setText(Double.toString(rotation));
    }
}

