/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.pagedtable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.impl.pagedtable.Pager;
import org.gvsig.raster.swing.impl.pagedtable.TableControllerListener;

public class PaginationBarPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private JButton up = null;
    private JButton down = null;
    private JLabel selectedPag = null;
    private JLabel nPages = null;
    private String pathToImagesForTest = "/src/main/resources/images/";

    public PaginationBarPanel(TableControllerListener tableListener) {
        if (tableListener != null) {
            tableListener.setPaginationBarPanel(this);
        }
        this.initialize(tableListener);
    }

    private void initialize(TableControllerListener tableListener) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.anchor = 11;
        this.add((Component)this.getButtonUp(), gbc);
        gbc.anchor = 10;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.fill = 0;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        p.add((Component)this.getSelectedPage(), gbc1);
        gbc1.gridy = 1;
        p.add((Component)this.getNPages(), gbc1);
        this.add((Component)p, gbc);
        gbc.weighty = 0.0;
        gbc.anchor = 15;
        gbc.gridy = 2;
        this.add((Component)this.getButtonDown(), gbc);
        this.getButtonUp().addActionListener(tableListener);
        this.getButtonDown().addActionListener(tableListener);
    }

    public JLabel getSelectedPage() {
        if (this.selectedPag == null) {
            this.selectedPag = new JLabel("-");
        }
        return this.selectedPag;
    }

    public JLabel getNPages() {
        if (this.nPages == null) {
            this.nPages = new JLabel("-");
        }
        return this.nPages;
    }

    private ImageIcon loadIcon(String iconName) {
        ImageIcon icon = null;
        try {
            icon = IconThemeHelper.getImageIcon((String)iconName);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (icon == null) {
            icon = new ImageIcon(System.getProperty("user.dir") + this.pathToImagesForTest + iconName + ".png", "");
        }
        if (icon == null) {
            icon = new ImageIcon(System.getProperty("user.dir") + this.pathToImagesForTest + iconName + ".gif", "");
        }
        return icon;
    }

    public JButton getButtonUp() {
        if (this.up == null) {
            this.up = new JButton("");
            this.up.setEnabled(false);
            this.up.setPreferredSize(new Dimension(22, 22));
            this.up.setIcon(this.loadIcon("up-16x16"));
            this.up.setActionCommand("");
            this.up.setToolTipText(Messages.getText((String)"prev_pag"));
        }
        return this.up;
    }

    public JButton getButtonDown() {
        if (this.down == null) {
            this.down = new JButton("");
            this.down.setEnabled(false);
            this.down.setPreferredSize(new Dimension(22, 22));
            this.down.setIcon(this.loadIcon("down-16x16"));
            this.down.setActionCommand("");
            this.down.setToolTipText(Messages.getText((String)"next_pag"));
        }
        return this.down;
    }

    @Override
    public void update(Observable o, Object arg) {
        Pager pager = (Pager)o;
        if (o instanceof Pager && arg instanceof Integer) {
            this.setPageNumberText(pager);
            this.checkArrows(pager);
        }
    }

    private void setPageNumberText(Pager pager) {
        if (pager.getPageCount() == 0) {
            this.getNPages().setText("-");
            this.getSelectedPage().setText("-");
        } else {
            this.getNPages().setText(pager.getPageCount() + "");
            this.getSelectedPage().setText(pager.getSelectedPageNumber() + 1 + "");
        }
    }

    private void checkArrows(Pager pager) {
        if (pager.getPageCount() == 0) {
            this.getButtonDown().setEnabled(false);
            this.getButtonUp().setEnabled(false);
            return;
        }
        if (pager.getSelectedPageNumber() < pager.getPageCount() - 1) {
            this.getButtonDown().setEnabled(true);
        } else {
            this.getButtonDown().setEnabled(false);
        }
        if (pager.getSelectedPageNumber() <= 0) {
            this.getButtonUp().setEnabled(false);
        } else {
            this.getButtonUp().setEnabled(true);
        }
    }
}

