/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.preview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanel;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.imagenavigator.IClientImageNavigator;
import org.gvsig.gui.beans.imagenavigator.ImageNavigator;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.impl.preview.PreviewRequestManager;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.raster.swing.preview.PreviewPanel;
import org.gvsig.raster.swing.preview.PreviewRenderProcess;

public class SinglePreviewPanel
extends JPanel
implements PreviewPanel {
    private static final long serialVersionUID = 6028780107787443656L;
    private ImageNavigator imageNavigator = null;
    private DataSourcePreview fLayer = null;
    private PreviewRenderProcess renderProcess = null;
    private JPanel jPanelPreview = null;
    private PreviewRequestManager previewRequestManager = null;

    public SinglePreviewPanel(PreviewRenderProcess renderProcess, DataSourcePreview lyr) {
        this.renderProcess = renderProcess;
        this.setLayer(lyr);
        this.initialize();
    }

    public SinglePreviewPanel(PreviewRenderProcess renderProcess) {
        this.renderProcess = renderProcess;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(8, 8));
        this.add((Component)this.getPanelPreview(), "Center");
    }

    public void closePreviewLayer() {
        this.previewRequestManager.closePreviewLayer();
    }

    public IClientImageNavigator getPreviewManager() {
        return this.previewRequestManager;
    }

    public ImageNavigator getImageNavigator() {
        if (this.imageNavigator == null) {
            this.imageNavigator = new ImageNavigator(this.getPreviewManager());
            this.imageNavigator.setFocusable(true);
            this.imageNavigator.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        }
        return this.imageNavigator;
    }

    public JPanel getPanelPreview() {
        if (this.jPanelPreview == null) {
            this.jPanelPreview = new JPanel();
            JPanel jsubpanel2 = new JPanel();
            this.jPanelPreview.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"vista_previa"), 0, 0, null, null));
            this.jPanelPreview.setLayout(new BorderLayout());
            jsubpanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            jsubpanel2.setLayout(new BorderLayout());
            jsubpanel2.add((Component)this.getImageNavigator(), "Center");
            this.jPanelPreview.add((Component)jsubpanel2, "Center");
            this.jPanelPreview.setPreferredSize(new Dimension(237, 237));
            this.jPanelPreview.setMinimumSize(new Dimension(237, 237));
            this.jPanelPreview.setMaximumSize(new Dimension(237, 237));
        }
        return this.jPanelPreview;
    }

    public void setLayer(DataSourcePreview fLayer) {
        this.fLayer = fLayer;
        this.previewRequestManager = new PreviewRequestManager(this.renderProcess, fLayer);
        this.previewInitializeSizes();
    }

    public void previewInitializeSizes() {
        if (this.fLayer == null) {
            return;
        }
        Rectangle2D extent2 = this.fLayer.getBBoxRectangle();
        this.getImageNavigator().setViewDimensions(extent2.getMinX(), extent2.getMaxY(), extent2.getMaxX(), extent2.getMinY());
        this.getImageNavigator().setZoom(1.0 / this.fLayer.getCellSize());
        this.getImageNavigator().setAutoAdjusted();
    }

    public DataSourcePreview getLayer() {
        return this.fLayer;
    }

    public void setPreviewSize(Dimension dimension) {
        this.getPanelPreview().setPreferredSize(dimension);
        this.getPanelPreview().setMinimumSize(dimension);
        this.getPanelPreview().setMaximumSize(dimension);
    }

    public void refreshPreview() {
        if (this.fLayer == null) {
            return;
        }
        this.getImageNavigator().updateBuffer();
    }

    public DataSourcePreview getDataSourcePreview() {
        return this.fLayer;
    }

    public void addButtonPressedListener(ButtonsPanelListener listener) {
    }

    public ButtonsPanel getButtonsPanel() {
        return null;
    }

    public JTabbedPane getTabbedPane() {
        return null;
    }
}

