/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.union;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.geoprocess.algorithm.base.core.ScalableUnionOperation;
import org.gvsig.geoprocess.algorithm.difference.DifferenceOperation;
import org.gvsig.geoprocess.algorithm.intersection.IntersectionOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.task.SimpleTaskStatus;

public class UnionAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT1 = "RESULT1";
    public static final String RESULT2 = "RESULT2";
    public static final String LAYER1 = "LAYER1";
    public static final String LAYER2 = "LAYER2";
    public static final String SELECTGEOM_INPUT = "SELECTGEOM_INPUT";
    public static final String SELECTGEOM_OVERLAY = "SELECTGEOM_OVERLAY";

    public void defineCharacteristics() {
        this.setName(this.getTranslation("Union"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER1, this.getTranslation("Input_layer") + " 1", -1, true);
            this.m_Parameters.addInputVectorLayer(LAYER2, this.getTranslation("Input_layer") + " 2", -1, true);
            this.m_Parameters.addBoolean(SELECTGEOM_INPUT, this.getTranslation("Selected_geometries_input_layer_union"), false);
            this.m_Parameters.addBoolean(SELECTGEOM_OVERLAY, this.getTranslation("Selected_geometries_overlay_layer_union"), false);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputVectorLayer(RESULT1, this.getTranslation("Union_l1"), -1);
        this.addOutputVectorLayer(RESULT2, this.getTranslation("Union_l2"), -1);
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT1, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        if (this.existsOutPutFile(RESULT2, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer layer1 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER1);
        IVectorLayer layer2 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER2);
        boolean selectedGeomInput = this.m_Parameters.getParameter(SELECTGEOM_INPUT).getParameterValueAsBoolean();
        boolean selectedGeomOverlay = this.m_Parameters.getParameter(SELECTGEOM_OVERLAY).getParameterValueAsBoolean();
        FeatureStore storeLayer1 = null;
        FeatureStore storeLayer2 = null;
        if (!(layer1 instanceof FlyrVectIVectorLayer) || !(layer2 instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        storeLayer1 = ((FlyrVectIVectorLayer)layer1).getFeatureStore();
        storeLayer2 = ((FlyrVectIVectorLayer)layer2).getFeatureStore();
        try {
            FeatureType featureType1 = storeLayer1.getDefaultFeatureType();
            FeatureSet features2 = null;
            features2 = storeLayer2.getFeatureSet();
            FeatureType featureType2 = features2.getDefaultFeatureType();
            FeatureStore featStoreOut1 = null;
            FeatureStore featStoreOut2 = null;
            if (this.isPolygon(storeLayer1) && this.isPolygon(storeLayer2)) {
                featStoreOut1 = this.buildOutPutStoreFromUnion(featureType1, featureType2, layer1.getShapeType(), this.getTranslation("Union_polygon"), RESULT1);
                this.computesUnion(storeLayer1, storeLayer2, featStoreOut1, selectedGeomInput, selectedGeomOverlay);
            } else if (this.isPoint(storeLayer1) && this.isPoint(storeLayer2)) {
                featStoreOut1 = this.buildOutPutStoreFromUnion(featureType1, featureType2, layer1.getShapeType(), this.getTranslation("Union_point"), RESULT1);
                this.computesUnion(storeLayer1, storeLayer2, featStoreOut1, selectedGeomInput, selectedGeomOverlay);
            } else if (this.isLine(storeLayer1) && this.isLine(storeLayer2)) {
                featStoreOut1 = this.buildOutPutStoreFromUnion(featureType1, featureType2, 0, this.getTranslation("Union_point"), RESULT1);
                this.computesIntersection(storeLayer1, storeLayer2, featStoreOut1, selectedGeomInput, selectedGeomOverlay, true);
                this.getNamesTranslator().clear();
                featStoreOut2 = this.buildOutPutStoreFromUnion(featureType1, featureType2, 1, this.getTranslation("Union_line"), RESULT2);
                this.computesDifference(storeLayer1, storeLayer2, featStoreOut2, selectedGeomInput, selectedGeomOverlay, false);
                this.computesDifference(storeLayer2, storeLayer1, featStoreOut2, selectedGeomInput, selectedGeomOverlay, true);
            } else if (this.isPolygon(storeLayer1) && this.isLine(storeLayer2) || this.isLine(storeLayer1) && this.isPolygon(storeLayer2)) {
                featStoreOut1 = this.buildOutPutStoreFromUnion(featureType1, featureType2, 1, this.getTranslation("Union_line"), RESULT1);
                this.computesUnion(storeLayer1, storeLayer2, featStoreOut1, selectedGeomInput, selectedGeomOverlay);
                featStoreOut2 = this.buildOutPutStoreFromUnion(featureType1, featureType2, 2, this.getTranslation("Union_polygon"), RESULT2);
                this.computesDifference(storeLayer1, storeLayer2, featStoreOut2, selectedGeomInput, selectedGeomOverlay, false);
                this.computesDifference(storeLayer2, storeLayer1, featStoreOut2, selectedGeomInput, selectedGeomOverlay, true);
            } else if (this.isPolygon(storeLayer1) && this.isPoint(storeLayer2) || this.isPoint(storeLayer1) && this.isPolygon(storeLayer2)) {
                featStoreOut1 = this.buildOutPutStoreFromUnion(featureType1, featureType2, 0, this.getTranslation("Union_point"), RESULT1);
                this.computesUnion(storeLayer1, storeLayer2, featStoreOut1, selectedGeomInput, selectedGeomOverlay);
                featStoreOut2 = this.buildOutPutStoreFromUnion(featureType1, featureType2, 6, this.getTranslation("Union_polygon"), RESULT2);
                this.computesUnion(storeLayer1, storeLayer2, featStoreOut2, selectedGeomInput, selectedGeomOverlay);
            } else if (this.isPoint(storeLayer1) && this.isLine(storeLayer2) || this.isLine(storeLayer1) && this.isPoint(storeLayer2)) {
                featStoreOut1 = this.buildOutPutStoreFromUnion(featureType1, featureType2, 0, this.getTranslation("Union_point"), RESULT1);
                this.computesUnion(storeLayer1, storeLayer2, featStoreOut1, selectedGeomInput, selectedGeomOverlay);
                featStoreOut2 = this.buildOutPutStoreFromUnion(featureType1, featureType2, 5, this.getTranslation("Union_line"), RESULT2);
                this.computesUnion(storeLayer1, storeLayer2, featStoreOut2, selectedGeomInput, selectedGeomOverlay);
            }
            if (featStoreOut2 == null) {
                featStoreOut2 = this.buildOutPutStoreFromUnion(featureType1, featureType2, -1, this.getTranslation("Null_Layer"), RESULT2);
            }
        }
        catch (ReadException e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
        catch (DataException e) {
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
        return !this.getTaskMonitor().isCanceled();
    }

    private void computesUnion(FeatureStore storeLayer1, FeatureStore storeLayer2, FeatureStore featStoreOut, boolean selectedGeomInput, boolean selectGeomOverlay) throws DataException, WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        this.computesIntersection(storeLayer1, storeLayer2, featStoreOut, selectedGeomInput, selectGeomOverlay, false);
        this.computesDifference(storeLayer1, storeLayer2, featStoreOut, selectedGeomInput, selectGeomOverlay, false);
        this.computesDifference(storeLayer2, storeLayer1, featStoreOut, selectedGeomInput, selectGeomOverlay, true);
    }

    private void computesIntersection(FeatureStore storeLayer1, FeatureStore storeLayer2, FeatureStore featStoreOut, boolean selectedGeomInput, boolean selectGeomOverlay, boolean close) throws DataException, WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        IntersectionOperation intersection = new IntersectionOperation(storeLayer2, (AbstractSextanteGeoProcess)this);
        intersection.setTaskStatus((SimpleTaskStatus)this.getStatus());
        intersection.computesGeometryOperation(storeLayer1, featStoreOut, this.attrNames, selectedGeomInput, selectGeomOverlay, close);
    }

    private void computesDifference(FeatureStore storeLayer1, FeatureStore storeLayer2, FeatureStore featStoreOut, boolean selectedGeomInput, boolean selectGeomOverlay, boolean close) throws DataException, WrongParameterTypeException, WrongParameterIDException, NullParameterValueException {
        Geometry unionGeom1 = ScalableUnionOperation.joinLayerGeometries((FeatureStore)storeLayer2, (boolean)selectGeomOverlay);
        DifferenceOperation differenceL1_L2 = new DifferenceOperation(unionGeom1, (AbstractSextanteGeoProcess)this);
        differenceL1_L2.setTaskStatus((SimpleTaskStatus)this.getStatus());
        differenceL1_L2.computesGeometryOperation(storeLayer1, featStoreOut, this.attrNames, selectedGeomInput, selectGeomOverlay, close);
    }
}

