/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.app.mainplugin.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.AbstractDocumentManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentAction;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.actions.CopyDocumentAction;
import org.gvsig.app.project.documents.actions.CutDocumentAction;
import org.gvsig.app.project.documents.actions.PasteDocumentAction;
import org.gvsig.app.project.documents.gui.IDocumentWindow;
import org.gvsig.app.project.documents.gui.WindowLayout;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.propertypage.PropertiesPageFactory;
import org.gvsig.propertypage.PropertiesPageManager;
import org.gvsig.report.app.mainplugin.ReportState;
import org.gvsig.report.app.mainplugin.document.ReportDocument;
import org.gvsig.report.app.mainplugin.document.ReportDocumentImpl;
import org.gvsig.report.app.mainplugin.document.gui.CreateReportPanel;
import org.gvsig.report.app.mainplugin.document.gui.ReportDocumentPanel;
import org.gvsig.report.app.mainplugin.document.gui.properties.GeneralDocumentPropertiesPageFactory;
import org.gvsig.report.app.mainplugin.document.gui.properties.LocationReportPropertiesPageFactory;
import org.gvsig.report.app.mainplugin.document.gui.properties.ReportPropertiesPanel;
import org.gvsig.report.lib.api.ReportConfig;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDocumentsManager
extends AbstractDocumentManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportDocumentsManager.class);
    private static final String PERSISTENCE_REPORT_DOCUMENT_DEFINITION_NAME = "DefaultReportDocument";
    public static String TYPENAME = "project.document.report";
    private DynStruct persistenceDefinition;

    public int getPriority() {
        return 100;
    }

    public ImageIcon getIcon() {
        return PluginServices.getIconTheme().get("document-report-icon");
    }

    public ImageIcon getIconSelected() {
        return PluginServices.getIconTheme().get("document-report-icon-sel");
    }

    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Report");
    }

    public String getTypeName() {
        return TYPENAME;
    }

    public Class getMainWindowClass() {
        return ReportDocumentPanel.class;
    }

    private ReportServer getServer() {
        return ReportState.get().getServer();
    }

    public AbstractDocument createDocument() {
        ReportManager reportManager = ReportLocator.getReportManager();
        ReportConfig reportConfig = reportManager.createReportConfig();
        ReportDocumentImpl doc = new ReportDocumentImpl(this, reportConfig);
        if (this.notifyObservers("DocumentManager.CreateDocument", doc).isCanceled()) {
            return null;
        }
        return doc;
    }

    public AbstractDocument createDocumentByUser() {
        return (AbstractDocument)this.createDocumentsByUser().next();
    }

    public Iterator<? extends Document> createDocumentsByUser() {
        return this.createDocumentsByUser(null);
    }

    public Iterator<? extends Document> createDocumentsByUser(Invocable whenDocumentsLoaded) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        CreateReportPanel panel = new CreateReportPanel(this.getServer());
        Dialog dialog = winManager.createDialog(panel.asJComponent(), i18n.getTranslation("_Create_report_document"), null, 3);
        dialog.setButtonEnabled(1, false);
        panel.addChangeListener(e -> {
            if (panel.isOkAvailable()) {
                dialog.setButtonEnabled(1, true);
            } else {
                dialog.setButtonEnabled(1, false);
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
        if (dialog.getAction() != 1) {
            return Collections.EMPTY_LIST.iterator();
        }
        ReportConfig report = panel.getReportConfig();
        ReportDocumentImpl doc = new ReportDocumentImpl(this, report);
        doc.setOpenWhenTheUserCreates(panel.getOpenDocument());
        ArrayList<ReportDocumentImpl> r = new ArrayList<ReportDocumentImpl>();
        r.add(doc);
        return r.iterator();
    }

    public IWindow getMainWindow(Document doc, WindowLayout layout) {
        IDocumentWindow win = (IDocumentWindow)super.getMainWindow(doc, layout);
        if (win == null) {
            win = this.createDocumentWindow(doc);
            if (layout != null && win != null) {
                win.setWindowLayout(layout);
            }
            if (this.notifyObservers("DocumentManager.createMainWindow", (IWindow)win).isCanceled()) {
                return null;
            }
        }
        if (this.notifyObservers("DocumentManager.getMainWindow", (IWindow)win).isCanceled()) {
            return null;
        }
        ((AbstractDocument)doc).raiseEventCreateWindow((IWindow)win);
        return win;
    }

    public IWindow getPropertiesWindow(Document doc) {
        Object win = super.getPropertiesWindow(doc);
        if (win == null && this.notifyObservers("DocumentManager.createPropertiesWindow", (IWindow)(win = new ReportPropertiesPanel((ReportDocument)doc))).isCanceled()) {
            return null;
        }
        if (this.notifyObservers("DocumentManager.getPropertiesWindow", (IWindow)win).isCanceled()) {
            return null;
        }
        return win;
    }

    public void selfRegister() {
        if (this.persistenceDefinition != null) {
            return;
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        this.persistenceDefinition = persistenceManager.addDefinition(ReportDocument.class, PERSISTENCE_REPORT_DOCUMENT_DEFINITION_NAME, "Default report document persistence definition", null, null);
        this.persistenceDefinition.extend(persistenceManager.getDefinition("AbstractDocument"));
        this.persistenceDefinition.addDynFieldString("report_datasetName").setMandatory(true);
        this.persistenceDefinition.addDynFieldFile("report_file").setMandatory(true);
        persistenceManager.registerFactory((PersistenceFactory)this);
        IconThemeHelper.registerIcon((String)"document", (String)"document-report-icon", ReportDocumentsManager.class);
        IconThemeHelper.registerIcon((String)"document", (String)"document-report-icon-sel", ReportDocumentsManager.class);
        projectManager.registerDocumentFactory((DocumentManager)this);
        projectManager.registerDocumentAction(TYPENAME, (DocumentAction)new CopyDocumentAction());
        projectManager.registerDocumentAction(TYPENAME, (DocumentAction)new CutDocumentAction());
        projectManager.registerDocumentAction(TYPENAME, (DocumentAction)new PasteDocumentAction());
        PropertiesPageManager propertiesPageManager = MapControlLocator.getPropertiesPageManager();
        propertiesPageManager.registerFactory((PropertiesPageFactory)new GeneralDocumentPropertiesPageFactory("ReportDocument", "General"));
        propertiesPageManager.registerFactory((PropertiesPageFactory)new LocationReportPropertiesPageFactory());
    }

    public DynStruct getDefinition(String className) {
        if (this.persistenceDefinition.getName().equalsIgnoreCase(className)) {
            return this.persistenceDefinition;
        }
        if (this.persistenceDefinition.getFullName().equalsIgnoreCase(className)) {
            return this.persistenceDefinition;
        }
        if (this.getDocumentClass().getName().equals(className)) {
            return this.persistenceDefinition;
        }
        return null;
    }

    protected Class getDocumentClass() {
        return ReportDocumentImpl.class;
    }

    public boolean manages(Object object) {
        return object instanceof ReportDocument;
    }
}

