/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.app.mainplugin.document.gui;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.report.app.mainplugin.document.gui.CreateReportPanelView;
import org.gvsig.report.lib.api.ReportConfig;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ChangeListenerSupport;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;

public class CreateReportPanel
extends CreateReportPanelView
implements Component,
ChangeListenerSupport {
    private final FilePickerController reportFileController;
    private final ReportServer server;
    private ChangeListenerHelper changeListenerHelper;

    public CreateReportPanel(ReportServer server) {
        this.reportFileController = ToolsSwingLocator.getToolsSwingManager().createFilePickerController((JTextComponent)this.txtReportFile, this.btnReportFile);
        this.server = server;
        this.initComponents();
    }

    public boolean isOkAvailable() {
        return !StringUtils.isBlank((CharSequence)this.txtReportFile.getText()) && this.cboDataSet.getModel().getSelectedItem() != null;
    }

    private void initComponents() {
        ReportServerConfig config = this.server.getConfig();
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        this.changeListenerHelper = swingManager.createChangeListenerHelper();
        DefaultComboBoxModel<String> model1 = new DefaultComboBoxModel<String>();
        if (config.getDatasets() != null) {
            for (ReportDataSet dataset : config.getDatasets()) {
                model1.addElement(dataset.getName());
            }
        }
        this.cboDataSet.setModel(model1);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.getName().toLowerCase().endsWith(".jrxml")) {
                    return true;
                }
                if (f.getName().toLowerCase().endsWith(".jasper")) {
                    return true;
                }
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Report (.jrxml|.jasper)";
            }
        };
        this.reportFileController.setFileFilter(filter);
        Dimension dimension = this.getPreferredSize();
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        this.setPreferredSize(dimension);
        this.cboDataSet.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreateReportPanel.this.doDataSetModified();
            }
        });
        this.txtReportFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateReportPanel.this.doReportFileModified();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateReportPanel.this.doReportFileModified();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CreateReportPanel.this.doReportFileModified();
            }
        });
        this.changeListenerHelper.fireEvent();
    }

    private void doDataSetModified() {
        this.changeListenerHelper.fireEvent();
    }

    private void doReportFileModified() {
        this.changeListenerHelper.fireEvent();
    }

    public ReportConfig getReportConfig() {
        ReportManager manager = ReportLocator.getReportManager();
        String datasetName = (String)this.cboDataSet.getSelectedItem();
        if (StringUtils.isEmpty((CharSequence)datasetName)) {
            return null;
        }
        ReportDataSet dataset = this.server.getConfig().getDataset(datasetName);
        if (dataset == null) {
            return null;
        }
        File f = (File)this.reportFileController.get();
        ReportConfig config = manager.createReportConfig();
        config.setDataSetName(datasetName);
        config.setReportResourcesStorage((ResourcesStorage)new FilesResourcesStorage(f.getParent()));
        config.setReportTemplate(f.getName());
        return config;
    }

    public boolean getOpenDocument() {
        return this.chkOpenDocument.isSelected();
    }

    public JComponent asJComponent() {
        return this;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListenerHelper.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerHelper.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }
}

