/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners.snapping.snappers;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.Spline;
import org.gvsig.fmap.mapcontrol.PrimitivesDrawer;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapperVectorial;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.impl.AbstractSnapper;
import org.gvsig.i18n.Messages;

public class TangentPointSnapper
extends AbstractSnapper
implements ISnapperVectorial {
    public Point2D getSnapPoint(Point2D point, Geometry geom, double tolerance, Point2D lastPointEntered) {
        if (!(geom instanceof Circle || geom instanceof Arc || geom instanceof Ellipse || geom instanceof Spline)) {
            return null;
        }
        Point2D.Double resul = null;
        Coordinate c = new Coordinate(point.getX(), point.getY());
        PathIterator theIterator = geom.getPathIterator(null, geomManager.getFlatness());
        double[] theData = new double[6];
        double minDist = tolerance;
        Coordinate from = null;
        Coordinate first = null;
        while (!theIterator.isDone()) {
            int theType = theIterator.currentSegment(theData);
            switch (theType) {
                case 0: {
                    first = from = new Coordinate(theData[0], theData[1]);
                    break;
                }
                case 1: {
                    Coordinate to = new Coordinate(theData[0], theData[1]);
                    LineSegment line = new LineSegment(from, to);
                    Coordinate closestPoint = line.closestPoint(c);
                    double dist = c.distance(closestPoint);
                    if (dist < minDist) {
                        resul = new Point2D.Double(closestPoint.x, closestPoint.y);
                        minDist = dist;
                    }
                    from = to;
                    break;
                }
                case 4: {
                    LineSegment line = new LineSegment(from, first);
                    Coordinate closestPoint = line.closestPoint(c);
                    double dist = c.distance(closestPoint);
                    if (dist < minDist) {
                        resul = new Point2D.Double(closestPoint.x, closestPoint.y);
                        minDist = dist;
                    }
                    from = first;
                }
            }
            theIterator.next();
        }
        return resul;
    }

    public String getToolTipText() {
        return Messages.getText((String)"Tangent_point");
    }

    public void draw(PrimitivesDrawer primitivesDrawer, Point2D pPixels) {
        primitivesDrawer.setColor(this.getColor());
        int half = this.getSizePixels() / 2;
        primitivesDrawer.drawLine((int)(pPixels.getX() - (double)half), (int)(pPixels.getY() - (double)half), (int)(pPixels.getX() + (double)half), (int)(pPixels.getY() - (double)half));
        primitivesDrawer.drawOval((int)(pPixels.getX() - (double)half), (int)(pPixels.getY() - (double)half), this.getSizePixels(), this.getSizePixels());
    }
}

