/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import es.unex.sextante.core.IInputFactory;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.parameters.RasterLayerAndBand;
import java.util.ArrayList;

public abstract class AbstractInputFactory
implements IInputFactory {
    public static final int SHAPE_TYPE_ANY = -1;
    protected IDataObject[] m_Objects;

    @Override
    public void clearDataObjects() {
        this.m_Objects = null;
    }

    public void removeDataObject(String sName) {
        ArrayList<IDataObject> list = new ArrayList<IDataObject>();
        for (int i = 0; i < this.m_Objects.length; ++i) {
            if (this.m_Objects[i].getName().equals(sName)) continue;
            list.add(this.m_Objects[i]);
        }
        this.m_Objects = list.toArray(new IDataObject[0]);
    }

    @Override
    public void addDataObject(IDataObject obj) {
        IDataObject[] newObjects = new IDataObject[this.m_Objects.length + 1];
        System.arraycopy(this.m_Objects, 0, newObjects, 0, this.m_Objects.length);
        newObjects[this.m_Objects.length] = obj;
        this.m_Objects = newObjects;
    }

    public void removeObject(IDataObject obj) {
        ArrayList<IDataObject> list = new ArrayList<IDataObject>();
        for (int i = 0; i < this.m_Objects.length; ++i) {
            if (this.m_Objects[i] == obj) continue;
            list.add(this.m_Objects[i]);
        }
        this.m_Objects = list.toArray(new IDataObject[0]);
    }

    @Override
    public RasterLayerAndBand[] getBands() {
        ArrayList<RasterLayerAndBand> list = new ArrayList<RasterLayerAndBand>();
        IRasterLayer[] layers = this.getRasterLayers();
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].getBandsCount(); ++j) {
                RasterLayerAndBand rab = new RasterLayerAndBand(layers[i], j);
                list.add(rab);
            }
        }
        RasterLayerAndBand[] bands = new RasterLayerAndBand[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            bands[i] = (RasterLayerAndBand)list.get(i);
        }
        return bands;
    }

    @Override
    public ILayer[] getLayers() {
        ArrayList<IDataObject> list = new ArrayList<IDataObject>();
        IDataObject[] objs = this.getDataObjects();
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof ILayer)) continue;
            list.add(objs[i]);
        }
        ILayer[] layers = new ILayer[list.size()];
        for (int i = 0; i < layers.length; ++i) {
            layers[i] = (ILayer)list.get(i);
        }
        return layers;
    }

    @Override
    public IRasterLayer[] getRasterLayers() {
        ArrayList<IDataObject> list = new ArrayList<IDataObject>();
        IDataObject[] objs = this.getDataObjects();
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof IRasterLayer)) continue;
            list.add(objs[i]);
        }
        IRasterLayer[] layers = new IRasterLayer[list.size()];
        for (int i = 0; i < layers.length; ++i) {
            layers[i] = (IRasterLayer)list.get(i);
        }
        return layers;
    }

    @Override
    public I3DRasterLayer[] get3DRasterLayers() {
        ArrayList<IDataObject> list = new ArrayList<IDataObject>();
        IDataObject[] objs = this.getDataObjects();
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof I3DRasterLayer)) continue;
            list.add(objs[i]);
        }
        I3DRasterLayer[] layers = new I3DRasterLayer[list.size()];
        for (int i = 0; i < layers.length; ++i) {
            layers[i] = (I3DRasterLayer)list.get(i);
        }
        return layers;
    }

    @Override
    public IVectorLayer[] getVectorLayers(int shapeType) {
        ArrayList<IDataObject> list = new ArrayList<IDataObject>();
        IDataObject[] objs = this.getDataObjects();
        for (int i = 0; i < objs.length; ++i) {
            IVectorLayer layer;
            if (!(objs[i] instanceof IVectorLayer) || (layer = (IVectorLayer)objs[i]).getShapeType() == -1 || layer.getShapeType() != shapeType && shapeType != -1) continue;
            list.add(objs[i]);
        }
        IVectorLayer[] layers = new IVectorLayer[list.size()];
        for (int i = 0; i < layers.length; ++i) {
            layers[i] = (IVectorLayer)list.get(i);
        }
        return layers;
    }

    @Override
    public ITable[] getTables() {
        ArrayList<IDataObject> list = new ArrayList<IDataObject>();
        IDataObject[] objs = this.getDataObjects();
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof ITable)) continue;
            list.add(objs[i]);
        }
        ITable[] tables = new ITable[list.size()];
        for (int i = 0; i < tables.length; ++i) {
            tables[i] = (ITable)list.get(i);
        }
        return tables;
    }

    @Override
    public IDataObject[] getDataObjects() {
        return this.m_Objects;
    }

    @Override
    public IDataObject getInputFromName(String sName) {
        for (int i = 0; i < this.m_Objects.length; ++i) {
            if (!this.m_Objects[i].getName().equals(sName)) continue;
            return this.m_Objects[i];
        }
        return null;
    }
}

