/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.rasterWrappers.Grid3DCell;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AnalysisExtent {
    double m_dXMin = 0.0;
    double m_dYMin = 0.0;
    double m_dZMin = 0.0;
    double m_dXMax = 0.0;
    double m_dYMax = 0.0;
    double m_dZMax = 0.0;
    double m_dCellSize = 1.0;
    double m_dCellSizeZ = 1.0;
    int m_iNX;
    int m_iNY;
    int m_iNZ;

    public AnalysisExtent() {
    }

    public AnalysisExtent(ILayer layer) {
        this.m_dXMin = layer.getFullExtent().getMinX();
        this.m_dXMax = layer.getFullExtent().getMaxX();
        this.m_dYMin = layer.getFullExtent().getMinY();
        this.m_dYMax = layer.getFullExtent().getMaxY();
        if (layer instanceof IRasterLayer) {
            IRasterLayer rasterLayer = (IRasterLayer)layer;
            this.m_dCellSize = rasterLayer.getLayerGridExtent().getCellSize();
            this.recalculateNXAndNY();
        } else if (layer instanceof I3DRasterLayer) {
            I3DRasterLayer raster3DLayer = (I3DRasterLayer)layer;
            this.m_dZMin = raster3DLayer.getLayerExtent().getZMin();
            this.m_dZMax = raster3DLayer.getLayerExtent().getZMax();
            this.m_dCellSizeZ = raster3DLayer.getCellSizeZ();
            this.recalculateNZ();
        }
    }

    public void setXRange(double dXMin, double dXMax, boolean bRecalculateWithCellsize) {
        this.m_dXMin = Math.min(dXMin, dXMax);
        this.m_dXMax = Math.max(dXMin, dXMax);
        if (bRecalculateWithCellsize) {
            this.recalculateNXAndNY();
        }
    }

    public void setYRange(double dYMin, double dYMax, boolean bRecalculateWithCellsize) {
        this.m_dYMin = Math.min(dYMin, dYMax);
        this.m_dYMax = Math.max(dYMin, dYMax);
        if (bRecalculateWithCellsize) {
            this.recalculateNXAndNY();
        }
    }

    public void setZRange(double dZMin, double dZMax, boolean bRecalculateWithCellsize) {
        this.m_dZMin = Math.min(dZMin, dZMax);
        this.m_dZMax = Math.max(dZMin, dZMax);
        if (bRecalculateWithCellsize) {
            this.recalculateNZ();
        }
    }

    public double getCellSize() {
        return this.m_dCellSize;
    }

    public void setCellSize(double cellSize) {
        this.m_dCellSize = cellSize <= 0.0 ? 1.0 : cellSize;
        this.recalculateNXAndNY();
    }

    public double getCellSizeZ() {
        return this.m_dCellSizeZ;
    }

    public void setCellSizeZ(double cellSize) {
        this.m_dCellSizeZ = cellSize;
        this.recalculateNZ();
    }

    public int getNX() {
        return this.m_iNX;
    }

    public int getNY() {
        return this.m_iNY;
    }

    public int getNZ() {
        return this.m_iNZ;
    }

    private void recalculateNXAndNY() {
        this.m_iNY = (int)Math.floor((this.m_dYMax - this.m_dYMin) / this.m_dCellSize);
        this.m_iNX = (int)Math.floor((this.m_dXMax - this.m_dXMin) / this.m_dCellSize);
        this.m_dXMax = this.m_dXMin + this.m_dCellSize * (double)this.m_iNX;
        this.m_dYMax = this.m_dYMin + this.m_dCellSize * (double)this.m_iNY;
    }

    private void recalculateNZ() {
        this.m_iNZ = (int)Math.floor((this.m_dZMax - this.m_dZMin) / this.m_dCellSizeZ);
        this.m_dZMax = this.m_dZMin + this.m_dCellSizeZ * (double)this.m_iNZ;
    }

    public double getXMin() {
        return this.m_dXMin;
    }

    public double getXMax() {
        return this.m_dXMax;
    }

    public double getYMin() {
        return this.m_dYMin;
    }

    public double getYMax() {
        return this.m_dYMax;
    }

    public double getZMin() {
        return this.m_dZMin;
    }

    public double getZMax() {
        return this.m_dZMax;
    }

    public double getWidth() {
        return this.m_dXMax - this.m_dXMin;
    }

    public double getLength() {
        return this.m_dYMax - this.m_dYMin;
    }

    public double getHeight() {
        return this.m_dZMax - this.m_dZMin;
    }

    public boolean contains(double x, double y) {
        return x >= this.m_dXMin && x <= this.m_dXMax && y >= this.m_dYMin && y <= this.m_dYMax;
    }

    public boolean contains(double x, double y, double z) {
        return x >= this.m_dXMin && x <= this.m_dXMax && y >= this.m_dYMin && y <= this.m_dYMax && x >= this.m_dZMin && x <= this.m_dZMax;
    }

    public boolean fitsIn(AnalysisExtent extent) {
        double MIN_DIF = 1.0E-5;
        if (extent.getCellSize() != this.getCellSize()) {
            return false;
        }
        double dOffset = Math.abs(extent.getXMin() - this.getXMin());
        double dOffsetCols = dOffset / this.getCellSize();
        boolean bFitsX = dOffsetCols - Math.floor(dOffsetCols + 0.5) < 1.0E-5;
        dOffset = Math.abs(extent.getYMax() - this.getYMax());
        double dOffsetRows = dOffset / this.getCellSize();
        boolean bFitsY = Math.abs(dOffsetRows - Math.floor(dOffsetRows + 0.5)) < 1.0E-5;
        dOffset = Math.abs(extent.getZMax() - this.getZMax());
        double dOffsetZ = dOffset / this.getCellSizeZ();
        boolean bFitsZ = Math.abs(dOffsetZ - Math.floor(dOffsetZ + 0.5)) < 1.0E-5;
        return bFitsX && bFitsY && bFitsZ;
    }

    public boolean equals(AnalysisExtent extent) {
        return this.m_dXMin == extent.getXMin() && this.m_dXMax == extent.getXMax() && this.m_dYMin == extent.getYMin() && this.m_dYMax == extent.getYMax() && this.m_dCellSize == extent.getCellSize() && this.m_dZMin == extent.getZMin() && this.m_dZMax == extent.getZMax() && this.m_dCellSizeZ == extent.getCellSizeZ();
    }

    public void addExtent(AnalysisExtent extent) {
        this.m_dXMin = Math.min(extent.getXMin(), this.m_dXMin);
        this.m_dXMax = Math.max(extent.getXMax(), this.m_dXMax);
        this.m_dYMin = Math.min(extent.getYMin(), this.m_dYMin);
        this.m_dYMax = Math.max(extent.getYMax(), this.m_dYMax);
        this.m_dZMin = Math.min(extent.getZMin(), this.m_dZMin);
        this.m_dZMax = Math.max(extent.getZMax(), this.m_dZMax);
        this.m_dCellSize = Math.min(extent.getCellSize(), this.m_dCellSize);
        this.m_dCellSizeZ = Math.min(extent.getCellSizeZ(), this.m_dCellSizeZ);
        this.recalculateNXAndNY();
        this.recalculateNZ();
    }

    public void addExtent(Rectangle2D extent) {
        this.m_dXMin = Math.min(extent.getMinX(), this.m_dXMin);
        this.m_dXMax = Math.max(extent.getMaxX(), this.m_dXMax);
        this.m_dYMin = Math.min(extent.getMinY(), this.m_dYMin);
        this.m_dYMax = Math.max(extent.getMaxY(), this.m_dYMax);
        this.recalculateNXAndNY();
    }

    public GridCell getGridCoordsFromWorldCoords(Point2D pt) {
        int x = (int)Math.floor((pt.getX() - this.m_dXMin) / this.m_dCellSize);
        int y = (int)Math.floor((this.m_dYMax - pt.getY()) / this.m_dCellSize);
        GridCell cell = new GridCell(x, y, 0.0);
        return cell;
    }

    public GridCell getGridCoordsFromWorldCoords(double x, double y) {
        return this.getGridCoordsFromWorldCoords(new Point2D.Double(x, y));
    }

    public Grid3DCell getGridCoordsFromWorldCoords(double x, double y, double z) {
        int iX = (int)Math.floor((x - this.m_dXMin) / this.m_dCellSize);
        int iY = (int)Math.floor((this.m_dYMax - y) / this.m_dCellSize);
        int iZ = (int)Math.floor((z - this.m_dZMin) / this.m_dCellSizeZ);
        Grid3DCell cell = new Grid3DCell(iX, iY, iZ, 0.0);
        return cell;
    }

    public Point2D getWorldCoordsFromGridCoords(GridCell cell) {
        double x = this.m_dXMin + ((double)cell.getX() + 0.5) * this.m_dCellSize;
        double y = this.m_dYMax - ((double)cell.getY() + 0.5) * this.m_dCellSize;
        Point2D.Double pt = new Point2D.Double(x, y);
        return pt;
    }

    public Point2D getWorldCoordsFromGridCoords(int x, int y) {
        return this.getWorldCoordsFromGridCoords(new GridCell(x, y, 0.0));
    }

    public Coordinate getWorldCoordsFromGridCoords(int x, int y, int z) {
        double dX = this.m_dXMin + ((double)x + 0.5) * this.m_dCellSize;
        double dY = this.m_dYMax - ((double)y + 0.5) * this.m_dCellSize;
        double dZ = this.m_dZMin + ((double)y + 0.5) * this.m_dCellSizeZ;
        Coordinate coord = new Coordinate(dX, dY, dZ);
        return coord;
    }

    public String toString() {
        String s = Double.toString(this.m_dXMin) + ", " + Double.toString(this.m_dYMin) + ", " + Double.toString(this.m_dZMin) + ", " + Double.toString(this.m_dXMax) + ", " + Double.toString(this.m_dYMax) + ", " + Double.toString(this.m_dZMax) + ", " + Double.toString(this.m_dCellSize) + ", " + Double.toString(this.m_dCellSizeZ);
        return s;
    }

    public void enlargeOneCell() {
        this.m_dYMin -= this.m_dCellSize;
        this.m_dXMin -= this.m_dCellSize;
        this.m_dXMax += this.m_dCellSize;
        this.m_dYMax += this.m_dCellSize;
        this.recalculateNXAndNY();
    }

    public Rectangle2D getAsRectangle2D() {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        ((Rectangle2D)rect).setRect(this.m_dXMin, this.m_dYMin, this.m_dXMax - this.m_dXMin, this.m_dYMax - this.m_dYMin);
        return rect;
    }

    public boolean containsCell(int x, int y) {
        return x >= 0 && x < this.m_iNX && y >= 0 && y < this.m_iNY;
    }

    public Geometry getAsJTSGeometry() {
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(this.m_dXMin, this.m_dYMin), new Coordinate(this.m_dXMax, this.m_dYMin), new Coordinate(this.m_dXMax, this.m_dYMax), new Coordinate(this.m_dXMin, this.m_dYMax), new Coordinate(this.m_dXMin, this.m_dYMin)};
        Polygon geom = gf.createPolygon(gf.createLinearRing(coords), null);
        return geom;
    }
}

