/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.docEngines.html;

public class HTMLDoc {
    private final String OPENING_HTML_CODE_1 = "<html>\n<head><title>";
    private final String OPENING_HTML_CODE_2 = "</title>\n</head>\n<body bgcolor=\"#FFFFFF\" text=\"#000000\">\n";
    private final String CLOSING_HTML_CODE = "</body>\n</html>";
    private StringBuffer m_sHTMLCode;

    public void open(String sTitle) {
        this.m_sHTMLCode = new StringBuffer("");
        this.m_sHTMLCode.append("<html>\n<head><title>");
        this.m_sHTMLCode.append(sTitle);
        this.m_sHTMLCode.append("</title>\n</head>\n<body bgcolor=\"#FFFFFF\" text=\"#000000\">\n");
    }

    public void close() {
        this.m_sHTMLCode.append("</body>\n</html>");
    }

    public String getHTMLCode() {
        return this.m_sHTMLCode.toString();
    }

    public void addText(String sText) {
        this.m_sHTMLCode.append(sText);
    }

    public void addBoldText(String sText) {
        this.m_sHTMLCode.append("<b>");
        this.m_sHTMLCode.append(sText);
        this.m_sHTMLCode.append("</b>");
    }

    public void addParagraph(String sText) {
        this.m_sHTMLCode.append("<p align=\"left\">");
        this.m_sHTMLCode.append(sText);
        this.m_sHTMLCode.append("</p>\n");
    }

    public void addLineBreak() {
        this.m_sHTMLCode.append("</br>");
    }

    public void addHeader(String sText, int iOrder) {
        this.m_sHTMLCode.append("<h");
        this.m_sHTMLCode.append(iOrder);
        this.m_sHTMLCode.append(" align=\"left\">");
        this.m_sHTMLCode.append(sText);
        this.m_sHTMLCode.append("</h");
        this.m_sHTMLCode.append(iOrder);
        this.m_sHTMLCode.append(">\n");
    }

    public void addHyperlink(String sText, String sURL) {
        this.m_sHTMLCode.append("<a href=\"");
        this.m_sHTMLCode.append(sURL);
        this.m_sHTMLCode.append("\">\n");
        this.m_sHTMLCode.append(sText);
        this.m_sHTMLCode.append("\n</a>");
    }

    public void addHorizontalSeparator() {
        this.m_sHTMLCode.append("<p><hr width=\"80%\"></p>");
    }

    public void addImage(String sFilename) {
        this.m_sHTMLCode.append("<img src=\"");
        this.m_sHTMLCode.append(sFilename);
        this.m_sHTMLCode.append("\">\n");
    }

    public void addThumbnail(String sFilename, int iWidth, boolean bIsPercent) {
        this.m_sHTMLCode.append("<a href=\"");
        this.m_sHTMLCode.append(sFilename);
        this.m_sHTMLCode.append("\">\n");
        this.m_sHTMLCode.append("<img src=\"");
        this.m_sHTMLCode.append(sFilename);
        this.m_sHTMLCode.append("\" width=");
        this.m_sHTMLCode.append(iWidth);
        if (bIsPercent) {
            this.m_sHTMLCode.append("%");
        }
        this.m_sHTMLCode.append("></a><br><br>\n");
    }

    public void startUnorderedList() {
        this.m_sHTMLCode.append("<ul>\n");
    }

    public void startOrderedList() {
        this.m_sHTMLCode.append("<ol>\n");
    }

    public void closeUnorderedList() {
        this.m_sHTMLCode.append("</ul>\n");
    }

    public void closeOrderedList() {
        this.m_sHTMLCode.append("</ol>\n");
    }

    public void addListElement(String sText) {
        this.m_sHTMLCode.append("<li>");
        this.m_sHTMLCode.append(sText);
        this.m_sHTMLCode.append("</li>\n");
    }

    public void addOrderedList(String[] sText) {
        this.startOrderedList();
        for (int i = 0; i < sText.length; ++i) {
            this.addListElement(sText[i]);
        }
        this.closeOrderedList();
    }

    public void addUnorderedList(String[] sText) {
        this.startUnorderedList();
        for (int i = 0; i < sText.length; ++i) {
            this.addListElement(sText[i]);
        }
        this.closeUnorderedList();
    }

    public void addTable(String[][] Table, String sDescription, boolean bColorFirstRow, boolean bColorFirstCol) {
        int iRows = Table.length;
        if (iRows <= 0) {
            return;
        }
        int iCols = Table[0].length;
        int iWidth = 100 / iCols;
        this.m_sHTMLCode.append("<table width=\"99%\" style=\"background-color:transparent;\" border=0 cellspacing=0 cellpadding=2 >\n");
        for (int i = 0; i < iRows; ++i) {
            if (i == 0 && bColorFirstRow) {
                this.m_sHTMLCode.append("<tr bgcolor=\"#CCCCCC\">\n");
            } else {
                this.m_sHTMLCode.append("<tr>\n");
            }
            for (int j = 0; j < iCols; ++j) {
                this.m_sHTMLCode.append("<td width=\"");
                this.m_sHTMLCode.append(iWidth);
                this.m_sHTMLCode.append("%\"");
                if (j == 0 & bColorFirstCol) {
                    this.m_sHTMLCode.append("bgcolor=\"#CCCCCC\"");
                }
                this.m_sHTMLCode.append("align=\"center\">");
                try {
                    this.m_sHTMLCode.append(Table[i][j]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_sHTMLCode.append("</td>");
            }
            this.m_sHTMLCode.append("\n</tr>\n");
        }
        this.m_sHTMLCode.append("\n</table>\n");
        this.m_sHTMLCode.append("<p align=\"center\"><i>");
        this.m_sHTMLCode.append(sDescription);
        this.m_sHTMLCode.append("</i></p>\n");
    }

    public void addImageAndDescription(String sImageFile, String sDescription) {
        this.m_sHTMLCode.append("<p><center>\n");
        this.m_sHTMLCode.append("<img src=\"");
        this.m_sHTMLCode.append(sImageFile);
        this.m_sHTMLCode.append("\"><br>\n");
        this.m_sHTMLCode.append(sDescription);
        this.m_sHTMLCode.append("\n</center></p>\n");
    }

    public void addCourierText(String sText) {
        this.m_sHTMLCode.append("<font face=\"courier\">");
        this.m_sHTMLCode.append(sText);
        this.m_sHTMLCode.append("</font>");
    }
}

