/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.io3d;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.io3d.Default3DRasterLayer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ASCII3DFileTools {
    public static I3DRasterLayer readFile(File file) throws IOException, NumberFormatException {
        String s = new String();
        BufferedReader fin = new BufferedReader(new FileReader(file));
        s = fin.readLine();
        String[] sTokens = s.split(" ");
        int iX = Integer.parseInt(sTokens[0]);
        int iY = Integer.parseInt(sTokens[1]);
        int iZ = Integer.parseInt(sTokens[2]);
        s = fin.readLine();
        sTokens = s.split(" ");
        double dX = Double.parseDouble(sTokens[0]);
        double dY = Double.parseDouble(sTokens[1]);
        double dZ = Double.parseDouble(sTokens[2]);
        s = fin.readLine();
        sTokens = s.split(" ");
        double dCellsize = Double.parseDouble(sTokens[0]);
        double dCellsizeZ = Double.parseDouble(sTokens[1]);
        AnalysisExtent ae = new AnalysisExtent();
        ae.setCellSize(dCellsize);
        ae.setCellSizeZ(dCellsizeZ);
        ae.setXRange(dX, dX + (double)iX * dCellsize, true);
        ae.setYRange(dY, dY + (double)iY * dCellsize, true);
        ae.setZRange(dZ, dZ + (double)iZ * dCellsizeZ, true);
        Default3DRasterLayer layer = new Default3DRasterLayer();
        layer.create("", file.getAbsolutePath(), ae, null);
        for (int z = 0; z < iZ; ++z) {
            for (int y = 0; y < iY; ++y) {
                s = fin.readLine();
                sTokens = s.split(" ");
                for (int x = 0; x < iX; ++x) {
                    layer.setCellValue(x, y, z, Double.parseDouble(sTokens[x]));
                }
            }
        }
        fin.close();
        return layer;
    }

    public static boolean writeFile(I3DRasterLayer layer, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(writer);
            AnalysisExtent extent = layer.getLayerExtent();
            out.write(Integer.toString(extent.getNX()) + " " + Integer.toString(extent.getNY()) + " " + Integer.toString(extent.getNZ()) + "\n");
            out.write(Double.toString(extent.getXMin()) + " " + Double.toString(extent.getYMin()) + " " + Double.toString(extent.getZMin()) + "\n");
            out.write(Double.toString(layer.getCellSize()) + " " + Double.toString(layer.getCellSizeZ()) + "\n");
            for (int z = 0; z < layer.getNZ(); ++z) {
                for (int y = 0; y < layer.getNY(); ++y) {
                    int x;
                    for (x = 0; x < layer.getNX() - 1; ++x) {
                        out.write(Double.toString(layer.getCellValueAsDouble(x, y, z)) + " ");
                    }
                    out.write(Double.toString(layer.getCellValueAsDouble(x, y, z)) + "\n");
                }
            }
            out.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

