/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.outputs;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.outputs.Output;

public class OutputRasterLayer
extends Output {
    public static final int NUMBER_OF_BANDS_UNDEFINED = -1;
    private int m_iNumberOfBands = -1;

    @Override
    public void setOutputObject(Object obj) {
        if (obj instanceof IRasterLayer || obj == null) {
            this.m_Object = obj;
        }
    }

    @Override
    public String getCommandLineParameter() {
        if (this.m_OutputChannel == null) {
            return "\"#\"";
        }
        return "\"" + this.m_OutputChannel.getAsCommandLineParameter() + "\"";
    }

    public int getNumberOfBands() {
        return this.m_iNumberOfBands;
    }

    public void setNumberOfBands(int numberOfBands) {
        if (numberOfBands < 1) {
            numberOfBands = -1;
        }
        this.m_iNumberOfBands = numberOfBands;
    }

    @Override
    public Output getNewInstance() {
        Output out = super.getNewInstance();
        ((OutputRasterLayer)out).setNumberOfBands(this.m_iNumberOfBands);
        return out;
    }

    @Override
    public void setObjectData(Output output) {
        super.setObjectData(output);
        if (output instanceof OutputRasterLayer) {
            this.setNumberOfBands(((OutputRasterLayer)output).getNumberOfBands());
        }
    }

    @Override
    public String getTypeDescription() {
        return Sextante.getText("raster");
    }
}

