/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfo3DRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import es.unex.sextante.additionalInfo.AdditionalInfoRasterLayer;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterDataObject;
import java.io.IOException;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class Parameter3DRasterLayer
extends ParameterDataObject {
    @Override
    public String getParameterTypeName() {
        return "3D Raster Layer";
    }

    @Override
    public I3DRasterLayer getParameterValueAs3DRasterLayer() throws NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return (I3DRasterLayer)this.m_ParameterValue;
        }
        if (((AdditionalInfo3DRasterLayer)this.m_ParameterAdditionalInfo).getIsMandatory()) {
            throw new NullParameterValueException();
        }
        return null;
    }

    @Override
    public IRasterLayer getParameterValueAsRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public ITable getParameterValueAsTable() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public IVectorLayer getParameterValueAsVectorLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean setParameterAdditionalInfo(AdditionalInfo additionalInfo) {
        if (additionalInfo instanceof AdditionalInfoRasterLayer) {
            this.m_ParameterAdditionalInfo = additionalInfo;
            return true;
        }
        return false;
    }

    @Override
    public boolean setParameterValue(Object value) {
        if (value instanceof I3DRasterLayer) {
            this.m_ParameterValue = value;
            return true;
        }
        if (value == null) {
            if (((AdditionalInfo3DRasterLayer)this.m_ParameterAdditionalInfo).getIsMandatory()) {
                return false;
            }
            this.m_ParameterValue = null;
            return true;
        }
        return false;
    }

    @Override
    public Class getParameterClass() {
        return I3DRasterLayer.class;
    }

    public static Parameter deserialize(KXmlParser parser) throws XmlPullParserException, IOException {
        boolean bMandatory = false;
        int tag = parser.nextTag();
        boolean bOver = false;
        while (!bOver) {
            switch (tag) {
                case 2: {
                    String sName;
                    if (parser.getName().compareTo("attribute") != 0 || (sName = parser.getAttributeValue("", "name")).compareTo("mandatory") != 0) break;
                    bMandatory = parser.getAttributeValue("", "value").equals("true");
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("input") != 0) break;
                    bOver = true;
                    break;
                }
            }
            if (bOver) continue;
            tag = parser.next();
        }
        Parameter3DRasterLayer param = new Parameter3DRasterLayer();
        AdditionalInfo3DRasterLayer ai = new AdditionalInfo3DRasterLayer(bMandatory);
        param.setParameterAdditionalInfo(ai);
        return param;
    }

    @Override
    public String getCommandLineParameter() {
        I3DRasterLayer layer = (I3DRasterLayer)this.m_ParameterValue;
        if (layer == null) {
            return "\"#\"";
        }
        return "\"" + layer.getName() + "\"";
    }

    @Override
    public boolean isParameterValueCorrect() {
        AdditionalInfoDataObject aido = (AdditionalInfoDataObject)this.m_ParameterAdditionalInfo;
        if (this.m_ParameterValue == null) {
            return !aido.getIsMandatory();
        }
        return true;
    }
}

