/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleTableField;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.Parameter;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class ParameterMultipleTableField
extends Parameter {
    private static final String PARENT = "parent";
    private static final String MANDATORY = "mandatory";

    @Override
    public String getParameterTypeName() {
        return "Multiple Table Field";
    }

    @Override
    public IRasterLayer getParameterValueAsRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public I3DRasterLayer getParameterValueAs3DRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public ITable getParameterValueAsTable() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public IVectorLayer getParameterValueAsVectorLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    public ArrayList getParameterValueAsMultipleRasterLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    public ArrayList getParameterValueAsMultipleVectorLayer() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    public ArrayList getParameterValueAsMultipleTable() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public int getParameterValueAsInt() throws WrongParameterTypeException, NullParameterValueException {
        throw new WrongParameterTypeException();
    }

    @Override
    public double getParameterValueAsDouble() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean getParameterValueAsBoolean() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public String getParameterValueAsString() throws WrongParameterTypeException, NullParameterValueException {
        if (this.m_ParameterValue != null) {
            return ((Integer)this.m_ParameterValue).toString();
        }
        throw new NullParameterValueException();
    }

    @Override
    public Point2D getParameterValueAsPoint() throws WrongParameterTypeException {
        throw new WrongParameterTypeException();
    }

    @Override
    public boolean setParameterAdditionalInfo(AdditionalInfo additionalInfo) {
        if (additionalInfo instanceof AdditionalInfoMultipleTableField) {
            this.m_ParameterAdditionalInfo = additionalInfo;
            return true;
        }
        return false;
    }

    @Override
    public boolean setParameterValue(Object value) {
        if (value instanceof ArrayList) {
            this.m_ParameterValue = value;
            return true;
        }
        return false;
    }

    public boolean setParameterValue(int iValue) {
        Integer Value = new Integer(iValue);
        this.m_ParameterValue = Value;
        return true;
    }

    @Override
    public Class getParameterClass() {
        return Integer.class;
    }

    @Override
    protected void serializeAttributes(KXmlSerializer serializer) throws NullParameterAdditionalInfoException, IOException {
        AdditionalInfoTableField aitf = (AdditionalInfoTableField)this.m_ParameterAdditionalInfo;
        if (aitf == null) {
            throw new NullParameterAdditionalInfoException();
        }
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", PARENT);
        serializer.attribute(null, "value", aitf.getParentParameterName());
        serializer.endTag(null, "attribute");
        serializer.text("\n");
        serializer.text("\t\t\t");
        serializer.startTag(null, "attribute");
        serializer.attribute(null, "name", MANDATORY);
        serializer.attribute(null, "value", Boolean.valueOf(aitf.getIsMandatory()).toString());
        serializer.endTag(null, "attribute");
    }

    public static Parameter deserialize(KXmlParser parser) throws XmlPullParserException, IOException {
        String sParent = null;
        boolean bMandatory = true;
        int tag = parser.nextTag();
        boolean bOver = false;
        while (!bOver) {
            switch (tag) {
                case 2: {
                    if (parser.getName().compareTo("attribute") != 0) break;
                    String sName = parser.getAttributeValue("", "name");
                    if (sName.compareTo(PARENT) == 0) {
                        sParent = parser.getAttributeValue("", "value");
                        break;
                    }
                    if (sName.compareTo(PARENT) != 0) break;
                    String sMandatory = parser.getAttributeValue("", "value");
                    bMandatory = Boolean.parseBoolean(sMandatory);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("input") != 0) break;
                    bOver = true;
                    break;
                }
            }
            if (bOver) continue;
            tag = parser.next();
        }
        ParameterMultipleTableField param = new ParameterMultipleTableField();
        AdditionalInfoTableField ai = new AdditionalInfoTableField(sParent, bMandatory);
        param.setParameterAdditionalInfo(ai);
        return param;
    }

    @Override
    public String getCommandLineParameter() {
        Integer i = (Integer)this.m_ParameterValue;
        return "\"" + i.toString() + "\"";
    }

    @Override
    public boolean isParameterValueCorrect() {
        return this.m_ParameterValue != null;
    }
}

