/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.impl;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.catalog.CatalogManager;
import org.gvsig.catalog.drivers.ICatalogServiceDriver;
import org.gvsig.catalog.loaders.LayerLoader;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.catalog.schemas.UnknownRecord;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.utils.swing.jcomboServer.ServerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCatalogManager
implements CatalogManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCatalogManager.class);
    private static final String DRIVER_REGISTER_NAME = "CatalogDrivers";
    private ArrayList records = new ArrayList();
    private static TreeMap loadersPool = null;
    private Map<String, ServerData> serversPersistence = null;

    public DefaultCatalogManager() {
        loadersPool = new TreeMap();
    }

    @Override
    public ICatalogServiceDriver getDriver(String protocol) {
        ExtensionPointManager extensionPointManager = ToolsLocator.getExtensionPointManager();
        ExtensionPoint extensionPoint = extensionPointManager.add(DRIVER_REGISTER_NAME);
        for (ExtensionPoint.Extension extension : extensionPoint) {
            try {
                ICatalogServiceDriver driver = (ICatalogServiceDriver)extension.create();
                if (driver.getServiceName().toLowerCase().compareTo(protocol.toLowerCase()) != 0) continue;
                return driver;
            }
            catch (InstantiationException e) {
                logger.error("Impossible to create a catalog driver", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("Impossible to create a catalog driver", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public ICatalogServiceDriver[] getDrivers() {
        ICatalogServiceDriver[] drivers = null;
        ExtensionPointManager extensionPointManager = ToolsLocator.getExtensionPointManager();
        ExtensionPoint extensionPoint = extensionPointManager.add(DRIVER_REGISTER_NAME);
        drivers = new ICatalogServiceDriver[extensionPoint.getCount()];
        Iterator extensions = extensionPoint.iterator();
        int i = 0;
        while (extensions.hasNext()) {
            ExtensionPoint.Extension extension = (ExtensionPoint.Extension)extensions.next();
            try {
                ICatalogServiceDriver driver;
                drivers[i] = driver = (ICatalogServiceDriver)extension.create();
            }
            catch (InstantiationException e) {
                logger.error("Impossible to create a catalog driver", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("Impossible to create a catalog driver", (Throwable)e);
            }
            ++i;
        }
        return drivers;
    }

    @Override
    public void register(String name, Class driver) {
        ExtensionPointManager extensionPointManager = ToolsLocator.getExtensionPointManager();
        ExtensionPoint extensionPoint = extensionPointManager.add(DRIVER_REGISTER_NAME);
        extensionPoint.append(name.toLowerCase(), "", driver);
    }

    @Override
    public void addRecord(Record record) {
        this.records.add(record);
    }

    @Override
    public Record createRecord(URI uri, XMLNode node) {
        for (int i = 0; i < this.records.size(); ++i) {
            Record record = (Record)this.records.get(i);
            if (node == null || !record.accept(uri, node)) continue;
            Object[] values = new Object[]{uri, node};
            Class[] types = new Class[]{URI.class, XMLNode.class};
            try {
                return (Record)record.getClass().getConstructor(types).newInstance(values);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new UnknownRecord(uri, node);
    }

    @Override
    public void addLayerLoader(String key, Class loader) {
        loadersPool.put(key, loader);
    }

    @Override
    public LayerLoader getLayerLoader(Resource resource) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String resourceType = resource.getType();
        if (StringUtils.equals((CharSequence)"UNKNOWN", (CharSequence)resourceType) && StringUtils.isBlank((CharSequence)resource.getProtocol()) && StringUtils.isNotBlank((CharSequence)resource.getLinkage())) {
            resourceType = "WWW:DOWNLOAD";
        }
        if (loadersPool.containsKey(resourceType)) {
            Class llClass = (Class)loadersPool.get(resourceType);
            Class[] args = new Class[]{Resource.class};
            Object[] params = new Object[]{resource};
            return (LayerLoader)llClass.getConstructor(args).newInstance(params);
        }
        return null;
    }

    @Override
    public Map<String, ServerData> getServersPersistence() {
        return this.serversPersistence;
    }

    @Override
    public void setServersPersistence(Map<String, ServerData> serversPersistence) {
        this.serversPersistence = serversPersistence;
    }
}

